/******************************************  
        CMSC 681 Porject
                "TSP protocol in PKI"

        by Youyong Zou   12/2/00
*******************************************/

/*
TSP Head file.
*/

#ifndef _TSP_HEAD_FILE
#define _TSP_HEAD_FILE

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/wait.h>
#include <ctype.h>
#include <signal.h>
#include <errno.h>
#include <dirent.h>
#include <stdarg.h>
#include <malloc.h>
#include <sys/time.h>
#include <sys/select.h>
#include <arpa/inet.h>


#define 	TSP_REQ_PORT	8633	/* TSP server port */
#define 	TSP_REP_PORT	8634	/* TSP client receive response from this port*/
#define		TSP_TIMEOUT	10
#define 	MAXLEN		30

/* define of PKI status */
#define	GEANTED		0	/* a time stamp token is presented */
#define	GRANTEDWITHMODS	1 /* time stamp token with modification is presneted */
#define	REJECTION	2	
#define	WAITING		3
#define	REVOCATIONWARNING	4 /* warning that a revocation is imminent */
#define	REVOCATIONNOTIFICATION	5 /* notify that a revocation has occured */
	
/* define of failure reason */
#define 	BADALG		0	/* unrecognized  algorithm ID */
#define	BADREQUEST		2	/* transaction not supported */
#define	BADDATAFORMAT		5	/* data submited has wrong format */
#define	TIMENOTAVAILABLE	14	/* TSA's time source is not available *
#define	UNACCEPTEDPOLICY	15	/* requested TSA policy not supported */
#define	UNACCEPTEDEXTENSION	16	/* requested extension not supported */
#define	ADDINFONOTAVAILABLE	17	/* additional information could not be understood */


typedef struct {
	int		version;	/* default v1(1) */
	char    	hashAlgorithm[MAXLEN];
                /* hash function to be used, must be a known algorithms,
                        such as : SHA-1 or MD5*/
        char    	hashedMessage[80];
                /* a OCTET string, its length must match the length of hash
                value for that algorithm ( eg. 20 byte for SHA-1, 16 for MD5) */
	int		reqPolicy; 	
		/* TSA policy which the TimeStampToken SHOULD be provided */
	int		nonce;		
		/* verify the timelines of the response when no 
			local clock is available */

	int		certreq ;
		/* TSA's public key certificate MUST be 
			provided if set to 1 */
	char		client_name[50];
	char		extensions[MAXLEN]; 	
		/* additional information for future */
} TimeStampReq;

typedef struct TimeStampResp {
/* PKI Status */
	int             status;         /* PKI  status */
        char            statusString[MAXLEN];   /* PKI free text */
        int             fallinfo;       /* reason of time stamp rejection */

/* TimeStamp Token */
        char            contenttype[10];            /* id-signedData */
        char            content[256];            /* signedData */

	char		failinfo[MAXLEN]; /* PKI Failure information */
} TimeStampResp ;

typedef struct {
	int             version;        /* default v1(1) */
        char            hashAlgorithm[MAXLEN];
                /* hash function to be used, must be a known algorithms,
                        such as : SHA-1 or MD5*/
        char            hashedMessage[80];
                /* a OCTET string, its length must match the length of hash
                value for that algorithm ( eg. 20 byte for SHA-1, 16 for MD5) */
        int             reqPolicy;
                /* TSA policy which the TimeStampToken SHOULD be provided */
        int             serialNumber; /* timestamp serial number */
        char             gentime[60] ;
        int             accurity;  /* second, millis or micros */
        int             ordering; /*Time stamp token ordered based on gentime */
        char            extensions[MAXLEN];
                /* additional information for future */
} TimeStampToken;

struct cmdsw {
        char    *cmd;           /* command name */
        int     a1;             /* minium arg num */
        int     a2;             /* maxium arg num */
        int     (*fun)();       /*function */
};

char	server_ip[50]; /* TSP Server 's IP address */

#endif /* _TSP_HAED_FILE */
