/******************************************  
        CMSC 681 Porject
                "TSP protocol in PKI"

        by Youyong Zou   12/2/00
*******************************************/

/*
TSP server: accept request, send back response token 
*/

#include "tspdef.h"

main(argc, argv)
int	argc;
char	**argv;
{
	int	i, n ,sockid;
	fd_set	fdset;
	struct sockaddr_in	serv_addr;
	TimeStampReq  databuf;
	char    *tmp, name[50];

	if(argc!=2){
                printf("Usage: tsp_server certificate \n");
                exit(-1);
        }

	gethostname(name, 50);
	fprintf(stderr,"Start TSP SERVER at : %s \n",name);
	fprintf(stderr,"  Certificate file:  %s  \n", argv[1]);
	fprintf(stderr,"  Download from http://www.cs.umbc.edu/~yzou1/yzou1@cs.umbc.edu.p12  \n");
	fprintf(stderr,"------------------------------------\n");

	/* create socket */
	if((sockid = socket(AF_INET, SOCK_DGRAM, 0)) < 0){
		fprintf(stderr,"Socket create error! \n");
		exit(-1);
	}

	/* init addr information */
	bzero((char *)&serv_addr, sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	serv_addr.sin_port = htons(TSP_REQ_PORT); /* listen to Request_PORT */

	/* bind socket to request_port */
	if( bind(sockid,(struct sockaddr *)&serv_addr,sizeof(serv_addr)) < 0){
		fprintf(stderr,"Socket bind error! \n");
                exit(-1);
	}

	while(1){
		TimeStampResp   ch;

	fprintf(stderr,"\n  Listenning port 8633... \n\n");
	  	FD_ZERO(&fdset);
	  	FD_SET(sockid, &fdset);
	
/* select, listen on port TSP_REQ_PORT */
	  	n = select(sockid+1, &fdset, (fd_set *)0, (fd_set *)0, NULL);
		

		fprintf(stderr," 	Receive a REQUEST  \n");

		/* read a request data from socket */
		tmp = (char *)&databuf;
		i = read(sockid, tmp, 
			sizeof(TimeStampReq));

		/* get digest number from request */
		
		fprintf(stderr," 	It from %s \n", databuf.client_name);

		fprintf(stderr," 	Digest Algorithm = %s\n", databuf.hashAlgorithm);
		fprintf(stderr," 	MD Number = %s \n", databuf.hashedMessage);
		
		/* compose TimeStampToken , include message digest 
			number, date ,time */

		{
			TimeStampToken	chtoken;
        		char    *tmp, *ch1 = "\0";
			FILE    *fp, *fopen ();
			time_t local_time, *local_time1;
	 		char    *tmp_str;
			   FILE    *fp1;
                char buffer[100];

			

        		tmp_str = (char *)malloc(sizeof(char)*50);

			chtoken.version = databuf.version;
			strcpy(chtoken.hashAlgorithm, databuf.hashAlgorithm);
			strcpy(chtoken.hashedMessage, databuf.hashedMessage);
			chtoken.reqPolicy = databuf.reqPolicy;
			chtoken.serialNumber = 10;

			system("date >a");
			if ((fp1 = fopen ("a", "r")) == NULL) {
                                fprintf (stderr, "Read a fail!\n");
                                return;
                	}
                	fgets(buffer,256,fp1);
			
			strcpy(chtoken.gentime, buffer);
			chtoken.ordering = 1;
			chtoken.accurity = 1;

        		if ((fp = fopen ("tmpfile", "w")) == NULL) {
                		fprintf (stderr, "Open tmpfile fail!\n");
                		return;
        		}

        		sprintf(tmp_str, "%d\n",chtoken.version);
			fputs(tmp_str, fp);
			sprintf(tmp_str, "%s\n",chtoken.hashAlgorithm);
                        fputs(tmp_str, fp);
			sprintf(tmp_str, "%s\n",chtoken.hashedMessage);
                        fputs(tmp_str, fp);
			sprintf(tmp_str, "%s",chtoken.gentime);
                        fputs(tmp_str, fp);
			sprintf(tmp_str, "%d\n",chtoken.ordering);
                        fputs(tmp_str, fp);
			sprintf(tmp_str, "%d\n",chtoken.accurity);
                        fputs(tmp_str, fp);

			fclose(fp);
		}

		fprintf(stderr," 	Sign TimeStampToken using Server Certificate \n" );

		/* use TSP Server's certificate to signed TimeStampToken */
fprintf(stderr,"  	ssleay enc -in tmpfile -out tmpfile.1 -e -a -k abc \n");
               	system("./ssleay enc -in tmpfile -out tmpfile.1 -e -a -k abc ");
		
		/* compose TimeStampResp message, add Token into messagebody */
		{
			FILE *sf;
    			char buffer[256];
			int i=0;

    			if ((sf=fopen("tmpfile.1","r")) == NULL) {
                		fprintf (stderr, "Read tmpfile fail!\n");
        			return 0;
    			}
			
			while ((buffer[i]=fgetc(sf))!=EOF)
				i++;
			buffer[i] = '\0';
			
			fclose(sf);

			ch.status = 0 ;
                        strcpy(ch.statusString, "Granted");
                        strcpy(ch.contenttype, "pkcs");
			strcpy(ch.content, buffer);
		}
		sleep(2);
			
		fprintf(stderr,"  	Send Response Message to client %s \n", databuf.client_name);

		/* send response message to client */
		{
		        int     sock;
                        struct sockaddr_in  address;
                        struct hostent  *hp;
                        char    name[50] ;
                        u_long  iaddr;
                        time_t local_time, *local_time1;

			/* create a socket to client */
                        sock = socket(AF_INET, SOCK_DGRAM, 0);
                        if(sock<0){
                                perror("SOCK");
                                return;
                        }

                        hp = gethostbyname(databuf.client_name);
                        address.sin_family = AF_INET;
                        bcopy(hp->h_addr_list[0], (caddr_t)&address.sin_addr,
                                        hp->h_length);
			/* specify port TSP_REP_PORT */
                        address.sin_port = TSP_REP_PORT;

			tmp=(char *)&ch;

			/* send out a token */
			i = sendto(sock, tmp, sizeof( TimeStampResp),0,
		 		(struct sockaddr *)&address, sizeof(address));

        		if(i<0){
                		perror("Sendto");
                		return;
        		}
			close(sock);
		}
	}
}

