/******************************************  
        CMSC 681 Porject
                "TSP protocol in PKI"

        by Youyong Zou   12/2/00
*******************************************/

/* 
include the command that user can input. It will check
the format of the command and run it 
*/

#include "tspdef.h"

int help_cmd();		/* help message */
int request_cmd();	/* send request message to TSP server */
int quit_cmd();		/* quit this client */
int info_cmd();		/* print information about this project */
int certificate_cmd();	/* get TSP server's certificate  */
int digest_cmd();	/* compute a message digest number */
int verify_cmd();	/* verify a timestamped file using TSP server's certificate */
int connect_cmd();	/* connect to specified TSP server */

/* map input command to function */
struct cmdsw commands[] = {
	{ "help",    1, 2, help_cmd		},
	{ "digest",   2, 3, digest_cmd	},
	{ "connect",   2, 0, connect_cmd	},
	{ "certificate",   3, 0, certificate_cmd	},
	{ "verify",   3, 0, verify_cmd	},
	{ "request",   3, 0, request_cmd	},
	{ "quit",    1, 1, quit_cmd		},
	{ "info",    1, 1, info_cmd		},
	{ 0, 0, 0, 0 }
};

/* call the specified command */
docmd(cmd)
	char *cmd;
{
	char *p;
	struct cmdsw *csp;
	struct alias *ap;
	int i;
	int ac;
	char *av[128];
	int self;

	ac = sizeof(av)/sizeof(av[0]) - 1;
	if (acav(cmd, &ac, av)) {
		fputs("command too long\n", stdout);
		return 0;
	}
	if (!ac)
		return 0;

	av[ac] = 0;
	p = av[0];
	for (csp = commands; csp->cmd; csp++) {
		if (!strcmp(csp->cmd, p)) {
			if (ac >= csp->a1 && (ac <= csp->a2 || !csp->a2))
				(csp->fun)(ac, av);
			else
				printf("%s: wrong #args\n", p);
			break;
		}
	}
	if (!csp->cmd)
		printf("%s: not found\n", p);
	return 0;
}

/* extract command , parameter from argv */
int acav(s, acp, av)
	char *s;
	int *acp;
	char **av;
{
	int ac = 0;	/* number of words found	*/
	char *p = s;	/* input scanner		*/
	char *q;	/* output			*/
	int n = *acp;	/* max number of words allowed	*/
	int mode = 0;	/* quote mode			*/

	while (*p) {
		while (isspace(*p))
			p++;

		if (*p) {
			if (*p == '#')	/* comment line?		*/
				break;
			if (ac >= n) {	/* too many words?		*/
				*acp = ac;
				return (1);
			}

			q = p;
			av[ac++] = p;
			while (*p) {
				if (mode) {
					if (mode == '\\') {
						*q++ = *p;
						mode = 0;

					} else if (mode == *p) {
						mode = 0;

					} else
						*q++ = *p;

				} else {
					if (isspace(*p))
						break;

					switch (*p) {
					case '"'	:
					case '\''	:
					case '\\'	:
						mode = *p;
						break;

					default		:
						*q++ = *p;
						break;
					}
				}
				p++;
			}

			if (*p)
				p++;
			if (*q)
				*q = 0;
			if (mode) {
				printf("unmatched %c\n", (char)mode);
				return -1;
			}
		}
	}
	*acp = ac;
	return 0;
}

/* map string to int */
int xtoi (p)
	char *p;
{
	int i = 0;
	char c;

	while (isxdigit(c = *p++))
		i = (i << 4) + c - (isdigit(c) ? '0' : (isupper(c) ? 'A' : 'a') - 10);
	return (i);
}

/* another map from string to int */
int axtoi(p)
	char *p;
{
	if (p[0] == '0' && p[1] == 'x')
		return (xtoi(p + 2));
	else
		return (atoi(p));
}


/****************
 **  Commands  **
 ****************/

/* hell message */
static char *helptx[] = {

	"help HELP        - Print helpful information about a command",
	"help Syntax:  help [ command ]",

	"request REQUEST     - Request a time stamp token from a TSP server",
        "request Syntax:  request ts_file MD_Number ",

	"quit QUIT        - Exit tsppki console",
	"quit Syntax:  quit",

	"digest DIGEST      - Compute a Message-Digest number for a file",
        "digest Syntax:  digest [digest_algorithm] filename",
        "digest Syntax:  digest_algorithm include md5, md2, sha1, sha, mdc2", 

        "certificate CERTIFICATE - Get TSP server's certificate, save to file",
        "certificate Syntax:  certificate ServeCcertifictae filename",


	"connect CONNECT     - Connect to TSP server",
        "connect Syntax:  connect tspserver",

	"verify VERIFY      - Verify a Timestamp",
        "verify Syntax:  verify certificate ts_file",

	"info INFO        - Show information",
	"info Syntax:  info",
	0
};

/* help command, either type help or help command */
help_cmd(ac, av)
	int ac;
	char **av;
{
	char **p;
	char *topic;
	int l;
	struct cmdsw *csp;

	/* if not specified, topic = help */
	if (ac > 1)
		topic = av[1];
	else
		topic = "help";

	l = strlen(topic);

	/* search through messages for ones matching topic */
	for (p = helptx; *p; p++) {
		if (!strncmp(topic, *p, l) && ((*p)[l] == ' ' || (*p)[l] == '-'))
			printf("%s\n", (*p) + l + 1);
	}

	if (!strcmp(topic, "help")) {
		printf("Commands are:\n");
		for (csp = commands; csp->cmd; csp++) {
			l = strlen(csp->cmd);
			for (p = helptx; *p; p++)
				if (!strncmp(csp->cmd, *p, l) && (*p)[l] == ' ') {
					printf("  %s\n", (*p) + l + 1);
					break; /*just print meet first */
				}
		}
	}
	return 0;
}

/* request a TSP token from TSP server */
int request_cmd(ac,av)
	int ac;
        char **av;	
{
	char	*tmp3, name[50];
       	int     sockid,i, n;
       	struct 	sockaddr_in      serv_addr;
	static struct timeval   timeout;
	fd_set  fdset;
	TimeStampResp databuf;
	char 	*tmp;

	if (server_ip[0]=='\0')
	{
		fprintf(stderr,"You need Connect first ! \n" );
		return;
	}

	/* open a socket */
	if((sockid = socket(AF_INET, SOCK_DGRAM, 0)) < 0){
                perror("socket:");
		return;
        }
        bzero((char *)&serv_addr, sizeof(serv_addr));
        serv_addr.sin_family = AF_INET;
        serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
 	/* listen to response port for reply from server */	
        serv_addr.sin_port = TSP_REP_PORT;

        if( bind(sockid,(struct sockaddr *)&serv_addr,sizeof(serv_addr)) < 0){
                perror("bind:");
		return;
        }

	FD_ZERO(&fdset);
	FD_SET(sockid, &fdset);
	timeout.tv_sec = TSP_TIMEOUT;
	timeout.tv_usec = 0;

fprintf(stderr,"Send TSP request to Server  %s \n", server_ip );
	/* send out TSP request to server_ip */
        send_request(server_ip, av[2]);

/* select incoming message for response */
	n = select(sockid+1, &fdset, (fd_set *)0, (fd_set *)0, &timeout);

	if(n==0){     /* timeout after TSP_TIMEOUT seconds  */
		fprintf(stderr,"No Responce from TSP server %s \n",av[1]);
		close(sockid);
                return;
	}
	else if(n<-1){        /* socket error */
                perror("select:");
		close(sockid);
		return;
	}
	else
	{ 	/* received a response */
		FILE    *fp, *fopen ();
		char buffer[100];

		tmp = (char *) &databuf;
		/* read token from socket */
		i = read(sockid, tmp, sizeof (TimeStampResp));

		fprintf(stderr,"Got Response from TSA Server \n");
                fprintf(stderr,"	statusString = %s \n", databuf.statusString);
                fprintf(stderr,"	contenttype = %s \n", databuf.contenttype);

		/* write token to a file, for ssleay to decrypt it */
		if ((fp = fopen (av[1], "w")) == NULL) {
                                fprintf (stderr, "Open tmpfile fail!\n");
                                return;
                }
                fputs(databuf.content,fp);
                fclose(fp);

		fprintf(stderr,"Decrypt the signed TimeStampToken \n");
		{
			char    *repass;

                	repass = (char *)malloc(sizeof(char)*100);
                	sprintf(repass,"./ssleay enc -in %s -out tmpfile.3 -d -a -k abc  ",av[1]);
			fprintf(stderr,"	%s \n", repass);
                	system(repass);
                	free(repass);
        	}

		/* read decrypted token from file */
		if ((fp = fopen ("tmpfile.3", "r")) == NULL) {
                                fprintf (stderr, "Read tmpfile.3 fail!\n");
                                return;
                }
		fgets(buffer,256,fp);
		fprintf(stderr, "	Version = %s",buffer);
                fgets(buffer,256,fp);
                fprintf(stderr, "	hashAlgorithm = %s",buffer);
                fgets(buffer,256,fp);
                fprintf(stderr, "	hashedMessage = %s",buffer);
                fgets(buffer,256,fp);
                fprintf(stderr, "	gentime = %s\n",buffer);
                fgets(buffer,256,fp);
                fprintf(stderr, "	ordering = %s\n",&buffer);
                fgets(buffer,256,fp);
                fprintf(stderr, "	accurity = %s\n",&buffer);
	}
	close(sockid);
}

/* quit command line interface */
int quit_cmd(ac,av)
        int ac; 
        char **av;
{
	exit(0);
}

/* version information */
int info_cmd(ac, av)
        int ac;
        char **av;
{
        printf("  TSP Protocol for CMSC 681 Project \n" );
        printf("          ---------------Youyong Zou\n" );
        return 0;
}

/* compute a message digest number for a file */
int digest_cmd(ac, av)
        int ac;
        char **av;
{
	char    *repass;

	if (ac==2)
	{
        	repass = (char *)malloc(sizeof(char)*100);
        	sprintf(repass,"./ssleay dgst %s ",av[1]);
		fprintf(stderr,"%s \n", repass);
        	system(repass);
        	free(repass);
	}
	if (ac==3)
	{
		repass = (char *)malloc(sizeof(char)*100);
                sprintf(repass,"./ssleay dgst -%s  %s ",av[1],av[2]);
		fprintf(stderr,"%s \n", repass);
                system(repass);
                free(repass);
	}
        return 0;
}

/* verify the response token with TSP server's certificate */
int verify_cmd(ac, av)
        int ac;
        char **av;
{
	char    *repass;

        repass = (char *)malloc(sizeof(char)*100);
        sprintf(repass,"./ssleay verify -CAfile  %s %s ",av[1], av[2]);
	fprintf(stderr,"%s \n", repass);
        system(repass);
        free(repass);

        return 0;
}

/* connect to a TSP server */
int connect_cmd(ac, av)
        int ac;
        char **av;
{
	
	char *abc;
	abc = server_ip;

	strcpy(abc,av[1]);
	fprintf(stderr,"Connect to TSP Server :  %s \n", av[1]);
	fprintf(stderr,"The x509 certificate is located at  \n");
	fprintf(stderr,"     http://www.cs.umbc.edu/~yzou1/yzou1@cs.umbc.edu.p12  \n");
			
        return 0;
}

/* get TSP server certificate */
int certificate_cmd(ac, av)
        int ac;
        char **av;
{
	char    *repass;

        repass = (char *)malloc(sizeof(char)*200);
        sprintf(repass,"./wget %s -O %s ",av[1], av[2]);
	fprintf(stderr,"%s \n", repass);
        system(repass);
        free(repass);
        return 0;
}

