import java.io.*;
import java.util.*;

/** KYSS CLIENT
This program is used to creat a KYSS client for end users.
Its functions include remove, append and display a file in 
local or remote file system.
*/

// Author : Shuang Zeng
// Date   : Nov. 13, 99


class kyss
{
	static String jinistring;
	static String fsstring;

   public static void main (String args[]) throws IOException
   {
	if (args.length != 0)
		jinistring = args[0];
        kyss client = new kyss();
	client.run();
   }
    
    // The following method creats a KYSS client 
   public void run() throws IOException 
    {
       System.out.println("Welcome to KYSS!");
       System.out.println("Developed by Kejian hu");
       System.out.println("             Youyong zou");
       System.out.println("             Shanshan liu");
       System.out.println("             Shuang zeng");
       System.out.println("----------------------------------------");
       Calendar cal = Calendar.getInstance();
       Date date =cal.getTime();
       System.out.println("You log in at " + date.toString());

       BufferedReader in = new BufferedReader (new InputStreamReader(System.in));
	if (jinistring==null)
		System.out.println("Start with no jini server, use local FS");
	else
		System.out.println("connect to jini server "+jinistring);
       while (true)
	    {	
	      System.out.print("KYSS>");
              String input=in.readLine();
              if (input.equals("quit"))
                 {
                   System.out.println("bye"); 
		   System.exit(0);
                 }

	      StringTokenizer content= new StringTokenizer(input);
		String command;
		if (content.hasMoreTokens())
		{
	      		command= content.nextToken();

	      StringBuffer paras = new StringBuffer();
		if (content.hasMoreTokens())
		{
			String para=content.nextToken();
                      paras.append(para);
		}
	      while (content.hasMoreTokens())
		  {
		      paras.append(" ");
		      String para=content.nextToken();
                      paras.append(para);
		  }

	      String param=paras.toString();
	      
	      if (command.equalsIgnoreCase("help"))
		  this.help();
	      else if (command.equalsIgnoreCase("cat"))
		  this.cat(param);
	      else if (command.equalsIgnoreCase("append"))
		  this.append(param);
	      else if (command.equalsIgnoreCase("rm"))
		  this.rm(param);
	      else if (command.equalsIgnoreCase("shappend"))
		  this.shappend(param);
		else if (command.equalsIgnoreCase("touch"))
                  this.touch(param);
		  else if (command.equalsIgnoreCase("connect"))
                  this.connect(param);
		 else if (command.equalsIgnoreCase("list"))
                  this.list();
                
	      else
		  System.out.println("I can not understand you. Please type 'help' for more information, hehe...");
	      
	    }
		}
    }

    // help command
        public void help ()
        {
         System.out.println("     list: list the available fileserver");
         System.out.println("     connect <fileserver>: connect to a fileserver");
         System.out.println("     cat <filename>: print this file to screen");
         System.out.println("     touch <filename>: create the specified file");
         System.out.println("     rm <filename>: delete this file;");
         System.out.println("     append <filename> <string>: append a string into a file by WRITE_ONLY");
         System.out.println("     shappend <filename> <string>: append a string into a file by SHARE_WRITE");
         System.out.println("     help: show this message");
         System.out.println("     quit: quit KYSS;");

        }

    // cat command
        void cat(String p) throws IOException
        {
         if (p.equals(""))
         {
                System.out.println("Give me the file you want to take a look at...");
                return;
         }
	 KYSS_api kyss;
	if (jinistring==null)
	{
		kyss = new KYSS_api();
		if (fsstring==null)
			kyss.fsconnect();
		else
			kyss.fsconnect(fsstring);
	}
	else
	{
		kyss = new KYSS_api(jinistring);
		 if (fsstring==null)
                        kyss.fsconnect();
                else
                        kyss.fsconnect(fsstring);
	}
	if (kyss.open(p,"READ_ONLY","0"))
	{	
		byte[] kyss_byte = kyss.read(p);
		System.out.println(new String(kyss_byte));
	}
	else
	{
		System.out.println("Use local replica file...");
		byte[] kyss_byte = kyss.read(p);
                System.out.println(new String(kyss_byte));
	}
/*
	try {
		Thread.sleep(100000); 
	}
	catch (Exception e)
        {
                e.printStackTrace();
        }
*/

        }

    // append command
        void append(String p) throws IOException
        {
	    StringTokenizer file = new StringTokenizer(p);
	    String filename=file.nextToken();
		String app;
	    if (!file.hasMoreTokens())
		{
		 System.out.println("You forget to give the string!");
		 return;
		}
	   else
		{
			StringBuffer y = new StringBuffer();
			String z=file.nextToken();
			y.append(z);
	    		while (file.hasMoreTokens())
			{
		    		z=" "+file.nextToken();
		    		y.append(z);
			}
	    		app=y.toString()+"\n";
		}
	 KYSS_api kyss;
  if (jinistring==null)
        {
                kyss = new KYSS_api();
                if (fsstring==null)
                        kyss.fsconnect();
                else
                        kyss.fsconnect(fsstring);
        }
        else
        {
                kyss = new KYSS_api(jinistring);
                 if (fsstring==null)
                        kyss.fsconnect();
                else
                        kyss.fsconnect(fsstring);
        }


        	if (kyss.open(filename,"WRITE_ONLY","100000"))
        	{
                	kyss.write(filename,app,"WRITE_ONLY");
                	kyss.close(filename,"WRITE_ONLY");
        	}
        	else
		{
System.out.println("Failed to connect Fileserver...");
System.out.println("Use local replica");
 kyss.write(filename,app,"WRITE_ONLY");
		}
        }
    
    //remove command
        void rm(String p) throws IOException
        {
		KYSS_api kyss ;
  if (jinistring==null)
        {
                kyss = new KYSS_api();
                if (fsstring==null)
                        kyss.fsconnect();
                else
                        kyss.fsconnect(fsstring);
        }
        else
        {
                kyss = new KYSS_api(jinistring);
                 if (fsstring==null)
                        kyss.fsconnect();
                else
                        kyss.fsconnect(fsstring);
        }

                kyss.delete(p);
        }

	void list() throws IOException
	{
		if (jinistring==null)
		System.out.println("Sorry, you must specified a jiniserver");
		else
		{
			 KYSS_api kyss ;
			 kyss = new KYSS_api(jinistring);
			 kyss.list(jinistring);
		}
	}

        void touch(String p)throws IOException
        {
		KYSS_api kyss ;
  if (jinistring==null)
        {
                kyss = new KYSS_api();
                if (fsstring==null)
                        kyss.fsconnect();
                else
                        kyss.fsconnect(fsstring);
        }
        else
        {
                kyss = new KYSS_api(jinistring);
                 if (fsstring==null)
                        kyss.fsconnect();
                else
                        kyss.fsconnect(fsstring);
        }

                System.out.println(kyss.touch(p));
        }

        void connect(String p)throws IOException
        {
		fsstring = p;	
        }


    // share append command
        void shappend(String p) throws IOException
        {
	    StringTokenizer file = new StringTokenizer(p);
	    String filename=file.nextToken();
		String app;
	    if (!file.hasMoreTokens())
		{
		 System.out.println("You forget to give the string!");
		 return;
		}
	   else
		{
			StringBuffer y = new StringBuffer();
			String z=file.nextToken();
			y.append(z);
	    		while (file.hasMoreTokens())
			{
		    		z=" "+file.nextToken();
		    		y.append(z);
			}
	    		app=y.toString()+"\n";
		}
		 KYSS_api kyss;
  if (jinistring==null)
        {
                kyss = new KYSS_api();
                if (fsstring==null)
                        kyss.fsconnect();
                else
                        kyss.fsconnect(fsstring);
        }
        else
        {
                kyss = new KYSS_api(jinistring);
                 if (fsstring==null)
                        kyss.fsconnect();
                else
                        kyss.fsconnect(fsstring);
        }

        	if (kyss.open(filename,"SHARE_WRITE","0"))
        	{
                	kyss.write(filename,app,"SHARE_WRITE");
                	kyss.close(filename,"SHARE_WRITE");
        	}
        	else
		{
                	System.out.println("Failed to connect to remote server...");
			System.out.println("Use local replica");	
			 kyss.write(filename,app,"SHARE_WRITE");
		}
        }
    
}
