
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceID;
import net.jini.core.entry.Entry;
import net.jini.lookup.entry.Name;
import com.sun.jini.lookup.JoinManager;
import com.sun.jini.lookup.ServiceIDListener;
import com.sun.jini.lease.LeaseRenewalManager;
import java.net.InetAddress;

import java.rmi.*;

public class KYSS_jini implements DiscoveryListener,ServiceIDListener
{

    private ServiceID myID;

    public static void main (String[] args) {
	
	try {
	    System.setSecurityManager (new RMISecurityManager());
	    
	    LookupDiscovery ld = new LookupDiscovery(LookupDiscovery.NO_GROUPS);
	    ld.addDiscoveryListener(new KYSS_jini());
	    String[] groups = new String[1];
            groups[0] = new String("621.cs.umbc.edu");
	    ld.setGroups(groups);
	    	        
	    Thread.currentThread().sleep(1000000000L);
	}
	catch (Exception e) {
	    System.out.println("HelloServer Exception:" + e);
	}
    }

    public void serviceIDNotify (ServiceID uniqueID) {
	myID = uniqueID;
	System.out.println("server: ID set: " + myID );
    }

    public KYSS_jini() {
    }
  
    public void discovered(DiscoveryEvent de) {
	
	try {
	    // Invoke getRegistrar() on the LookupLocator to cause it to
	    // perform unicast discovery on the lookup service indicated
	    // by the host and port number passed to the constructor.
	    // The result is a reference to the registar object sent from
	    // the lookup service.
	    ServiceRegistrar[] registrars = de.getRegistrars();
	    
	    for (int i = 0; i < registrars.length; i++) {
		// A lookup service is, after all, a service -- a service
		// so proud of itself that it registers itself with itself. To
		// get the ID it assigns to itself, call getServicerID() on
		// the registrar object.
		ServiceID id = registrars[i].getServiceID();
		
		LookupLocator lookupLocator = registrars[i].getLocator();
		String host = lookupLocator.getHost();
		int port = lookupLocator.getPort();
		
		System.out.println("Lookup Service: jini://" + host + ":"
				   + port + ", " + id.toString());
	    }
            InetAddress host = InetAddress.getLocalHost();
            String localhost = host.getHostAddress();
            String hostname = host.getHostName();


	    KYSS_IP kyss = new KYSS_IP(hostname, localhost);

	    KYSS_jini hws = new KYSS_jini();

	    String[] groups = new String[1];
	    groups[0] = new String("621.cs.umbc.edu");
	    	    
	    JoinManager myManager = new JoinManager (kyss, null, 
						     groups,null,
						     hws, new LeaseRenewalManager());
	    System.out.println ("KYSSServer has been Joined!");
	} 
	catch (Exception e) {
	    System.out.println("HelloServer Exception:" + e);
	}
    }
    
    public void discarded(DiscoveryEvent de) {
    }
}

