//
// This program is for UMBC CMSC621 project
// Developed by Kejian Hu, Youyong Zou, Shanshan Liu ,Shuang Zeng
// 

import java.io.*;
import java.lang.*;
import java.util.*;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;

public class KYSS_fsImpl extends UnicastRemoteObject
    implements KYSS_fs 
{
//---------------------------------------------------
    	public KYSS_fsImpl() throws RemoteException {
        	super();
    	}

//---------------------------------------------------
	public void write(String filename,String str,String mode)
        {
                try{
			FileWriter datafile ;
System.out.println("in write");
 			if (mode.equals("WRITE_ONLY"))
                		datafile = new FileWriter(filename,true);
			else
				datafile = new FileWriter(filename+".cache",true);
                	datafile.write(str);
                	datafile.flush();
System.out.println("out  write");
                	datafile.close();
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
        }
	
//--------------------------------------------------------------
        public void merge(String filename,byte[] filecontent)
        {
                try{
System.out.println("merge into file"+filename);
System.out.println("Content: "+(new String(filecontent)));
                        FileWriter datafile ;
                        datafile = new FileWriter(filename,true);
			if (filecontent!=null)
                        	datafile.write(new String(filecontent));
                        datafile.flush();
                        datafile.close();
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
        }

//---------------------------------------------------
	public long gettimestamp(String filename)
        {
                try{
			File file = new File(filename);
                        return(file.lastModified());
                }
                catch (Exception e)
                {
                        e.printStackTrace();
			return 0;
                }
        }

//-------------------------------------------------
        public boolean log_can_WR_ONLY(String filename)
        {
                try{
                        KYSS_replica rep = new KYSS_replica();
                        return rep.can_WR_ONLY(filename);
                }
                catch (Exception e)
                {
                        e.printStackTrace();
			return false;
                }
        }

//-------------------------------------------------
        public boolean log_last(String filename,String fileserver)
        {
                try{
                        KYSS_replica rep = new KYSS_replica();
                        return rep.last(filename,fileserver);
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                        return false;
                }
        }

//-------------------------------------------------
        public void log_delete(String filename,String fileserver)
        {
                try{
                        KYSS_replica rep = new KYSS_replica();
                        rep.delete(filename,fileserver);
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
        }

//-------------------------------------------------
        public void log_add(String filename,String fileserver,String lease_time)
        {
                try{
                        KYSS_replica rep = new KYSS_replica();
                        rep.add(filename,fileserver,lease_time);
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
        }
//-----------------------------------------------------------
	public String extend(String filename,String leasetime)
 	{
                try{
		//get local host name
        InetAddress localhost = InetAddress.getLocalHost();
        String localhostname = localhost.getHostName();

        // add name resolution map here
        KYSS_name kn = new KYSS_name();
        String filehost = kn.Map(filename);

 	if (filehost.equals(localhostname))
        // local file
        {
		if (log_valid(filename))
		{
			log_delete(filename,localhostname);
			log_add(filename,localhostname,leasetime);
			return("Lease time is extended successful");	
		}
		else
			return("Sorry, you are out of lease time.");
	}
	else  // remote file
	{
KYSS_fs extend_obj=(KYSS_fs)Naming.lookup("//"+filehost+":6543" + "/KYSS_FS");
		 if (extend_obj.log_valid(filename))
                {
                        extend_obj.log_delete(filename,localhostname);
                        extend_obj.log_add(filename,localhostname,leasetime);
                        return("Lease time is extended");      
                }
                else
                        return("Sorry, you are out of lease time.");
	}
                }
                catch (Exception e)
                {
                        e.printStackTrace();
			return null;
                }
        }

//-------------------------------------------------
        public boolean log_valid(String filename)
        {
                try{
                        KYSS_replica rep = new KYSS_replica();
                        return rep.valid(filename);
                }
                catch (Exception e)
                {
                        e.printStackTrace();
			return false;
                }
        }

//-------------------------------------------------
        public String log_getLatest(String filename)
        {
                try{
                        KYSS_replica rep = new KYSS_replica();
                        return rep.getLatest(filename);
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                        return null;
                }
        }

//-----------------------------------------------------
// update replica with filecontent.
	public void update(String filename, byte[] filecontent,long time)
	{
                try{
			KYSS_replica rep = new KYSS_replica();	
			ArrayList hosts = rep.getHost(filename);
			int i;
			int update_size = hosts.size();
			boolean abcabc ;		
		 InetAddress localhost = InetAddress.getLocalHost();
        String localhostname = localhost.getHostName();

			for (i=0;i<update_size;i++)
			{
	if (!localhostname.equals((String )hosts.get(i)))
	{
System.out.println("Update file"+filename+"in "+(String )hosts.get(i));
KYSS_fs update_obj = (KYSS_fs)Naming.lookup("//"+(String )hosts.get(i)+":6543" + "/KYSS_FS");
abcabc = update_obj.save(filename, filecontent,time);
	}
			}
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
	}

//-----------------------------------------------------
// save the filecontent in local with filename and timestamp
	public boolean save(String filename, byte[] filecontent,long time)
        {
                try{
			if (log_valid(filename))
			{
			FileOutputStream os = new FileOutputStream(filename);
                		os.write(filecontent);
                		os.close();
			File file = new File(filename);
			file.setLastModified(time);
			return true;	
			}
			else
			{
				System.out.println("File not saved");
				return false;
			}
                }
                catch (Exception e)
                {
                        e.printStackTrace();
			return false;;
                }
        }

//---------------------------------------------------------
	public byte[] read(String filename)
	{
		try{
	FileInputStream read_file = new FileInputStream(filename);
        byte[] file_content = new byte[read_file.available()];
        read_file.read(file_content);
        read_file.close();
	return(file_content);
                }
                catch (Exception e)
                {
                        e.printStackTrace();
			return null;
                }
	}

//----------------------------------------------------------
        public byte[] readcache(String filename)
        {
                try{
        FileInputStream read_file = new FileInputStream(filename+".cache");
        byte[] file_content = new byte[read_file.available()];
        read_file.read(file_content);
        read_file.close();
        return(file_content);
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                        return null;
                }
        }

//-----------------------------------------------------------
	public String touch(String filename)
	{
		try {
  			//get local host name
        		InetAddress localhost = InetAddress.getLocalHost();
        		String localhostname = localhost.getHostName();

        		// add name resolution map here
        		KYSS_name kn = new KYSS_name();
        		String filehost = kn.Map(filename);

        		if (filehost.equals(localhostname))
        		// local file
        		{
				FileWriter datafile ;
                        	datafile = new FileWriter(filename,true);
                        	datafile.flush();
                        	datafile.close();

				return ("File created successful");
			}
			else
			{
	return("Cannot touch file belong to FS: "+ filehost+" at FS: "+localhostname);
			}
		}
		catch (Exception e)
                {
                        e.printStackTrace();
			return null;
                }
	}

//------------------------------------------------------------
       public boolean close(String filename,String mode)
        {
                try{
        //get local host name
        InetAddress localhost = InetAddress.getLocalHost();
        String localhostname = localhost.getHostName();

        // add name resolution map here
        KYSS_name kn = new KYSS_name();
        String filehost = kn.Map(filename);


        if (filehost.equals(localhostname))
        // local file
       {
 if (mode.equals("WRITE_ONLY"))
{

                FileInputStream is = new FileInputStream(filename);
                byte[] abc = new byte[is.available()];
                is.read(abc);
                is.close();
                File file = new File(filename);
                update(filename,abc,file.lastModified());
                log_delete(filename,filehost);
		return true;
}
else  // it is sharewrite
{
                log_delete(filename,filehost);
		if (log_last(filename,localhostname))
	{
		merge(filename,readcache(filename));
  		FileInputStream is = new FileInputStream(filename);
                byte[] abc = new byte[is.available()];
                is.read(abc);
                is.close();
                File file = new File(filename);

                update(filename,abc,file.lastModified());

			deletecache(filename);
	}


		return true;
}
        }
        else
        // remote file
        {
 if (mode.equals("WRITE_ONLY"))
{

                FileInputStream is = new FileInputStream(filename);
                byte[] abc = new byte[is.available()];
                is.read(abc);
                is.close();
                File file = new File(filename);
                long l1 = file.lastModified();

KYSS_fs close_obj=(KYSS_fs)Naming.lookup("//"+filehost+":6543" + "/KYSS_FS");
                if (close_obj.save(filename,abc,l1))
		{
                	close_obj.update(filename,abc,l1);
                	close_obj.log_delete(filename,localhostname);
			return true;
		}
		else
			return false;
}
else // share write
{
KYSS_fs close_obj=(KYSS_fs)Naming.lookup("//"+filehost+":6543" + "/KYSS_FS");
                close_obj.log_delete(filename,localhostname);

		 if (close_obj.log_last(filename,localhostname))
		{
                byte[] abc = readcache(filename);

                close_obj.merge(filename,abc);
		
                long l1 = close_obj.gettimestamp(filename);
		byte[] rrr = close_obj.read(filename);
  FileOutputStream oos = new FileOutputStream(filename);
                                oos.write(rrr);
                                oos.close();
                        File ofile = new File(filename);
                        ofile.setLastModified(l1);

                close_obj.update(filename,rrr,l1);
                deletecache(filename);
		}


		return true;
}
      }
                }
                catch (Exception e)
                {
                        e.printStackTrace();
			return false;
                }
        }


//--------------------------------------------------------------------
public boolean open(String filename, String mode, String leasetime)
{
try {
	//get local host name
	InetAddress localhost = InetAddress.getLocalHost();
       	String localhostname = localhost.getHostName();

	// add name resolution map here 
	KYSS_name kn = new KYSS_name();
	String filehost = kn.Map(filename);

	if (mode.equals("READ_ONLY"))
	{
		// file is in local
		if (filehost.equals(localhostname))	
		{
			// if we need to READ_ONLY local file, we do nothing
			File file = new File(filename);
			if (file.canRead())
			{
				return true;
			}
			else
			{
System.out.println("File is in local, but cannot read now!");
				return false;
			}
		}

		// file is in remote file server
		else
		{
			File file = new File(filename);
                        if (file.canRead())
			{
System.out.println("We have Replica in local,Check it...");
				long t1 = gettimestamp(filename);
KYSS_fs obj=(KYSS_fs)Naming.lookup("//"+filehost+":6543" + "/KYSS_FS");
				long t2 = obj.gettimestamp(filename);
				if ( t1==t2)
					return true;
				else
				{
		boolean aaa6 = save(filename,obj.read(filename),t2);
					return true;
				}
			}
                        else
			{
System.out.println("We have no Replica in local,goto remote");
	KYSS_fs obj=(KYSS_fs)Naming.lookup("//"+filehost+":6543" + "/KYSS_FS");
	FileOutputStream os = new FileOutputStream(filename);
                                os.write(obj.read(filename));
                                os.close();
				long t2 = obj.gettimestamp(filename);
				File file3 = new File(filename);
				file3.setLastModified(t2);	
       				return true;
			}
		}
	}

	if (mode.equals("WRITE_ONLY"))
        {
                // file is in local
                if (filehost.equals(localhostname))
                {
			if (log_can_WR_ONLY(filename))
			{
				log_add(filename,localhostname,leasetime);
				return true;
			}
			else
			{
				System.out.println("Cannot WRITE_ONLY file"+filename);
				return false;
			}
                }

		// file is in remote file server
		else
		{
	KYSS_fs obj=(KYSS_fs)Naming.lookup("//"+filehost+":6543" + "/KYSS_FS");
			if (obj.log_can_WR_ONLY(filename))
                        {
	long l2 = obj.gettimestamp(filename);
				boolean aaa8 = save(filename,obj.read(filename),l2);
                                obj.log_add(filename,localhostname,leasetime);
                                return true;
                        }
			else
			{
				System.out.println("Cannot WRITE_ONLY file"+filename);
				return false;
			}
		}
	}

	if (mode.equals("SHARE_WRITE"))
        {
System.out.println("now sharewrite this file ");
                // file server is in local
                if (filehost.equals(localhostname))
                {
			System.out.println("File is in local");
			log_add(filename,localhostname,"0");
			return true;
		}
		// file is in remote file server
		else
		{
	System.out.println(" file is in remote ! ");
        KYSS_fs obj=(KYSS_fs)Naming.lookup("//"+filehost+":6543" + "/KYSS_FS");
	long l2 = obj.gettimestamp(filename);
	String lat = obj.log_getLatest(filename);
		
	FileOutputStream oos = new FileOutputStream(filename);
                                oos.write(obj.read(filename));
                                oos.close();
                        File ofile = new File(filename);
                        ofile.setLastModified(l2);


	 if (lat!=null)
	{
	 if (lat.equals(localhostname))	
	{
        KYSS_fs obj_lat=(KYSS_fs)Naming.lookup("//"+lat+":6543" + "/KYSS_FS");
	merge(filename,obj_lat.readcache(filename));
	}
	}
	obj.log_add(filename,localhostname,"0");

	return true;
		}
	}
	return false;
	
}
catch (Exception e)
{
	System.out.println("Connect to remote file server error ");
	return false;
}
}

//-------------------------------------------------
// delete a file from file system or cache.
	public void  delete(String filename)
	{
 		try{
                        File file = new File(filename);
                        file.delete();
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
	}

//-------------------------------------------------
// delete a file from file system or cache.
        public void  deletecache(String filename)
        {
                try{
System.out.println("delete cache file");

                        File file = new File(filename+".cache");
                        file.delete();

                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
        }

//----------------------------------------------------
	public static void main(String args[]) {
        	// Create and install a security manager
        	if (System.getSecurityManager() == null) {
            		System.setSecurityManager(new RMISecurityManager());
        	}
        	try {
            		KYSS_fsImpl obj = new KYSS_fsImpl();
            		// Bind this object instance to the name "KYSS_FS"
            		InetAddress host = InetAddress.getLocalHost();
            		String hostname = host.getHostName();
            		Naming.rebind("//"+hostname+":6543/KYSS_FS", obj);
            		System.out.println("KYSS_FS bound in registry");
        	} catch (Exception e) {
            		System.out.println("HelloImpl err: " + e.getMessage());
            		e.printStackTrace();
        	}
   	}
}
