//
// This program is for UMBC CMSC621 project
// Developed by Kejian Hu, Youyong Zou, Shanshan Liu ,Shuang Zeng
// Date 11/11/99
// 

import java.io.*;
import java.util.*;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.lookup.ServiceMatches;


// API used by client program.

public class KYSS_api
{ 
	private	static KYSS_fs obj = null;
	private static String fshostname;

	public KYSS_api( )
	{
       try {
// to debug, only get localhost's hostname.
                InetAddress host = InetAddress.getLocalHost();
                String localhost = host.getHostAddress();

                InetAddress host1 = InetAddress.getByName(localhost);
                fshostname = host1.getHostName();
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
	}

	public void fsconnect()
	{
 		try {
System.out.println("KYSS_API:   Connecting to "+fshostname+" .....");
obj = (KYSS_fs)Naming.lookup("//"+fshostname+":6543" + "/KYSS_FS");
System.out.println("KYSS_API:   Connected OK");
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
	}

        public void fsconnect(String host)
        {
                try {
System.out.println("KYSS_API:   Connecting to "+host+" .....");
obj = (KYSS_fs)Naming.lookup("//"+host+":6543" + "/KYSS_FS");
System.out.println("KYSS_API:   Connected OK");
                }
                catch (Exception e)
                {
                        e.printStackTrace();
                }
        }


	public KYSS_api(String jiniserver)
	{
	try {
                InetAddress host = InetAddress.getLocalHost();
                String localhost = host.getHostAddress();
                fshostname = jini_lookup(jiniserver,localhost);
	}
    		catch (Exception e)
    		{
      			e.printStackTrace();
    		}
	}

// open a file, if file is in local,open, else copy file from
// file server and open it.
	public boolean open(String filename, String mode,String leasetime)
	{
		try
		{
			return(obj.open(filename,mode,leasetime));
		} catch (Exception e) { 
	    		e.printStackTrace(); 
			return false;
		} 
    	} 

// extend lease time
        public String extend(String filename,String leasetime)
        {
                try
                {
                        return(obj.extend(filename,leasetime));
                } catch (Exception e) {
                        e.printStackTrace();
                        return null;
                }
        }

// close a file, if file is in local
	public static boolean close(String filename,String mode)
	{
		try
                {
			return(obj.close(filename,mode));
                } catch (Exception e) {
                        e.printStackTrace();
			return false;
                }
	}

// read file
	public byte[] read(String is )
	{
		try
                {
			return(obj.read(is));
                } catch (Exception e) {
                        e.printStackTrace();
			return null;
                }
	}

// write a string into a File
        public static void  write(String os,String str ,String mode)
        {
                try
                {
			obj.write(os,str,mode);
                } catch (Exception e) {
                        e.printStackTrace();
                }
        }


// delete a file
        public static void delete(String filename )
        {
                try
                {
                        obj.delete(filename);
                } catch (Exception e) {
                        e.printStackTrace();
                }
        }

// create  a file
        public static String  touch(String filename )
        {
                try
                {
                        return(obj.touch(filename));
                } catch (Exception e) {
                        e.printStackTrace();
			return null;
                }
        }
	
	
    //return a nearest file server name 
    public String jini_lookup(String jiniServer, String clientIP ) {
	KYSS_IP returnHost = null ;
		    
	System.setSecurityManager (new RMISecurityManager ());
	try {
	    LookupLocator lookup = new LookupLocator (jiniServer);
	    ServiceRegistrar registrar = lookup.getRegistrar ();

	    Class[] types = {KYSS_IP.class};
	    
	    ServiceTemplate template = new ServiceTemplate (null, types,
null);
	    ServiceMatches matches = registrar.lookup (template, 10);
	    
	    double clientIpValue = 0;
	    StringTokenizer tok = new StringTokenizer(clientIP, ".");
	    int power = 3;
	    while(tok.hasMoreTokens()) {
		clientIpValue += Double.parseDouble(tok.nextToken())*Math.pow(255, power--);
	    }
	    
	    double min = 255*Math.pow(255, 3) + 255*Math.pow(255, 2)
		+ 255*Math.pow(255, 1) + 255*Math.pow(255, 0);
	    int minIndex = 0;

	    for(int n=0; n< matches.items.length; n++) {
		KYSS_IP kyssFs = (KYSS_IP) matches.items[n].service;
		if(kyssFs != null) {
		    String serverIP = kyssFs.getIP();
		    StringTokenizer tok1 = new StringTokenizer(serverIP, ".");
		    int subPower = 3;
		    double value = 0;
		    while(tok1.hasMoreTokens()) {
			value += Double.parseDouble(tok1.nextToken())*Math.pow(255, subPower--);
		    }
		    if(Math.abs(value - clientIpValue) < min) 
			{ minIndex = n; min=Math.abs(value - clientIpValue);
			}
		}
	    }

	    returnHost = (KYSS_IP) matches.items[minIndex].service;
	}
	catch(Exception e) {
	    System.out.println("KYSS_API lookup exception " + e);
	    e.printStackTrace();
	}
	return returnHost.getHostName();
      }

	public 	void list(String jiniServer)
	{
		System.setSecurityManager (new RMISecurityManager ());
		try {
	    LookupLocator lookup = new LookupLocator (jiniServer);
	    ServiceRegistrar registrar = lookup.getRegistrar ();

	    Class[] types = {KYSS_IP.class};
	    
	    ServiceTemplate template = new ServiceTemplate (null, types, null);
	    ServiceMatches matches = registrar.lookup (template, 10);
	   System.out.println("Find "+matches.items.length+ " fileserver"); 
	    for(int n=0; n< matches.items.length; n++) {
		KYSS_IP kyssFs = (KYSS_IP) matches.items[n].service;
		if(kyssFs != null) 
			System.out.println(kyssFs.getHostName());
	    	}
		}
		catch(Exception e) {
	    		System.out.println("KYSS_API lookup exception " + e);
	    		e.printStackTrace();
		}

	} // end of list()
}
