import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import java.lang.*; 


public class StudentQuery extends Query {
    
    public StudentQuery() {
	super("select to_char(p.id), p.name.get_name(), p.ssn, p.sex, s.program, s.degree_sought, s.status, s.research_advisor.name.get_name(), s.academic_advisor.name.get_name(), s.comp_exam_result, to_char(s.graduation_date), to_char(s.xerox_number), s.preliminary_exam.get_preliminary_exam(), s.project.get_project(), s.defense.get_defense(), to_char(s.update_date)","from applicant_tab p, student_tab s");
    }
    
    public void popup() {
	
	final JFrame frame = new JFrame("Student Query");

	final JFrame qframe =new JFrame("Query result");

	final JTextPane qPane = new JTextPane();
	JScrollPane scrollPane = new JScrollPane(qPane);
	qPane.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	scrollPane.setPreferredSize(new Dimension(250, 655));
	scrollPane.setMinimumSize(new Dimension(60, 60));
	scrollPane.setVerticalScrollBarPolicy(
	               JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	final Document doc = qPane.getDocument();

	String[] initStyles = 
                { "regular", "italic", "bold", "small", "large",
                  "regular", "button", "regular", "icon",
                  "regular"
                };

        initStylesForTextPane(qPane);
	
	JPanel closePane = new JPanel();
	closePane.setLayout(new GridLayout(1, 0));
	JButton close_b =new JButton("Close");

	close_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    qframe.setVisible(false);
		}
	    });

	closePane.add(close_b);
	qframe.getContentPane().add(scrollPane, BorderLayout.CENTER);
	qframe.getContentPane().add(closePane, BorderLayout.SOUTH);
	qframe.pack();
	//qframe.setVisible(false);

	JPanel pane0 = new JPanel();
	pane0.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane0.setLayout(new GridLayout(1, 0));
	
	JPanel pane1 = new JPanel();
	pane1.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane1.setLayout(new GridLayout(5, 2));
	
	JPanel pane2 = new JPanel();
	pane2.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane2.setLayout(new GridLayout(1, 2));

	final JTextField id_d = new JTextField(9);
	final JTextField ssn_d = new JTextField(9);
	final JTextField first_name_d = new JTextField(20);
	final JTextField middle_name_d = new JTextField(20);
	final JTextField last_name_d = new JTextField(20);
	
	final JLabel spec = new JLabel("Please enter SSN or name of the applicant : ",JLabel.CENTER);
	JLabel id_l = new JLabel("ID : ", JLabel.LEFT);
	JLabel ssn_l = new JLabel("SSN : ", JLabel.LEFT);
	JLabel first_name_l = new JLabel("First Name : ",JLabel.LEFT);
	JLabel middle_name_l = new JLabel("Middle Name : ", JLabel.LEFT);
	JLabel last_name_l = new JLabel("Last Name : ", JLabel.LEFT);
    
	//qframe.getContentPane().add(pane2, BorderLayout.CENTER);

	JButton ok_b = new JButton("OK");
	JButton cancel_b =new JButton("Cancel");
	cancel_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    frame.setVisible(false);
		}
	    });
	ok_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    //frame.setVisible(false);
		    String query_string=command+' '+tables;
		    String tmp_string="";
		    
		    if (!id_d.getText().equals("")) {
			tmp_string="p.id='"+id_d.getText()+"' ";
		    }

		    if (!ssn_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string="p.ssn='"+ssn_d.getText()+"' ";
		    }

		    if (!first_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"p.name.get_first()='"
			    +first_name_d.getText()+"' ";
		    }
		    
		    if (!middle_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"p.name.get_middle()='"
			    +middle_name_d.getText()+"' ";
		    }
		    
		    if (!last_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"p.name.get_last()='"
			    +last_name_d.getText()+"'";
		    }

		    if (!tmp_string.toString().equals("")) {
		       
			conditions = "where "+tmp_string+" AND p.id=s.id";
			
			query_string=query_string+" "+conditions;
		    }
		
		    String[] attributes= {"Student ID :",
					  "Name :",
					  "Social Security Number :",
					  "Sex :",
					  "Program :",
					  "Degree Sought :",
					  "Status : ",
					  "Research Advisor : ",
					  "Academic Advisor : ",
					  "comprehensive Exam Result :",
					  "Graduation Date :",
					  "Xerox Number :",
					  "Preliminary Exam Information :",
					  "Project :",
					  "Defense :",
					  "Update Date :",
					  "Comprehensive Information :",
					  "Preliminary Exam Committee :",
					  "Defense Committee :",
					  "Project Committee :"};
					 			
		    String head = "Your query has the following results :\n\n";
		    try {
			doc.insertString(doc.getLength(),head, 
					 qPane.getStyle("bold"));
			do_query(attributes, query_string, doc, qPane);
			doc.insertString(doc.getLength(),"End\n\n", 
					 qPane.getStyle("bold"));
		    }catch (BadLocationException ble) {
			ErrorInfo.print("Error: Couldn't display!");
		    }
		    		    
		    qframe.setVisible(true);
		    frame.setVisible(true);
		}
	    });
	
	pane0.add(spec);
	pane1.add(id_l);
	pane1.add(id_d);
	pane1.add(ssn_l);
	pane1.add(ssn_d);
	
	pane1.add(first_name_l);
	pane1.add(first_name_d);
	
	pane1.add(middle_name_l);
	pane1.add(middle_name_d);
	
	pane1.add(last_name_l);
	pane1.add(last_name_d);
	pane2.add(ok_b);
	pane2.add(cancel_b);

	frame.getContentPane().add(pane0, BorderLayout.NORTH);
	frame.getContentPane().add(pane1, BorderLayout.CENTER);
	frame.getContentPane().add(pane2, BorderLayout.SOUTH);
	
	frame.pack();
	frame.setVisible(true);
    }      
	
    public void do_query(String[] attributes, String query_string, 
			 Document doc, JTextPane qPane) {
	int count = 0;
	Connection con = connectIt();
	System.out.println(query_string);
	
	try {
	    Statement stmt = con.createStatement();
	    ResultSet rs =  stmt.executeQuery(query_string);
	    
	    while ( rs.next() ) {
		count++;
		for (int i=1; i<=16;i++) {
		    String name = rs.getString(i);
		    if (name == null) name = "N/A";
		    try {
			doc.insertString(doc.getLength(), 
					 attributes[i-1]+"\n", 
					 qPane.getStyle("bold"));
			doc.insertString(doc.getLength(), 
					 name.replace('|','\n')+"\n"+"\n",
					 qPane.getStyle("regular"));
		    } catch (BadLocationException ble) {
			ErrorInfo.print("Error 1: Couldn't display!");
		    }
		}
	    }
	    stmt.close();
	}
	catch (SQLException ex ){
	    ErrorInfo.print("Error 2: while executing query.");
	}
	//System.out.println(count);
	
	if (count!=0) {
	 
	    String[] sub_query={"select t.get_comp_exam() from the(select s.comp_exam "+tables+" "+conditions+") t",

				"select t.faculty.name.get_name(), t.role from the(select s.preliminary_committee "+tables+" "+conditions+") t",
			    
				"select t.faculty.name.get_name(), t.role from the(select s.defense_committee "+tables+" "+conditions+") t",

				"select t.faculty.name.get_name(), t.role from the(select s.project_committee "+tables+ " " + conditions+") t"};

	    
	    for (int i=17;i<=20;i++) {		
		//System.out.println(sub_query[i-15]);
		try {
		    doc.insertString(doc.getLength(), attributes[i-1]+"\n", 
				     qPane.getStyle("bold"));
		    
		    doc.insertString(doc.getLength(), subquery(sub_query[i-17], con,1)+"\n", qPane.getStyle("regular"));
		} catch (BadLocationException ble) {
		    ErrorInfo.print("Error: Couldn't display!");
		}
	    }
	    
	}
	if (count ==0) {
	    try {
		doc.insertString(doc.getLength(),"None\n\n", 
				 qPane.getStyle("regular"));
	    }catch (BadLocationException ble) {
		ErrorInfo.print("Error: Couldn't display!");
	    }
	}
    }

    public static void main(String[] args) {
	StudentQuery app=new StudentQuery();
	app.popup();
	
    }
}
