//This query is to query students' status
import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import java.lang.*; 

public class ReviewQuery extends Query {
    
    public ReviewQuery() {
	super("select to_char(p.id), p.name.get_name(), s.reviewer.name.get_name(), s.recommendation,s.match_faculties,s.undercourses,s.comments, to_char(s.ddate)", "from applicant_tab p, Review_tab s");
    }
    
    public void popup() {
	conditions = "where s.applicant_id.id=p.id";

	final JFrame frame = new JFrame("Applicant Query");
	final JFrame qframe =new JFrame("Query result");
	
	JPanel pane0 = new JPanel();
	pane0.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane0.setLayout(new GridLayout(1, 0));
	
	JPanel pane1 = new JPanel();
	pane1.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane1.setLayout(new GridLayout(5, 2));
	
	JPanel pane2 = new JPanel();
	pane2.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane2.setLayout(new GridLayout(1, 2));

	final JTextField id_d = new JTextField(20);
	final JTextField ssn_d = new JTextField(20);
	final JTextField first_name_d = new JTextField(10);
	final JTextField middle_name_d = new JTextField(10);
	final JTextField last_name_d = new JTextField(4);
	
	final JLabel spec = new JLabel("Please enter information of the applicant : ",JLabel.CENTER);
	JLabel id_l = new JLabel("ID : ", JLabel.LEFT);
	JLabel ssn_l = new JLabel("SSN : ", JLabel.LEFT);
	JLabel first_name_l = new JLabel("First Name : ",JLabel.LEFT);
	JLabel middle_name_l = new JLabel("Middle Name : ", JLabel.LEFT);
	JLabel last_name_l = new JLabel("Last Name : ", JLabel.LEFT);
	JLabel status_l = new JLabel("Status : ", JLabel.LEFT);

	//qframe.getContentPane().add(pane2, BorderLayout.CENTER);

	JButton ok_b = new JButton("OK");
	JButton cancel_b =new JButton("Cancel");
	cancel_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    frame.setVisible(false);
		}
	    });
	ok_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    //frame.setVisible(false);
		    String query_string=command+' '+tables;
		    String tmp_string="";
		    String cons=conditions;
		    
		    if (!id_d.getText().equals("")) {
			tmp_string="p.id="+
			    id_d.getText()+" ";
		    }
		    
		    if (!ssn_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string="p.ssn='"+
			    ssn_d.getText()+"' ";
		    }
		    
		    if (!first_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"p.name.get_first()='"
			    +first_name_d.getText()+"' ";
		    }
		    
		    if (!middle_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"p.name.get_middle()='"
			    +middle_name_d.getText()+"' ";
		    }
		    
		    if (!last_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"p.name.get_last()='"
			    +last_name_d.getText()+"'";
		    }

		    if (!tmp_string.toString().equals("")) {
		       
			cons = cons+" AND "+tmp_string;
			
			query_string=query_string+" "+cons;
		    }
		    else query_string=query_string+" "+cons;

		    int numColumns=8;
		    
		    String[] names= {"ID","Name","Reviewer","Recommendation",
				     "Match Faculties",
				     "Under Courses Required","comments",
				     "Date"};
	
		    final Vector attr =new Vector(numColumns);
		    
		    for (int i=0; i<numColumns; i++) attr.addElement(names[i]);
		    final Vector data = new Vector(10,10);
	
		    JTable table= new JTable(data, attr);
		    table.setPreferredScrollableViewportSize(new Dimension(900, 70));
	
		    JScrollPane scrollPane = new JScrollPane(table);
		    scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		    //String query_string = command+' '+tables+' '+conditions;
		    final Connection con = connectIt();
		    
		    do_query(query_string,data, con,numColumns);
		    
		    qframe.getContentPane().add(scrollPane, BorderLayout.CENTER);
		    
		    JPanel pane = new JPanel();
		    pane.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
		    pane.setLayout(new GridLayout(1, 0));
		    
		    JButton close_b =new JButton("Close");
		    close_b.addActionListener(new ActionListener() {
			    public void actionPerformed(ActionEvent e) {
				qframe.setVisible(false);
			    }
			});

		    pane.add(close_b);
		    qframe.getContentPane().add(scrollPane, BorderLayout.CENTER);
		    qframe.getContentPane().add(pane, BorderLayout.SOUTH);
		    qframe.pack();
		    qframe.setVisible(true);
		}
	    });

	pane0.add(spec);
	pane1.add(id_l);
	pane1.add(id_d);
	pane1.add(ssn_l);
	pane1.add(ssn_d);
	
	pane1.add(first_name_l);
	pane1.add(first_name_d);
	
	pane1.add(middle_name_l);
	pane1.add(middle_name_d);
	
	pane1.add(last_name_l);
	pane1.add(last_name_d);
	
	pane2.add(ok_b);
	pane2.add(cancel_b);

	frame.getContentPane().add(pane0, BorderLayout.NORTH);
	frame.getContentPane().add(pane1, BorderLayout.CENTER);
	frame.getContentPane().add(pane2, BorderLayout.SOUTH);
	frame.pack();
	frame.setVisible(true);
    }

    public void do_query(String query_string, Vector data, Connection con,int numColumns) {
	try {
	    System.out.println(query_string);
	    Statement stmt = con.createStatement();
	    ResultSet rs =  stmt.executeQuery(query_string);
	    
	    while ( rs.next() ) {
		Vector vec=new Vector(numColumns);
		for (int i=1; i<=numColumns;i++) {
		    String name = rs.getString(i);
		    if (name == null) name = "N/A";
		    vec.addElement(name);
		}
		data.addElement(vec);
	    }
	    stmt.close();
	}
	catch (SQLException ex ){
	    ErrorInfo.print("Error 2: while executing query.");
	}
    }

    public static void main(String[] args) {
	ReviewQuery app=new ReviewQuery();
	app.popup();
	
    }
}









