import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import java.lang.*;

public class Query {
    protected String command;
    protected String tables;
    protected String conditions;
    protected ErrorInfo error;

    public Query(String com, String tabs) {
	command = com;
	tables = tabs;
	conditions = "";
	error = new ErrorInfo();
    }

    public String subquery(String query_string,Connection con, int num) {
	System.out.println(query_string);
	String result="";
	try {
	    Statement stmt = con.createStatement();
	    ResultSet rs =  stmt.executeQuery(query_string);
	    while ( rs.next() ) {
		for (int i=1; i<num+1;i++) {
		    String name = rs.getString(i);
		    if (name == null) name = "N/A";
		    result=result+" "+name.replace('|','\n');
		}
	    }
	    stmt.close();
	}
	catch (SQLException ex ){
	    //ex.printStackTrace();
	    ErrorInfo.print("Error 3: while executing query.");
	}
	return result+"\n";
    }

    protected void initStylesForTextPane(JTextPane textPane) {
        //Initialize some styles.
        Style def = StyleContext.getDefaultStyleContext().
                                        getStyle(StyleContext.DEFAULT_STYLE);
	
        Style regular = textPane.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");

        Style s = textPane.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);

        s = textPane.addStyle("bold", regular);
        StyleConstants.setBold(s, true);

        s = textPane.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);

        s = textPane.addStyle("large", regular);
        StyleConstants.setFontSize(s, 16);

        s = textPane.addStyle("icon", regular);
        StyleConstants.setAlignment(s, StyleConstants.ALIGN_CENTER);
        //StyleConstants.setIcon(s, new ImageIcon("images/Pig.gif"));

        s = textPane.addStyle("button", regular);
        StyleConstants.setAlignment(s, StyleConstants.ALIGN_CENTER);
        JButton button = new JButton();
        button.setMargin(new Insets(0,0,0,0));
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        StyleConstants.setComponent(s, button);
    }

    public Connection connectIt() {
	String userLogin="team7";
	String userPasswd="mouse";
	ResultSet rs=null;
	
	try {
	    Class.forName("oracle.jdbc.driver.OracleDriver");
	} 
	catch(ClassNotFoundException ex) {
	    ErrorInfo.print("didn't find the Driver");
	}
	
	String url = "jdbc:oracle:thin:@bazak.cs.umbc.edu:1521:bazak";
	Connection con = null;
	try {
	    con = DriverManager.getConnection(url, userLogin, userPasswd);
	    System.out.println("Connected to Oracle.");
	}
	catch (SQLException se ){
	    ErrorInfo.print("Unable to connect to Oracle.");
	}
	
	return con;
	
    }
}

