// This query is for all dismissed students.

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import java.lang.*; 


public class DismissedStudentQuery extends Query {
    
    public DismissedStudentQuery() {
	super ("select to_char(a.id), a.name.get_name(), a.ssn, a.sex, g.reasons, to_char(g.ddate)", "from Dismissed_student_tab g, applicant_tab a");
    }
    
    public void popup() {
        conditions = "where g.student_id=a.id";
	int numColumns=6;
	final JFrame frame = new JFrame("Assistant List Query");

	String[] names= {"ID","Name","SSN","Sex","Reasons","Date"};
	
	final Vector attr =new Vector(numColumns);

	for (int i=0; i<numColumns; i++) attr.addElement(names[i]);
	final Vector data = new Vector(10,10);
	
	JTable table= new JTable(data, attr);
	table.setPreferredScrollableViewportSize(new Dimension(900, 70));
	
	JScrollPane scrollPane = new JScrollPane(table);
	scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	String query_string = command+' '+tables+' '+conditions;
	final Connection con = connectIt();

	do_query(query_string,data, con,numColumns);

	frame.getContentPane().add(scrollPane, BorderLayout.CENTER);

	JPanel pane1 = new JPanel();
	pane1.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane1.setLayout(new GridLayout(1, 0));
	
	JButton close_b =new JButton("Close");
	close_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    frame.setVisible(false);
		}
	    });

	pane1.add(close_b);

	frame.getContentPane().add(scrollPane, BorderLayout.CENTER);
	frame.getContentPane().add(pane1, BorderLayout.SOUTH);
	frame.pack();
	frame.setVisible(true);
    }
    
    public void do_query(String query_string, Vector data, Connection con,int numColumns) {
	try {
	    System.out.println(query_string);
	    Statement stmt = con.createStatement();
	    ResultSet rs =  stmt.executeQuery(query_string);
	    
	    while ( rs.next() ) {
		Vector vec=new Vector(numColumns);
		for (int i=1; i<=numColumns;i++) {
		    String name = rs.getString(i);
		    if (name == null) name = "N/A";
		    vec.addElement(name);
		}
		data.addElement(vec);
	    }
	    stmt.close();
	}
	catch (SQLException ex ){
	    ErrorInfo.print("Error 2: while executing query.");
	}
    }
    
    public static void main(String[] args) {
	DismissedStudentQuery app=new DismissedStudentQuery();
	app.popup();
	
    }
}
