// This query is for approved applicants by the committee

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import java.lang.*; 


public class ApprovedApplicantQuery extends Query {
    
    public ApprovedApplicantQuery() {
	super ("select to_char(a.id), a.name.get_name(), a.ssn, a.sex, to_char(a.birthday), a.country, a.primary_language, g.program, g.degree_sought, g.semester||' '||g.yyear, g.is_finance_requested||' '||finance_source, g.status, to_char(received_date), to_char(g.dls_date), to_char(g.gls_date), to_char(g.lls_date), g.committee_decision.get_committee_decision(), g.application_decision.get_application_decision(), g.notes, g.update_date", "from applicant_tab a, grad_applicant_tab g");
    }
    
    public void popup() {

	final int numColumns=18;
	final JFrame frame = new JFrame("Applicant Query");

	final JFrame qframe =new JFrame("Query result");

	final JTextPane qPane = new JTextPane();
	JScrollPane scrollPane = new JScrollPane(qPane);
	qPane.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	scrollPane.setPreferredSize(new Dimension(250, 650));
	scrollPane.setMinimumSize(new Dimension(60, 60));
	scrollPane.setVerticalScrollBarPolicy(
	               JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	final Document doc = qPane.getDocument();

	String[] initStyles = 
                { "regular", "italic", "bold", "small", "large",
                  "regular", "button", "regular", "icon",
                  "regular"
                };

        initStylesForTextPane(qPane);
	JPanel closePane = new JPanel();
	closePane.setLayout(new GridLayout(1, 0));
	JButton close_b =new JButton("Close");

	close_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    qframe.setVisible(false);
		}
	    });

	closePane.add(close_b);
	qframe.getContentPane().add(closePane, BorderLayout.SOUTH);
	qframe.getContentPane().add(scrollPane, BorderLayout.CENTER);
	qframe.pack();
	//qframe.setVisible(false);

	JPanel pane0 = new JPanel();
	pane0.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane0.setLayout(new GridLayout(1, 0));
	
	JPanel pane1 = new JPanel();
	pane1.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane1.setLayout(new GridLayout(5, 2));
	
	JPanel pane2 = new JPanel();
	pane2.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane2.setLayout(new GridLayout(1, 2));

	final JTextField id_d = new JTextField(20);
	final JTextField ssn_d = new JTextField(9);
	final JTextField first_name_d = new JTextField(20);
	final JTextField middle_name_d = new JTextField(20);
	final JTextField last_name_d = new JTextField(20);
	
	final JLabel spec = new JLabel("Please enter SSN or name of the applicant : ",JLabel.CENTER);
	JLabel id_l = new JLabel("ID : ", JLabel.LEFT);
	JLabel ssn_l = new JLabel("SSN : ", JLabel.LEFT);
	JLabel first_name_l = new JLabel("First Name : ",JLabel.LEFT);
	JLabel middle_name_l = new JLabel("Middle Name : ", JLabel.LEFT);
	JLabel last_name_l = new JLabel("Last Name : ", JLabel.LEFT);
    
	//qframe.getContentPane().add(pane2, BorderLayout.CENTER);
	
	JButton ok_b = new JButton("OK");
	JButton cancel_b =new JButton("Cancel");
	cancel_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    frame.setVisible(false);
		}
	    });
	ok_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    frame.setVisible(false);
		    String query_string=command+' '+tables;
		    String tmp_string="";

		    if (!id_d.getText().equals("")) {
			tmp_string="g.id="+
			    id_d.getText()+" ";
		    }
		    
		    if (!ssn_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string="g.ssn='"+ssn_d.getText()+"' ";
		    }

		    if (!first_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"g.name.get_first()='"
			    +first_name_d.getText()+"' ";
		    }
		    
		    if (!middle_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"g.name.get_middle()='"
			    +middle_name_d.getText()+"' ";
		    }
		    
		    if (!last_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"g.name.get_last()='"
			    +last_name_d.getText()+"'";
		    }

		    if (!tmp_string.toString().equals("")) {
			conditions = "where "+tmp_string+" AND g.id=a.id";
			query_string=query_string+" "+conditions;
		    }
		    else query_string=query_string+" "+"where g.id=a.id";

		    String[] attributes ={"StudentID :", "Name : ", 
					  "Social Security Number :", 
					  "Sex :", "Birthday :", 
					  "Country Of Citizanship :",
					  "Primary Language :",
					  "Program :", "Degree Sought :",
					  "Semester of enrollment :",
					  "Finance :", "Status :",
					  "Received Date :",
					  "Date of Department Letter send :",
					  "Date of Graduate School letter send :",
					  "Date of international letters send :",
					  "Committee Decision :",
					  "Application Decision :","Notes :",
					  "Update Date : "};
		    String head = "Your query has the following results :\n\n";
		    try {
			doc.insertString(doc.getLength(),head, 
					 qPane.getStyle("bold"));
			do_query(attributes, query_string, doc, qPane);
			doc.insertString(doc.getLength(),"End\n\n", 
					 qPane.getStyle("bold"));
		    }catch (BadLocationException ble) {
			ErrorInfo.print("Error: Couldn't display!");
		    }
		    		    
		    qframe.setVisible(true);
		    frame.setVisible(true);
		}
	    });
	
	pane0.add(spec);
	pane1.add(id_l);
	pane1.add(id_d);
	pane1.add(ssn_l);
	pane1.add(ssn_d);
	
	pane1.add(first_name_l);
	pane1.add(first_name_d);
	
	pane1.add(middle_name_l);
	pane1.add(middle_name_d);
	
	pane1.add(last_name_l);
	pane1.add(last_name_d);
	pane2.add(ok_b);
	pane2.add(cancel_b);

	frame.getContentPane().add(pane0, BorderLayout.NORTH);
	frame.getContentPane().add(pane1, BorderLayout.CENTER);
	frame.getContentPane().add(pane2, BorderLayout.SOUTH);
	
	frame.pack();
	frame.setVisible(true);
    }      
	
    public void do_query(String[] attributes, String query_string, 
			 Document doc, JTextPane qPane) {
	int count = 0;
	Connection con = connectIt();
	System.out.println(query_string);
	
	try {
	    Statement stmt = con.createStatement();
	    ResultSet rs =  stmt.executeQuery(query_string);
	    
	    while ( rs.next() ) {
		count++;
		for (int i=1; i<=20;i++) {
		    String name = rs.getString(i);
		    if (name == null) name = "N/A";
		    try {
			doc.insertString(doc.getLength(), 
					 attributes[i-1]+"\n", 
					 qPane.getStyle("bold"));
			doc.insertString(doc.getLength(), 
					 name.replace('|','\n')+"\n"+"\n",
					 qPane.getStyle("regular"));
		    } catch (BadLocationException ble) {
			ErrorInfo.print("Error 1: Couldn't display!");
		    }
		}
	    }
	    stmt.close();
	}
	catch (SQLException ex ){
	    ErrorInfo.print("Error 2: while executing query.");
	}
	//System.out.println(count);
	
	if (count ==0) {
	    try {
		doc.insertString(doc.getLength(),"None\n\n", 
				 qPane.getStyle("regular"));
	    }catch (BadLocationException ble) {
		ErrorInfo.print("Error: Couldn't display!");
	    }
	}
    }
    
    public void do_query(String query_string, Vector data, Connection con,int numColumns) {
	try {
	    System.out.println(query_string);
	    Statement stmt = con.createStatement();
	    ResultSet rs =  stmt.executeQuery(query_string);

	    while ( rs.next() ) {
		Vector vec=new Vector(numColumns);
		for (int i=1; i<=numColumns;i++) {
		    String name = rs.getString(i);
		    if (name == null) name = "N/A";
		    vec.addElement(name);
		}
		data.addElement(vec);
	    }
	    stmt.close();
	}
	catch (SQLException ex ){
	    ErrorInfo.print("Error 2: while executing query.");
	}
    }

    public static void main(String[] args) {
	ApprovedApplicantQuery app=new ApprovedApplicantQuery();
	app.popup();
	
    }
}









