// This query is for all faculties.

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import java.lang.*; 


public class FacultyQuery extends Query {
    
    public FacultyQuery() {
	super ("select g.name.get_name(), g.ssn, g.sex, g.research_topics", "from faculty_staff_tab g");
    }
    
    public void popup() {
        conditions = "";
	int numColumns=4;
	final JFrame frame = new JFrame("Faculty List Query");

	String[] names= {"Name", "SSN", "Sex", "Research Topics"};
	
	final Vector attr =new Vector(numColumns);

	for (int i=0; i<numColumns; i++) attr.addElement(names[i]);
	final Vector data = new Vector(10,10);
	
	JTable table= new JTable(data, attr);
	table.setPreferredScrollableViewportSize(new Dimension(900, 70));
	
	JScrollPane scrollPane = new JScrollPane(table);
	scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	String query_string = command+' '+tables+' '+conditions;
	final Connection con = connectIt();

	do_query(query_string,data, con,numColumns);

	frame.getContentPane().add(scrollPane, BorderLayout.CENTER);

	JPanel pane1 = new JPanel();
	pane1.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane1.setLayout(new GridLayout(1, 0));
	
	JButton close_b =new JButton("Close");
	close_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    frame.setVisible(false);
		}
	    });

	pane1.add(close_b);

	frame.getContentPane().add(scrollPane, BorderLayout.CENTER);
	frame.getContentPane().add(pane1, BorderLayout.SOUTH);
	frame.pack();
	frame.setVisible(true);
    }
    
    public void do_query(String query_string, Vector data, Connection con,int numColumns) {
	try {
	    System.out.println(query_string);
	    Statement stmt = con.createStatement();
	    ResultSet rs =  stmt.executeQuery(query_string);
	    
	    while ( rs.next() ) {
		Vector vec=new Vector(numColumns);
		for (int i=1; i<=numColumns;i++) {
		    String name = rs.getString(i);
		    if (name == null) name = "N/A";
		    vec.addElement(name);
		}
		data.addElement(vec);
	    }
	    stmt.close();
	}
	catch (SQLException ex ){
	    ErrorInfo.print("Error 2: while executing query.");
	}
    }
    
    public static void main(String[] args) {
	FacultyQuery app=new FacultyQuery();
	app.popup();
	
    }
}
