//This query is for all classes queries.

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import java.lang.*; 


public class ClassesQuery extends Query {
    
    public ClassesQuery() {
	super("select p.course_name, p.course_number, p.section_number, p.semester, p.yyear, p.instructor.name.get_name()", "from course_tab p");
    }
    
    public void popup() {
	conditions = "";

	final JFrame frame = new JFrame("Classes Query");

	final JFrame tframe =new JFrame("Query result");
	
	JPanel pane0 = new JPanel();
	pane0.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane0.setLayout(new GridLayout(1, 0));
	
	JPanel pane1 = new JPanel();
	pane1.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane1.setLayout(new GridLayout(5, 2));
	
	JPanel pane2 = new JPanel();
	pane2.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
	pane2.setLayout(new GridLayout(1, 2));

	final JTextField id_d = new JTextField(20);
	final JTextField ssn_d = new JTextField(10);
	final JTextField first_name_d = new JTextField(10);
	final JTextField middle_name_d = new JTextField(10);
	final JTextField last_name_d = new JTextField(4);
	
	final JLabel spec = new JLabel("Please enter some items: ",
				       JLabel.CENTER);
	JLabel id_l = new JLabel("Course Name : ", JLabel.LEFT);
	JLabel ssn_l = new JLabel("Course Number : ", JLabel.LEFT);
	JLabel first_name_l = new JLabel("Section Number : ",JLabel.LEFT);
	JLabel middle_name_l = new JLabel("Semester : ", JLabel.LEFT);
	JLabel last_name_l = new JLabel("Year : ", JLabel.LEFT);

	JButton ok_b = new JButton("OK");
	JButton cancel_b =new JButton("Cancel");
	cancel_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    frame.setVisible(false);
		}
	    });
	ok_b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    //frame.setVisible(false);
		    String query_string=command+' '+tables;
		    String tmp_string="";
		    
		    if (!id_d.getText().equals("")) {
			tmp_string="p.course_name='"+id_d.getText()+"' ";
		    }
		    
		    if (!ssn_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string="p.course_number='"+ssn_d.getText()+"' ";
		    }
		    
		    if (!first_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"p.section_number='"
			    +first_name_d.getText()+"' ";
		    }
		    
		    if (!middle_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"p.semester='"
			    +middle_name_d.getText()+"' ";
		    }
		    
		    if (!last_name_d.getText().equals("")) {
			if(!tmp_string.equals(""))
			    tmp_string+="AND ";
			tmp_string=tmp_string+"p.yyear='"
			    +last_name_d.getText()+"'";
		    }

		    if (!tmp_string.toString().equals("")) {
			conditions = "where "+tmp_string;
			query_string=query_string+" "+conditions;
		    }
		    
		    int numColumns=6;
		    
		    String[] names= {"Course Name","Course Number","Section Number",
				     "Semester","Year","Instructor"};
	
		    final Vector attr =new Vector(numColumns);
		    
		    for (int i=0; i<numColumns; i++) attr.addElement(names[i]);
		    final Vector data = new Vector(10,10);
	
		    JTable table= new JTable(data, attr);
		    table.setPreferredScrollableViewportSize(new Dimension(900, 70));
	
		    JScrollPane scrollPane = new JScrollPane(table);
		    scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		    //String query_string = command+' '+tables+' '+conditions;
		    final Connection con = connectIt();
		    
		    do_query(query_string,data, con,numColumns);
		    
		    tframe.getContentPane().add(scrollPane, BorderLayout.CENTER);
		    
		    JPanel pane = new JPanel();
		    pane.setBorder(BorderFactory.createEmptyBorder(30,30,10,30));
		    pane.setLayout(new GridLayout(1, 0));
		    
		    JButton close_b =new JButton("Close");
		    close_b.addActionListener(new ActionListener() {
			    public void actionPerformed(ActionEvent e) {
				tframe.setVisible(false);
			    }
			});

		    pane.add(close_b);
		    tframe.getContentPane().add(scrollPane, BorderLayout.CENTER);
		    tframe.getContentPane().add(pane, BorderLayout.SOUTH);
		    tframe.pack();
		    tframe.setVisible(true);
		}
	    });

	pane0.add(spec);
	pane1.add(id_l);
	pane1.add(id_d);
	pane1.add(ssn_l);
	pane1.add(ssn_d);
	
	pane1.add(first_name_l);
	pane1.add(first_name_d);
	
	pane1.add(middle_name_l);
	pane1.add(middle_name_d);
	
	pane1.add(last_name_l);
	pane1.add(last_name_d);
	pane2.add(ok_b);
	pane2.add(cancel_b);

	frame.getContentPane().add(pane0, BorderLayout.NORTH);
	frame.getContentPane().add(pane1, BorderLayout.CENTER);
	frame.getContentPane().add(pane2, BorderLayout.SOUTH);
	frame.pack();
	frame.setVisible(true);
    }

    public void do_query(String query_string, Vector data, Connection con,int numColumns) {
	try {
	    System.out.println(query_string);
	    Statement stmt = con.createStatement();
	    ResultSet rs =  stmt.executeQuery(query_string);
	    
	    while ( rs.next() ) {
		Vector vec=new Vector(numColumns);
		for (int i=1; i<=numColumns;i++) {
		    String name = rs.getString(i);
		    if (name == null) name = "N/A";
		    vec.addElement(name);
		}
		data.addElement(vec);
	    }
	    stmt.close();
	}
	catch (SQLException ex ){
	    ErrorInfo.print("Error 2: while executing query.");
	}
    }

    public static void main(String[] args) {
	ClassesQuery app=new ClassesQuery();
	app.popup();
	
    }
}



