-- 32 bit register

entity D_LATCH is
    	port(dlin,lclock,lreset : in bit;
	dlout,dloutbar: out bit);
end D_LATCH;

architecture d_data of D_LATCH is
begin 
  	dlout <= not(dloutbar or lreset or (not(dlin) and lclock)) after 100ps ;
  	dloutbar <= dlout nor (dlin and lclock and not(lreset)) after 100ps;
end d_data;

entity Single_reg is
  	port(ffin,fclock,freset: in bit;
       	ffout,ffoutbar: out bit);
end Single_reg;

architecture ms_data of Single_reg is
  	signal q0,q0bar: bit;
  	signal fclockbar: bit;
  	label dl0,dl1;
  	component D_LATCH
    	port(dlin,lclock,lreset:in bit;dlout,dloutbar:out bit);
  	end component;
  	for dl0,dl1:D_LATCH
    		use entity D_LATCH(d_data);

begin 
  	fclockbar <= not(fclock) after 100ps;
  	dl0:D_LATCH port map(ffin,fclockbar,freset,q0,q0bar);
  	dl1:D_LATCH port map(q0,fclock,freset,ffout,ffoutbar);
end ms_data;

--following describes a 32 bits register

entity REG32 is
  port(data_in: in bit_vector(31 downto 0);
       rclock,rreset: in bit;
       data_out: out bit_vector(31 downto 0));
end REG32;

architecture reg_data of REG32 is
  	signal data_outbar: bit_vector(31 downto 0);
  	label ff0,ff1,ff2,ff3,ff4,ff5,ff6,ff7,ff8,ff9,ff10,ff11,ff12,
		ff13,ff14,ff15,ff16,ff17,ff18,ff19,ff20,ff21,ff22,ff23,
		ff24,ff25,ff26,ff27,ff28,ff29,ff30,ff31;
  	component Single_reg
     		port(ffin,fclock,freset:in bit;ffout,ffoutbar: out bit);
  	end component;
  	for ff0,ff1,ff2,ff3,ff4,ff5,ff6,ff7,ff8,ff9,ff10,ff11,ff12,
		ff13,ff14,ff15, ff16,ff17,ff18,ff19,ff20,ff21,ff22,ff23,
		ff24,ff25,ff26,ff27,ff28,ff29,ff30,ff31:Single_reg
    	use entity Single_reg(ms_data);
begin
  	ff0:Single_reg port map(data_in(0),rclock,rreset,data_out(0),
		data_outbar(0));
  	ff1:Single_reg port map(data_in(1),rclock,rreset,data_out(1),
		data_outbar(1));
  	ff2:Single_reg port map(data_in(2),rclock,rreset,data_out(2),
		data_outbar(2));
  	ff3:Single_reg port map(data_in(3),rclock,rreset,data_out(3),
		data_outbar(3));
  	ff4:Single_reg port map(data_in(4),rclock,rreset,data_out(4),
		data_outbar(4));
  	ff5:Single_reg port map(data_in(5),rclock,rreset,data_out(5),
		data_outbar(5));
  	ff6:Single_reg port map(data_in(6),rclock,rreset,data_out(6),
		data_outbar(6));
  	ff7:Single_reg port map(data_in(7),rclock,rreset,data_out(7),
		data_outbar(7));
  	ff8:Single_reg port map(data_in(8),rclock,rreset,data_out(8),
		data_outbar(8));
  	ff9:Single_reg port map(data_in(9),rclock,rreset,data_out(9),
		data_outbar(9));
  	ff10:Single_reg port map(data_in(10),rclock,rreset,data_out(10),
		data_outbar(10));
  	ff11:Single_reg port map(data_in(11),rclock,rreset,data_out(11),
		data_outbar(11));
  	ff12:Single_reg port map(data_in(12),rclock,rreset,data_out(12),
		data_outbar(12));
  	ff13:Single_reg port map(data_in(13),rclock,rreset,data_out(13),
		data_outbar(13));
  	ff14:Single_reg port map(data_in(14),rclock,rreset,data_out(14),
		data_outbar(14));
  	ff15:Single_reg port map(data_in(15),rclock,rreset,data_out(15),
		data_outbar(15));
  	ff16:Single_reg port map(data_in(16),rclock,rreset,data_out(16),
		data_outbar(16));
  	ff17:Single_reg port map(data_in(17),rclock,rreset,data_out(17),
		data_outbar(17));
  	ff18:Single_reg port map(data_in(18),rclock,rreset,data_out(18),
		data_outbar(18));
  	ff19:Single_reg port map(data_in(19),rclock,rreset,data_out(19),
		data_outbar(19));
  	ff20:Single_reg port map(data_in(20),rclock,rreset,data_out(20),
		data_outbar(20));
  	ff21:Single_reg port map(data_in(21),rclock,rreset,data_out(21),
		data_outbar(21));
  	ff22:Single_reg port map(data_in(22),rclock,rreset,data_out(22),
		data_outbar(22));
  	ff23:Single_reg port map(data_in(23),rclock,rreset,data_out(23),
		data_outbar(23));
  	ff24:Single_reg port map(data_in(24),rclock,rreset,data_out(24),
		data_outbar(24));
  	ff25:Single_reg port map(data_in(25),rclock,rreset,data_out(25),
		data_outbar(25));
  	ff26:Single_reg port map(data_in(26),rclock,rreset,data_out(26),
		data_outbar(26));
  	ff27:Single_reg port map(data_in(27),rclock,rreset,data_out(27),
		data_outbar(27));
  	ff28:Single_reg port map(data_in(28),rclock,rreset,data_out(28),
		data_outbar(28));
  	ff29:Single_reg port map(data_in(29),rclock,rreset,data_out(29),
		data_outbar(29));
  	ff30:Single_reg port map(data_in(30),rclock,rreset,data_out(30),
		data_outbar(30));
  	ff31:Single_reg port map(data_in(31),rclock,rreset,data_out(31),
		data_outbar(31));
end reg_data;
