entity D_LATCH3 is
    port(dlin : in bit_vector(2 downto 0);
	lclock,lreset :	in bit;
	dlout,dloutbar: out bit_vector(2 downto 0));
end D_LATCH3;

architecture logic of D_LATCH3 is
	signal t1, t2, t3,t4,t5 : bit_vector(2 downto 0);
begin
	t1 <= not(dlin);
	t2 <= x"ffffffff" when (lclock) 
		else x"00000000";
	t3 <= (t2 and t1);
	t4 <= (dlin and t2);
	t5 <= x"ffffffff" when (lreset)
		else x"00000000";

	dlout <= ((dloutbar nor t3) and (not(t5))) after 100ps;
	dloutbar <= (dlout nor t4) after 300ps;
	
end logic;

entity reg3 is
	port( 	data_in : in bit_vector(2 downto 0);
		lclock, lreset: in bit;
		data_out : out bit_vector(2 downto 0));
end reg3;

architecture logic of reg3 is
	signal q0,q0bar,tmp: bit_vector(2 downto 0);
	signal lclock_bar,lclock_bar_bar : bit;
	label l0,l1;
	component D_LATCH3
		port(dlin : in bit_vector(2 downto 0);
		lclock,lreset :	in bit;
		dlout,dloutbar: out bit_vector(2 downto 0));
	end component;
	for l0,l1:D_LATCH3 use entity D_LATCH3(logic);
begin
	lclock_bar<= (not(lclock));
	lclock_bar_bar<=(not(lclock_bar));
	
	l0:D_LATCH3 port map(data_in,lclock_bar,lreset,q0,q0bar);

  	l1:D_LATCH3 port map(q0,lclock,lreset,data_out,tmp);
	
end logic;
