-- following describes the features of the instruction fetch cycle of pipeline

entity ifstage is
  port (npcnew: in bit_vector(31 downto 0);
	controlpc,adderenable,ifclock,ifreset: in bit;
	instrmemaddr: in bit_vector(4 downto 0);
	instrmemdata: in bit_vector(31 downto 0);
	instrmemwren: in bit;
	stall       : in bit;
  	npc,ir: out bit_vector(31 downto 0));
end ifstage;

architecture ifdata of ifstage is
  label mu0,mu1;
  component mux32_2_1
    port(a,b : in bit_vector(31 downto 0);
	 s : in bit;
	 q : out bit_vector (31 downto 0));
  end component;
  for mu0,mu1:mux32_2_1 use entity mux32_2_1(logic);
  label a0;
  component adder_32
    port(a, b : in bit_vector (31 downto 0);
	CarryIn : in bit;
	sum : out bit_vector (31 downto 0);
	CarryOut : out bit);
  end component;
  for a0:adder_32 use entity adder_32(logic);
  label rf0;
  component registers
    port (read0addr,read1addr,writeaddr: in bit_vector(4 downto 0);
	  writedata: in bit_vector(31 downto 0);
	  write_en,rf_clock,rf_reset: in bit;
	  read0data,read1data: out bit_vector(31 downto 0));  
  end component;
  for rf0:registers use entity registers(logic); 
  label r0;
  component REG32
     port(data_in: in bit_vector(31 downto 0);
	rclock,rreset: in bit;
       	data_out: out bit_vector(31 downto 0));
  end component;
  for r0:REG32 use entity REG32(reg_data);


  signal gap,pcplus4,pcout: bit_vector(31 downto 0);
  signal carryin,carryout,writen,final_clock: bit;
  signal read1d: bit_vector(31 downto 0);
  signal read1a: bit_vector(4 downto 0);
  signal tmp: bit_vector(31 downto 0);
  signal tmp1: bit_vector(31 downto 0);
begin
  
  gap <= x"00000001";
  carryin <= "0";
  writen <= "1";
  
  final_clock <=ifclock and (not(stall));
  r0: REG32 port map(tmp,final_clock,ifreset,pcout);
  a0: adder_32 port map(pcout,gap,carryin,pcplus4,carryout);
  mu0: mux32_2_1 port map(npcnew,pcplus4,controlpc,tmp1);
  mu1: mux32_2_1 port map(tmp, tmp1,controlpc, tmpnew1);
--a new mux to choose the instrction from pc0 or itself(pc1)
  npc <= tmp after 100ps; 
  rf0: registers port map(pcout(4 downto 0),read1a,instrmemaddr,instrmemdata,instrmemwren,final_clock,"0",ir,read1d);
end ifdata;
  







