entity dlx is
  port(instrmemaddr: in bit_vector(4 downto 0);
       instrmemdata: in bit_vector(31 downto 0);
       instrmemwren: in bit;
       dlxclock,dlxreset,pcreset: in bit;
       wbdata: in bit_vector(31 downto 0);
       wbaddr: in bit_vector(4 downto 0);
       wbenable : in bit;
       result: out bit_vector(31 downto 0);
       addres: out bit_vector(4 downto 0));
end dlx;

architecture dlx_str of dlx is

  label if0;
  component ifstage
    port (npcnew: in bit_vector(31 downto 0);
	controlpc,adderenable,ifclock,ifreset: in bit;
	instrmemaddr: in bit_vector(4 downto 0);
	instrmemdata: in bit_vector(31 downto 0);
	instrmemwren: in bit;
        stall: in bit;
  	npc,ir: out bit_vector(31 downto 0));
  end component;
  for if0:ifstage use entity ifstage(ifdata);

// two new ifstage for another two dlx
  label if1;
  component newifstage
    port (npcnew1: in bit_vector(31 downto 0);
	controlpc1,adderenable1,ifclock1,ifreset1: in bit;
	instrmemaddr1: in bit_vector(4 downto 0);
	instrmemdata1: in bit_vector(31 downto 0);
	instrmemwren1: in bit;
        stall1: in bit;
  	npc1,ir1: out bit_vector(31 downto 0));
  end component;
  for if1:ifstage use entity ifstage(ifdata);

  label if2;
  component newifstage
    port (npcnew2: in bit_vector(31 downto 0);
	controlpc2,adderenable2,ifclock2,ifreset2: in bit;
	instrmemaddr2: in bit_vector(4 downto 0);
	instrmemdata2: in bit_vector(31 downto 0);
	instrmemwren2: in bit;
        stall2: in bit;
  	npc2,ir2: out bit_vector(31 downto 0));
  end component;
  for if2:ifstage use entity ifstage(ifdata);


  label ifid0;
  component IF_ID_REG
    port(instru_in, pcaddr_in: in bit_vector(31 downto 0);
       pclock, preset,stallsig: in bit;
       instru_out, pcaddr_out: out bit_vector(31 downto 0));
  end component;
  for ifid0:IF_ID_REG use entity IF_ID_REG(ifid_reg);

 label ifid1;
  component IF_ID_REG
    port(instru_in1, pcaddr_in1: in bit_vector(31 downto 0);
       pclock1, preset1,stallsig1: in bit;
       instru_out1, pcaddr_out1: out bit_vector(31 downto 0));
  end component;
  for ifid1:IF_ID_REG use entity IF_ID_REG(ifid_reg);

 label ifid2;
  component IF_ID_REG
    port(instru_in2, pcaddr_in2: in bit_vector(31 downto 0);
       pclock2, preset2,stallsig2: in bit;
       instru_out2, pcaddr_out2: out bit_vector(31 downto 0));
  end component;
  for ifid2:IF_ID_REG use entity IF_ID_REG(ifid_reg);

  label id0;
  component idstage
    port(npc,ir,wbdata: in bit_vector(31 downto 0);
       wbaddr: in bit_vector(4 downto 0);
       writen,idclock,idreset,branchctrl: in bit;
       opcodeout: out bit_vector(5 downto 0);
       branchpc,idexa,idexb,ideximm: out bit_vector(31 downto 0);
       wbaddrpass0,wbaddrpass1: out bit_vector(4 downto 0);
       controlpc: out bit);
  end component;
  for id0:idstage use entity idstage(iddata);

 label id1;
  component idstage
    port(npc1,ir1,wbdata1: in bit_vector(31 downto 0);
       wbaddr1: in bit_vector(4 downto 0);
       writen1,idclock1,idreset1,branchctrl1: in bit;
       opcodeout1: out bit_vector(5 downto 0);
       branchpc1,idexa1,idexb1,ideximm1: out bit_vector(31 downto 0);
       wbaddrpass01,wbaddrpass11: out bit_vector(4 downto 0);
       controlpc1: out bit);
  end component;
  for id1:idstage use entity idstage(iddata);

  label id2;
  component idstage
    port(npc2,ir2,wbdata2: in bit_vector(31 downto 0);
       wbaddr2: in bit_vector(4 downto 0);
       writen2,idclock2,idreset2,branchctrl2: in bit;
       opcodeout2: out bit_vector(5 downto 0);
       branchpc2,idexa2,idexb2,ideximm2: out bit_vector(31 downto 0);
       wbaddrpass02,wbaddrpass12: out bit_vector(4 downto 0);
       controlpc2: out bit);
  end component;
  for id2:idstage use entity idstage(iddata);

  label idex0;
  component ID_EX_REG 
     port(data1_in, data2_in, sign_in: in bit_vector(31 downto 0);
       instr1_in, instr2_in,forwdesin0,forwdesin1: in bit_vector(4 downto 0);
       funcin: in bit_vector(3 downto 0);
       pclock, preset: in bit; 
       opcodein: in bit_vector(5 downto 0);
       data1_out, data2_out, sign_out: out bit_vector(31 downto 0);
       instr1_out, instr2_out,forwdesout0,forwdesout1: out bit_vector(4 downto 0);
       opcodeout: out bit_vector(5 downto 0);
       funcout: out bit_vector(3 downto 0));     
  end component;
  for idex0:ID_EX_REG use entity ID_EX_REG(logic);

label idex1;
  component ID_EX_REG 
     port(data1_in1, data2_in1, sign_in1: in bit_vector(31 downto 0);
       instr1_in1, instr2_in1,forwdesin01,forwdesin11: in bit_vector(4 downto 0);
       funcin1: in bit_vector(3 downto 0);
       pclock1, preset1: in bit; 
       opcodein1: in bit_vector(5 downto 0);
       data1_out1, data2_out1, sign_out1: out bit_vector(31 downto 0);
       instr1_out1, instr2_out1,forwdesout01,forwdesout11: out bit_vector(4 downto 0);
       opcodeout1: out bit_vector(5 downto 0);
       funcout1: out bit_vector(3 downto 0));     
  end component;
  for idex1:ID_EX_REG use entity ID_EX_REG(logic);

label idex2;
  component ID_EX_REG 
     port(data1_in2, data2_in2, sign_in2: in bit_vector(31 downto 0);
       instr1_in2, instr2_in2,forwdesin02,forwdesin12: in bit_vector(4 downto 0);
       funcin2: in bit_vector(3 downto 0);
       pclock2, preset2: in bit; 
       opcodein2: in bit_vector(5 downto 0);
       data1_out2, data2_out2, sign_out2: out bit_vector(31 downto 0);
       instr1_out2, instr2_out2,forwdesout02,forwdesout12: out bit_vector(4 downto 0);
       opcodeout2: out bit_vector(5 downto 0);
       funcout2: out bit_vector(3 downto 0));     
  end component;
  for idex2:ID_EX_REG use entity ID_EX_REG(logic);


  label ex0;
  component exstage 
    port(a, b0,fralu,frmem : in bit_vector (31 downto 0); --alu inputs
	func : in bit_vector (3 downto 0);   --function code, see alu_32
	s1,s2 : in bit;            --control : b0 ,Imm,fralu or frmem
        s3,s4 : in bit;       --control : a, fralu or frmem
	mux_s : in bit;        --control : instr1_in or instr2_in
	Imm : in bit_vector (31 downto 0);
	instr1_in : in bit_vector(4 downto 0);
	instr2_in : in bit_vector(4 downto 0);
	sum : out bit_vector (31 downto 0);        -- alu output
	b_out : out bit_vector (31 downto 0);      -- output to next stage
	CarryOut : out bit;                       -- overflow
 	instr_out : out bit_vector(4 downto 0));     -- output to next stage    
  end component;
  for ex0:exstage use entity exstage(logic);

 label ex1;
  component exstage 
    port(a1, b01,fralu1,frmem1 : in bit_vector (31 downto 0); --alu inputs
	func1 : in bit_vector (3 downto 0);   --function code, see alu_32
	s11,s21 : in bit;            --control : b0 ,Imm,fralu or frmem
        s31,s41 : in bit;       --control : a, fralu or frmem
	mux_s1 : in bit;        --control : instr1_in or instr2_in
	Imm1 : in bit_vector (31 downto 0);
	instr1_in1 : in bit_vector(4 downto 0);
	instr2_in1 : in bit_vector(4 downto 0);
	sum1 : out bit_vector (31 downto 0);        -- alu output
	b_out1 : out bit_vector (31 downto 0);      -- output to next stage
	CarryOut1 : out bit;                       -- overflow
 	instr_out1 : out bit_vector(4 downto 0));     -- output to next stage    
  end component;
  for ex1:exstage use entity exstage(logic);

 label ex2;
  component exstage 
    port(a12, b012,fralu12,frmem12 : in bit_vector (31 downto 0); --alu inputs
	func12 : in bit_vector (3 downto 0);   --function code, see alu_32
	s112,s212 : in bit;            --control : b0 ,Imm,fralu or frmem
        s312,s412 : in bit;       --control : a, fralu or frmem
	mux_s12 : in bit;        --control : instr1_in or instr2_in
	Imm12 : in bit_vector (31 downto 0);
	instr1_in12 : in bit_vector(4 downto 0);
	instr2_in12 : in bit_vector(4 downto 0);
	sum12 : out bit_vector (31 downto 0);        -- alu output
	b_out12 : out bit_vector (31 downto 0);      -- output to next stage
	CarryOut12 : out bit;                       -- overflow
 	instr_out12 : out bit_vector(4 downto 0));     -- output to next stage    
  end component;
  for ex2:exstage use entity exstage(logic);

  label exmem0;
  component EX_MEM_REG
    port(alures_in, data_in: in bit_vector(31 downto 0);
       instr_in,forwdesin0,forwdesin1: in bit_vector(4 downto 0);
       pclock, preset: in bit;
       opcodein: in bit_vector(5 downto 0);
       alures_out, data_out: out bit_vector(31 downto 0);
       instr_out,forwdesout0,forwdesout1: out bit_vector(4 downto 0); 
       opcodeout: out bit_vector(5 downto 0));
  end component;
  for exmem0:EX_MEM_REG use entity EX_MEM_REG(logic);

 label exmem1;
  component EX_MEM_REG
    port(alures_in1, data_in1: in bit_vector(31 downto 0);
       instr_in1,forwdesin01,forwdesin11: in bit_vector(4 downto 0);
       pclock1, preset1: in bit;
       opcodein1: in bit_vector(5 downto 0);
       alures_out1, data_out1: out bit_vector(31 downto 0);
       instr_out1,forwdesout01,forwdesout11: out bit_vector(4 downto 0); 
       opcodeout1: out bit_vector(5 downto 0));
  end component;
  for exmem1:EX_MEM_REG use entity EX_MEM_REG(logic);
  
 label exmem2;
  component EX_MEM_REG
    port(alures_in2, data_in2: in bit_vector(31 downto 0);
       instr_in2,forwdesin02,forwdesin12: in bit_vector(4 downto 0);
       pclock2, preset2: in bit;
       opcodein2: in bit_vector(5 downto 0);
       alures_out2, data_out2: out bit_vector(31 downto 0);
       instr_out2,forwdesout02,forwdesout12: out bit_vector(4 downto 0); 
       opcodeout2: out bit_vector(5 downto 0));
  end component;
  for exmem2:EX_MEM_REG use entity EX_MEM_REG(logic);

  label mem0;
  component memstage
    port( alu_in,data_in,frexe,frmem: in bit_vector(31 downto 0);
	write_en,smem1,smem2 : in bit;
       reg_addr_in: in bit_vector(4 downto 0);
       pclock : in bit;
       data_out, alu_out: out bit_vector(31 downto 0);
       reg_addr_out: out bit_vector(4 downto 0));
  end component;
  for mem0:memstage use entity memstage(logic);

 label mem1;
  component memstage
    port( alu_in1,data_in1,frexe1,frmem1: in bit_vector(31 downto 0);
	write_en1,smem11,smem21 : in bit;
       reg_addr_in1: in bit_vector(4 downto 0);
       pclock1 : in bit;
       data_out1, alu_out1: out bit_vector(31 downto 0);
       reg_addr_out1: out bit_vector(4 downto 0));
  end component;
  for mem1:memstage use entity memstage(logic);

 label mem2;
  component memstage
    port( alu_in2,data_in2,frexe2,frmem2: in bit_vector(31 downto 0);
	write_en2,smem12,smem22 : in bit;
       reg_addr_in2: in bit_vector(4 downto 0);
       pclock2 : in bit;
       data_out2, alu_out2: out bit_vector(31 downto 0);
       reg_addr_out2: out bit_vector(4 downto 0));
  end component;
  for mem2:memstage use entity memstage(logic);
  

  label memwb0;
  component MEM_WB_REG
     port(data_in,alures_in: in bit_vector(31 downto 0);
       instr_in: in bit_vector(4 downto 0);
       pclock, preset: in bit;
       data_out,alures_out: out bit_vector(31 downto 0);
       instr_out: out bit_vector(4 downto 0));
  end component;
  for memwb0:MEM_WB_REG use entity MEM_WB_REG(logic);

 label memwb1;
  component MEM_WB_REG
     port(data_in1,alures_in1: in bit_vector(31 downto 0);
       instr_in1: in bit_vector(4 downto 0);
       pclock1, preset1: in bit;
       data_out1,alures_out1: out bit_vector(31 downto 0);
       instr_out1: out bit_vector(4 downto 0));
  end component;
  for memwb1:MEM_WB_REG use entity MEM_WB_REG(logic);

 label memwb2;
  component MEM_WB_REG
     port(data_in2,alures_in2: in bit_vector(31 downto 0);
       instr_in2: in bit_vector(4 downto 0);
       pclock2, preset2: in bit;
       data_out2,alures_out2: out bit_vector(31 downto 0);
       instr_out2: out bit_vector(4 downto 0));
  end component;
  for memwb2:MEM_WB_REG use entity MEM_WB_REG(logic);


  --label wb0;
  --component WB_STG
    --port(data1_in, data2_in: in bit_vector(31 downto 0);
    --     instr_in: in bit_vector(4 downto 0);
    --     ps: in bit;
    --     data_out: out bit_vector(31 downto 0);
    --     instr_out: out bit_vector(4 downto 0));
  --end component;
  --for wb0:WB_STG use entity WB_STG(wbstg);


  --label wb1;
  --component WB_STG
    --port(data1_in1, data2_in1: in bit_vector(31 downto 0);
    --     instr_in1: in bit_vector(4 downto 0);
    --     ps1: in bit;
    --     data_out1: out bit_vector(31 downto 0);
    --     instr_out1: out bit_vector(4 downto 0));
  --end component;
  --for wb1:WB_STG use entity WB_STG(wbstg);
  
  --label wb2;
  --component WB_STG
    --port(data1_in2, data2_in2: in bit_vector(31 downto 0);
    --     instr_in2: in bit_vector(4 downto 0);
    --     ps2: in bit;
    --     data_out2: out bit_vector(31 downto 0);
    --     instr_out2: out bit_vector(4 downto 0));
  --end component;
  --for wb2:WB_STG use entity WB_STG(wbstg);
  

  label ctrl0;
  component control_unit
    port(IR : in bit_vector(5 downto 0);
	 lclock,stall: in bit;
	 if_id_reset : out bit;
	 c : out bit_vector(7 downto 0));
  end component; 
  for ctrl0:control_unit use entity control_unit(logic);

 label ctrl1;
  component control_unit
    port(IR1 : in bit_vector(5 downto 0);
	 lclock1,stall1: in bit;
	 if_id_reset1 : out bit;
	 c1 : out bit_vector(7 downto 0));
  end component; 
  for ctrl1:control_unit use entity control_unit(logic);

 label ctrl2;
  component control_unit
    port(IR2 : in bit_vector(5 downto 0);
	 lclock2,stall2: in bit;
	 if_id_reset2 : out bit;
	 c2 : out bit_vector(7 downto 0));
  end component; 
  for ctrl2:control_unit use entity control_unit(logic);
 
  label m1;
  component mux32_4_1
    port(a,b,c,d : in bit_vector(31 downto 0);
	s1,s2 : in bit;
	q :   out bit_vector(31 downto 0));
  end component;
  for m1:mux32_4_1 use entity mux32_4_1(logic);

 label m11;
  component mux32_4_1
    port(a1,b1,c1,d1 : in bit_vector(31 downto 0);
	s11,s21 : in bit;
	q1 :   out bit_vector(31 downto 0));
  end component;
  for m11:mux32_4_1 use entity mux32_4_1(logic);

label m12;
  component mux32_4_1
    port(a2,b2,c2,d2 : in bit_vector(31 downto 0);
	s12,s22 : in bit;
	q2 :   out bit_vector(31 downto 0));
  end component;
  for m12:mux32_4_1 use entity mux32_4_1(logic);

  label hzdec0;
  component hd_detection
    port (if_id_src1 : in bit_vector(4 downto 0);
	      if_id_src2 : in bit_vector(4 downto 0);
	      if_id_opcode : in bit_vector(5 downto 0);
	      id_ex_des  : in bit_vector(4 downto 0);
	      id_ex_opcode : in bit_vector(5 downto 0);	
	      stall    : out bit);
  end component;
  for hzdec0:hd_detection use entity hd_detection(logic);

 label hzdec1;
  component hd_detection
    port (if_id_src11 : in bit_vector(4 downto 0);
	      if_id_src21 : in bit_vector(4 downto 0);
	      if_id_opcode1 : in bit_vector(5 downto 0);
	      id_ex_des1  : in bit_vector(4 downto 0);
	      id_ex_opcode1 : in bit_vector(5 downto 0);	
	      stall1    : out bit);
  end component;
  for hzdec1:hd_detection use entity hd_detection(logic);

 label hzdec2;
  component hd_detection
    port (if_id_src12 : in bit_vector(4 downto 0);
	      if_id_src22 : in bit_vector(4 downto 0);
	      if_id_opcode2 : in bit_vector(5 downto 0);
	      id_ex_des2  : in bit_vector(4 downto 0);
	      id_ex_opcode2 : in bit_vector(5 downto 0);	
	      stall2    : out bit);
  end component;
  for hzdec2:hd_detection use entity hd_detection(logic);

  label forw0;
  component forwarding
    port (    fclock: in bit;
	      if_id_src1 : in bit_vector(4 downto 0);
	      if_id_src2 : in bit_vector(4 downto 0);
	      if_id_opcode : in bit_vector(5 downto 0);
	      id_ex_des  : in bit_vector(4 downto 0);
	      id_ex_opcode : in bit_vector(5 downto 0);
	      ex_mem_des : in bit_vector(4 downto 0);
	      ex_mem_opcode : in bit_vector(5 downto 0);
	      stall : in bit;
	      controls1_exe : out bit_vector(1 downto 0);
	      controls2_exe : out bit_vector(1 downto 0);
	      controls1_mem : out bit_vector(1 downto 0));
  end component;
  for forw0:forwarding use entity forwarding(forwarding_logic);


label forw1;
  component forwarding
    port (    fclock1: in bit;
	      if_id_src11 : in bit_vector(4 downto 0);
	      if_id_src21 : in bit_vector(4 downto 0);
	      if_id_opcode1 : in bit_vector(5 downto 0);
	      id_ex_des1  : in bit_vector(4 downto 0);
	      id_ex_opcode1 : in bit_vector(5 downto 0);
	      ex_mem_des1 : in bit_vector(4 downto 0);
	      ex_mem_opcode1 : in bit_vector(5 downto 0);
	      stall1 : in bit;
	      controls1_exe1 : out bit_vector(1 downto 0);
	      controls2_exe1 : out bit_vector(1 downto 0);
	      controls1_mem1 : out bit_vector(1 downto 0));
  end component;
  for forw1:forwarding use entity forwarding(forwarding_logic);

label forw2;
  component forwarding
    port (    fclock2: in bit;
	      if_id_src12 : in bit_vector(4 downto 0);
	      if_id_src22 : in bit_vector(4 downto 0);
	      if_id_opcode2 : in bit_vector(5 downto 0);
	      id_ex_des2  : in bit_vector(4 downto 0);
	      id_ex_opcode2 : in bit_vector(5 downto 0);
	      ex_mem_des2 : in bit_vector(4 downto 0);
	      ex_mem_opcode2 : in bit_vector(5 downto 0);
	      stall2 : in bit;
	      controls1_exe2 : out bit_vector(1 downto 0);
	      controls2_exe2 : out bit_vector(1 downto 0);
	      controls1_mem2 : out bit_vector(1 downto 0));
  end component;
  for forw2:forwarding use entity forwarding(forwarding_logic);


  signal npc,ir: bit_vector(31 downto 0); 
  signal opcode,opcode1,opcode2 : bit_vector(5 downto 0);
  signal branchpc: bit_vector(31 downto 0);
  signal instr_out,pcaddr_out: bit_vector(31 downto 0);
  signal idexa,idexb,ideximm: bit_vector(31 downto 0);
  signal wbaddrpass0,wbaddrpass1: bit_vector(4 downto 0);
  --signal writeen,
  signal controlpc: bit;
  --signal rfclock,rfreset: bit;
  signal data1_out,data2_out,sign_out: bit_vector(31 downto 0);
  signal instr1_out,instr2_out: bit_vector(4 downto 0);
  --signal func: bit_vector(3 downto 0);
  --signal s,mux_s,
  signal CarryOut: bit;
  signal sum,b_out: bit_vector(31 downto 0);
  signal aludata,data,rdata,alures: bit_vector(31 downto 0);
  signal data_out,alures_out: bit_vector(31 downto 0);
  signal instr3_out: bit_vector(4 downto 0);
  signal instr4_out,instr5_out: bit_vector(4 downto 0);
  signal functemp: bit_vector(3 downto 0);
  signal c : bit_vector(7 downto 0);
  signal realwben : bit ;
  signal forwdespass0,forwdespass1,forwdespass2,forwdespass3:  bit_vector(4 downto 0);
  signal tmpalu,tmpmem,tempmem: bit_vector(31 downto 0);
  signal stall: bit;
  signal adderen : bit;
  signal wrbackdata: bit_vector (31 downto 0);
  signal wraddress: bit_vector(4 downto 0);
  signal if_id_reset, tmp_reset: bit;
  signal ctrls1_ex,ctrls2_ex,ctrls1_mem : bit_vector(1 downto 0);
  signal alusrc1,alusrc2 : bit;


  signal npc1,ir1: bit_vector(31 downto 0); 
  signal opcode1,opcode11,opcode21 : bit_vector(5 downto 0);
  signal branchpc1: bit_vector(31 downto 0);
  signal instr_out1,pcaddr_out1: bit_vector(31 downto 0);
  signal idexa1,idexb1,ideximm1: bit_vector(31 downto 0);
  signal wbaddrpass01,wbaddrpass11: bit_vector(4 downto 0);
  --signal writeen1,
  signal controlpc1: bit;
  --signal rfclock1,rfreset1: bit;
  signal data1_out1,data2_out1,sign_out1: bit_vector(31 downto 0);
  signal instr1_out1,instr2_out1: bit_vector(4 downto 0);
  --signal func1: bit_vector(3 downto 0);
  --signal s1,mux_s1,
  signal CarryOut1: bit;
  signal sum,b_out1: bit_vector(31 downto 0);
  signal aludata1,data1,rdata1,alures1: bit_vector(31 downto 0);
  signal data_out1,alures_out1: bit_vector(31 downto 0);
  signal instr3_out1: bit_vector(4 downto 0);
  signal instr4_out1,instr5_out1: bit_vector(4 downto 0);
  signal functemp1: bit_vector(3 downto 0);
  signal c1 : bit_vector(7 downto 0);
  signal realwben1 : bit ;
  signal forwdespass01,forwdespass11,forwdespass21,forwdespass31:  bit_vector(4 downto 0);
  signal tmpalu1,tmpmem1,tempmem1: bit_vector(31 downto 0);
  signal stall1: bit;
  signal adderen1 : bit;
  signal wrbackdata1: bit_vector (31 downto 0);
  signal wraddress1: bit_vector(4 downto 0);
  signal if_id_reset1, tmp_reset1: bit;
  signal ctrls1_ex1,ctrls2_ex1,ctrls1_mem1 : bit_vector(1 downto 0);
  signal alusrc11,alusrc21 : bit;


signal npc2,ir2: bit_vector(31 downto 0); 
  signal opcode2,opcode12,opcode22 : bit_vector(5 downto 0);
  signal branchpc2: bit_vector(31 downto 0);
  signal instr_out2,pcaddr_out2: bit_vector(31 downto 0);
  signal idexa2,idexb2,ideximm2: bit_vector(31 downto 0);
  signal wbaddrpass02,wbaddrpass12: bit_vector(4 downto 0);
  --signal writeen2,
  signal controlpc2: bit;
  --signal rfclock2,rfreset2: bit;
  signal data1_out2,data2_out2,sign_out2: bit_vector(31 downto 0);
  signal instr1_out2,instr2_out2: bit_vector(4 downto 0);
  --signal func2: bit_vector(3 downto 0);
  --signal s2,mux_s2,
  signal CarryOut2: bit;
  signal sum,b_out2: bit_vector(31 downto 0);
  signal aludata2,data2,rdata2,alures2: bit_vector(31 downto 0);
  signal data_out2,alures_out2: bit_vector(31 downto 0);
  signal instr3_out2: bit_vector(4 downto 0);
  signal instr4_out2,instr5_out2: bit_vector(4 downto 0);
  signal functemp2: bit_vector(3 downto 0);
  signal c2 : bit_vector(7 downto 0);
  signal realwben2 : bit ;
  signal forwdespass02,forwdespass12,forwdespass22,forwdespass32:  bit_vector(4 downto 0);
  signal tmpalu2,tmpmem2,tempmem2: bit_vector(31 downto 0);
  signal stall2: bit;
  signal adderen2 : bit;
  signal wrbackdata2: bit_vector (31 downto 0);
  signal wraddress2: bit_vector(4 downto 0);
  signal if_id_reset2, tmp_reset2: bit;
  signal ctrls1_ex2,ctrls2_ex2,ctrls1_mem2 : bit_vector(1 downto 0);
  signal alusrc12,alusrc22 : bit;


begin 
  realwben <= (c(3) or wbenable) after 100ps;
  
  if_id_reset<=((tmp_reset and instr_out(31)) or dlxreset) after 1ns;
  adderen <= not(stall) after 1ps;
  alusrc1 <= c(6) or ctrls2_ex(0) after 1ps;   
  alusrc2 <= c(6) or ctrls2_ex(1) after 1ps;

  if0: ifstage port map(branchpc,controlpc,adderen,dlxclock,pcreset,instrmemaddr,instrmemdata,instrmemwren,stall,npc,ir);
  ifid0: IF_ID_REG port map(ir,npc,dlxclock,if_id_reset,stall,instr_out,pcaddr_out);
  wrbackdata <= wbdata or result after 10ps;
  wraddress <= wbaddr or addres after 10ps;
  id0: idstage port map(pcaddr_out,instr_out,wrbackdata,wraddress,realwben,dlxclock,dlxreset,c(0),opcode,
			branchpc,idexa,idexb,ideximm,wbaddrpass0,wbaddrpass1,controlpc);
  idex0: ID_EX_REG port map(idexa,idexb,ideximm,wbaddrpass0,wbaddrpass1,instr_out(20 downto 16),instr_out(15 downto 11),instr_out(3 downto 0),dlxclock,dlxreset,opcode,data1_out,data2_out,sign_out,instr1_out,instr2_out,forwdespass0,forwdespass1,opcode1,functemp);

  ex0: exstage port map(data1_out,data2_out,tmpalu,tmpmem,functemp,ctrls1_ex(0),ctrls1_ex(1),alusrc1,alusrc2,c(7),sign_out,instr1_out,instr2_out,sum,b_out,CarryOut,instr3_out);
  tmpalu <= sum after 100ps;
  exmem0: EX_MEM_REG port map(sum,b_out,instr3_out,forwdespass0,forwdespass1,dlxclock,dlxreset,opcode1,alures,data,instr4_out,forwdespass2,forwdespass3,opcode2);
  mem0: memstage port map(aludata,data,tmpalu,tempmem,c(2),ctrls1_mem(0),ctrls1_mem(1),instr4_out,dlxclock,rdata,alures,instr5_out);
  tmpmem <= rdata after 100ps;
  tempmem <= rdata after 100ps;
  memwb0: MEM_WB_REG port map(rdata,alures,instr4_out,dlxclock,dlxreset,data_out,alures_out,addres);
  m1: mux32_4_1 port map(data_out,alures_out,x"00000000",x"00000000",c(5),c(4),result);
  ctrl0: control_unit port map(instr_out(31 downto 26),dlxclock,stall,tmp_reset,c);
  hzdec0: hd_detection port map(instr_out(25 downto 21),instr_out(20 downto 16),instr_out(31 downto 26),forwdespass0,opcode1,stall);
  forw0: forwarding port map(dlxclock,instr_out(25 downto 21),instr_out(20 downto 16),instr_out(31 downto 26),forwdespass0,opcode1,forwdespass2,opcode2,stall,ctrls1_ex,ctrls2_ex,ctrls1_mem);

  realwben1 <= (c1(3) or wbenable1) after 100ps;
  
  if_id_reset1<=((tmp_reset1 and instr_out1(31)) or dlxreset1) after 1ns;
  adderen1 <= not(stall1) after 1ps;
  alusrc11 <= c1(6) or ctrls2_ex1(0) after 1ps;   
  alusrc21 <= c1(6) or ctrls2_ex1(1) after 1ps;

  if1: ifstage port map(branchpc1,controlpc1,adderen1,dlxclock1,pcreset1,instrmemaddr1,instrmemdata1,instrmemwren1,stall1,npc1,ir1);
  ifid1: IF_ID_REG port map(ir1,npc1,dlxclock1,if_id_reset1,stall1,instr_out1,pcaddr_out1);
  wrbackdata1 <= wbdata1 or result after 10ps;
  wraddress1 <= wbaddr1 or addres1 after 10ps;
  id1: idstage port map(pcaddr_out1,instr_out1,wrbackdata1,wraddress1,realwben1,dlxclock1,dlxreset1,c1(0),opcode1,
			branchpc1,idexa1,idexb1,ideximm1,wbaddrpass01,wbaddrpass11,controlpc1);
  idex1: ID_EX_REG port map(idexa1,idexb1,ideximm1,wbaddrpass01,wbaddrpass11,instr_out1(20 downto 16),instr_out1(15 downto 11),instr_out1(3 downto 0),dlxclock1,dlxreset1,opcode1,data1_out1,data2_out1,sign_out1,instr1_out1,instr2_out1,forwdespass01,forwdespass11,opcode11,functemp1);

  ex1: exstage port map(data1_out1,data2_out1,tmpalu1,tmpmem1,functemp1,ctrls1_ex(0)1,ctrls1_ex(1)1,alusrc1,alusrc21,c(7)1,sign_out1,instr1_out1,instr2_out1,sum1,b_out1,CarryOut1,instr3_out1);
  tmpalu1 <= sum after 100ps;
  exmem01: EX_MEM_REG port map(sum1,b_out1,instr3_out1,forwdespass01,forwdespass11,dlxclock1,dlxreset1,opcode1,alures1,data1,instr4_out1,forwdespass21,forwdespass31,opcode21);
  mem1: memstage port map(aludata1,data1,tmpalu1,tempmem1,c1(2),ctrls1_mem1(0),ctrls1_mem1(1),instr4_out1,dlxclock1,rdata1,alures1,instr5_out1);
  tmpmem1 <= rdata1 after 100ps;
  tempmem1 <= rdata1 after 100ps;
  memwb1: MEM_WB_REG port map(rdata1,alures1,instr4_out1,dlxclock1,dlxreset1,data_out1,alures_out1,addres1);
  m11: mux32_4_1 port map(data_out1,alures_out1,x"00000000",x"00000000",c1(5),c1(4),result1);
  ctrl1: control_unit port map(instr_out1(31 downto 26),dlxclock1,stall1,tmp_reset1,c1);
  hzdec1: hd_detection port map(instr_out1(25 downto 21),instr_out1(20 downto 16),instr_out1(31 downto 26),forwdespass01,opcode11,stall1);
  forw1: forwarding port map(dlxclock1,instr_out1(25 downto 21),instr_out1(20 downto 16),instr_out1(31 downto 26),forwdespass01,opcode11,forwdespass21,opcode21,stall1,ctrls1_ex1,ctrls2_ex1,ctrls1_mem1);


realwben2 <= (c2(3) or wbenable2) after 100ps;
  
  if_id_reset2<=((tmp_reset2 and instr_out2(31)) or dlxreset2) after 1ns;
  adderen2 <= not(stall2) after 1ps;
  alusrc12 <= c2(6) or ctrls2_ex2(0) after 1ps;   
  alusrc22 <= c2(6) or ctrls2_ex2(1) after 1ps;

  if2: ifstage port map(branchpc2,controlpc2,adderen2,dlxclock2,pcreset2,instrmemaddr2,instrmemdata2,instrmemwren2,stall2,npc2,ir2);
  ifid2: IF_ID_REG port map(ir2,npc2,dlxclock2,if_id_reset2,stall2,instr_out2,pcaddr_out2);
  wrbackdata2 <= wbdata2 or result after 10ps;
  wraddress2 <= wbaddr2 or addres2 after 10ps;
  id2: idstage2 port map(pcaddr_out2,instr_out2,wrbackdata2,wraddress2,realwben2,dlxclock2,dlxreset2,c2(0),opcode2,
			branchpc2,idexa2,idexb2,ideximm2,wbaddrpass02,wbaddrpass12,controlpc2);
  idex2: ID_EX_REG port map(idexa2,idexb2,ideximm2,wbaddrpass02,wbaddrpass12,instr_out2(20 downto 16),instr_out2(15 downto 11),instr_out2(3 downto 0),dlxclock2,dlxreset2,opcode2,data1_out2,data2_out2,sign_out2,instr1_out2,instr2_out2,forwdespass02,forwdespass12,opcode12,functemp2);

  ex2: exstage port map(data1_out2,data2_out2,tmpalu2,tmpmem2,functemp2,ctrls1_ex(0)2,ctrls1_ex(1)2,alusrc12,alusrc22,c2(7),sign_out2,instr1_out2,instr2_out2,sum2,b_out2,CarryOut2,instr3_out2);
  tmpalu2 <= sum2 after 100ps;
  exmem2: EX_MEM_REG port map(sum2,b_out2,instr3_out2,forwdespass02,forwdespass12,dlxclock2,dlxreset2,opcode12,alures2,data2,instr4_out2,forwdespass22,forwdespass32,opcode22);
  mem2: memstage port map(aludata2,data2,tmpalu2,tempmem2,c2(2),ctrls1_mem2(0),ctrls1_mem2(1),instr4_out2,dlxclock2,rdata2,alures2,instr5_out2);
  tmpmem2 <= rdata2 after 100ps;
  tempmem2 <= rdata2 after 100ps;
  memwb2: MEM_WB_REG port map(rdata2,alures2,instr4_out2,dlxclock2,dlxreset2,data_out2,alures_out2,addres2);
  m12: mux32_4_1 port map(data_out2,alures_out2,x"00000000",x"00000000",c2(5),c2(4),result2);
  ctrl02: control_unit port map(instr_out2(31 downto 26),dlxclock2,stall2,tmp_reset2,c2);
  hzdec2: hd_detection port map(instr_out2(25 downto 21),instr_out2(20 downto 16),instr_out2(31 downto 26),forwdespass02,opcode12,stall2);
  forw2: forwarding port map(dlxclock2,instr_out2(25 downto 21),instr_out2(20 downto 16),instr_out2(31 downto 26),forwdespass02,opcode12,forwdespass22,opcode22,stall2,ctrls1_ex2,ctrls2_ex2,ctrls1_mem2);

end dlx_str;





