entity MEM_WB_REG is
  port(data_in,alures_in: in bit_vector(31 downto 0);
       reg_addr_in: in bit_vector(4 downto 0);
       pclock, preset: in bit;
       s_enable_out: in bit;
       data_out,alures_out: out bit_vector(31 downto 0);
       reg_addr_out: out bit_vector(4 downto 0);
       s_reg_out : out bit_vector(4 downto 0));        
end MEM_WB_REG;

architecture logic of MEM_WB_REG is
  label memwbr0,memwbr1,memwbr2;
  
  component REG32
    port(data_in: in bit_vector(31 downto 0);
         rclock,rreset: in bit;
         data_out: out bit_vector(31 downto 0));
  end component;
  for memwbr0,memwbr1: REG32 use entity REG32(reg_data);
  
  component reg5
    port(data_in: in bit_vector(4 downto 0);
         rclock,rreset: in bit;
         data_out: out bit_vector(4 downto 0));
  end component;
  
  for memwbr2 : reg5 use entity reg5(logic);

begin
  memwbr0:REG32 port map(alures_in,pclock,preset,alures_out);
  memwbr1:REG32 port map(data_in,pclock,preset,data_out);
  memwbr2:reg5 port map(reg_addr_in,pclock,preset,reg_addr_out);
  s_reg_out <= reg_addr_out when (s_enable_out) else "00000" after 1ps; 
--'send' register address
end logic;

