entity IF_ID_REG is
  	port(instru_in, pcaddr_in: in bit_vector(31 downto 0);
       		pclock, preset,stallsig: in bit;
       		instru_out, pcaddr_out: out bit_vector(31 downto 0));
end IF_ID_REG;

architecture logic of IF_ID_REG is
  	label ifidr0,ifidr1;
  	component REG32
    		port(data_in: in bit_vector(31 downto 0);
         	rclock,rreset: in bit;
         	data_out: out bit_vector(31 downto 0));
  	end component;
  	for ifidr0,ifidr1: REG32 use entity REG32(reg_data);

  	signal stallclock : bit;
begin
  	stallclock <= pclock and not(stallsig);
  	ifidr0:REG32 port map(instru_in,stallclock,preset,instru_out);
  	ifidr1:REG32 port map(pcaddr_in,stallclock,preset,pcaddr_out);
end logic;

