-- pipeline, decide if there is data hazard and  add a stall.

entity hd_detection is 
	port (if_id_src1 : in bit_vector(4 downto 0);
	      if_id_src2 : in bit_vector(4 downto 0);
	      if_id_opcode : in bit_vector(5 downto 0);
	      id_ex_des  : in bit_vector(4 downto 0);
	      id_ex_opcode : in bit_vector(5 downto 0);
	      stall    : out bit);
end hd_detection;

architecture logic of hd_detection is
	signal t1 : bit_vector (4 downto 0);
	signal t2 : bit_vector (4 downto 0);
	signal alu_t, ld_t, all_0_bar : bit;
begin
	
	alu_t<=if_id_opcode(5) and not(if_id_opcode(4)) and 
		not(if_id_opcode(3)) and not(if_id_opcode(2)) 
		and not(if_id_opcode(1));
	
	all_0_bar<=id_ex_des(4) or id_ex_des(3) or id_ex_des(2) or id_ex_des(1)
		or id_ex_des(0);

	ld_t <=id_ex_opcode(5) and id_ex_opcode(4) and not(id_ex_opcode(3)) 
		and not(id_ex_opcode(2)) and not(id_ex_opcode(1));

	t1   <=not(if_id_src1 xor id_ex_des);

	t2   <=not(if_id_src2 xor id_ex_des);

	stall <=(alu_t and ld_t and t1(4) and  t1(3) and t1(2) and 
		t1(1) and t1(0) and all_0_bar) or (alu_t and ld_t and t2(4) 
		and t2(3) and t2(2) and t2(1) and t2(0) and all_0_bar);
	
end logic;
