-- alu exe stage
entity mux5_2_1 is port(
	a,b : in bit_vector(4 downto 0);
	s : in bit;
	q : out bit_vector (4 downto 0));
end mux5_2_1;

architecture logic of mux5_2_1 is
	signal t1,t2: bit_vector(4 downto 0);

begin
	t1(4 downto 0) <=a(4 downto 0) when (not(s))
		else "00000" ;
	t2(4 downto 0) <=b(4 downto 0) when s
		else "00000" ;
	q(4 downto 0) <=(t1(4 downto 0) or t2(4 downto 0));
end logic;

entity exstage is 
	port(
	a, b0,fralu,frmem : in bit_vector (31 downto 0); --alu inputs
	func : in bit_vector (3 downto 0);   --function code, see alu_32
	s1,s2 : in bit;            --control : b0 ,Imm,fralu or frmem
        s3,s4 : in bit;       --control : a, fralu or frmem
	mux_s : in bit;        --control : instr1_in or instr2_in
	Imm : in bit_vector (31 downto 0);
	instr1_in : in bit_vector(4 downto 0);
	instr2_in : in bit_vector(4 downto 0);
	sum : out bit_vector (31 downto 0);        -- alu output
	b_out : out bit_vector (31 downto 0);      -- output to next stage
	CarryOut : out bit;                       -- overflow
 	instr_out : out bit_vector(4 downto 0));     -- output to next stage	
end exstage;

architecture logic of exstage is 
	signal t0,t1 : bit_vector(31 downto 0);

	label mux4to1_1,mux4to1_2,mux2to1_2 , alu32;
	component mux32_4_1
           port (a,b,c,d : in bit_vector(31 downto 0);
	         s1,s2 : in bit;
	        q :   out bit_vector(31 downto 0));
        end component;         
 
	component mux5_2_1 port(
		a,b : in bit_vector(4 downto 0);
		s : in bit;
		q : out bit_vector (4 downto 0));
	end component;

	component alu_32 port(
		a, b : in bit_vector (31 downto 0);
		CarryIn,bi : in bit;
		op : in bit_vector (1 downto 0);
		sum : out bit_vector (31 downto 0);
		CarryOut : out bit);
	end component;

	for mux4to1_1,mux4to1_2 : mux32_4_1 use entity mux32_4_1(logic);
        --for mux4to1_2 : mux32_4_1 use entity mux32_4_1(logic);
	for mux2to1_2 : mux5_2_1 use entity mux5_2_1(logic);
	for alu32 : alu_32 use entity alu_32(logic);

begin
	mux4to1_1 : mux32_4_1 port map (b0,fralu,frmem,Imm,s1,s2,t1);
	mux4to1_2 : mux32_4_1 port map (a,fralu,frmem,x"00000000",s3,s4,t0);
	mux2to1_2 : mux5_2_1 port map (instr1_in,instr2_in,mux_s,instr_out);
	alu32: alu_32 port map (t0,t1, func(1), func(0),func(3 downto 2),sum,CarryOut);
	b_out<= b0;
end logic;
