entity EX_MEM_REG is
  port(alures_in, data_in: in bit_vector(31 downto 0);
       instr_in,forwdesin0,forwdesin1: in bit_vector(4 downto 0);
       pclock, preset: in bit;
       opcodein: in bit_vector(5 downto 0);
       alures_out, data_out: out bit_vector(31 downto 0);
       instr_out,forwdesout0,forwdesout1: out bit_vector(4 downto 0); 
       opcodeout: out bit_vector(5 downto 0));
end EX_MEM_REG;

architecture logic of EX_MEM_REG is
  	label exmemr0,exmemr1,exmemr2,exmemr3,exmemr4;
  	component REG32
    		port(data_in: in bit_vector(31 downto 0);
         	rclock,rreset: in bit;
         	data_out: out bit_vector(31 downto 0));
  	end component;
  	component reg5
    	port(data_in: in bit_vector(4 downto 0);
         	rclock,rreset: in bit;
         	data_out: out bit_vector(4 downto 0));
  	end component;
  	for exmemr0,exmemr1: REG32 use entity REG32(reg_data);
  	for exmemr2,exmemr3,exmemr4 : reg5 use entity reg5(logic);
  	label opcode;
  	component reg6
    		port(  data_in : in bit_vector(5 downto 0);
           	lclock, lreset: in bit;
           	data_out : out bit_vector(5 downto 0));
  	end component;
  	for opcode: reg6 use entity reg6(logic);
begin
  	exmemr0:REG32 port map(alures_in,pclock,preset,alures_out);
  	exmemr1:REG32 port map(data_in,pclock,preset,data_out);
  	exmemr2:reg5 port map(instr_in,pclock,preset,instr_out);
  	exmemr3:reg5 port map(forwdesin0,pclock,preset,forwdesout0);
  	exmemr4:reg5 port map(forwdesin1,pclock,preset,forwdesout1);
  	opcode:reg6 port map(opcodein,pclock,preset,opcodeout);
end logic;
