entity dlx is
  port(instrmemaddr: in bit_vector(4 downto 0);
       instrmemdata: in bit_vector(31 downto 0);
       instrmemwren: in bit;
       dlxclock,dlxreset,pcreset: in bit;
       wbdata: in bit_vector(31 downto 0);
       wbaddr: in bit_vector(4 downto 0);
       wbenable : in bit;
       result: out bit_vector(31 downto 0);
       addres: out bit_vector(4 downto 0));
end dlx;

architecture dlx_str of dlx is
  label if0, if1, if2; 
  component ifstage
    port (npcnew: in bit_vector(31 downto 0);
	controlpc,adderenable,ifclock,ifreset: in bit;
	instrmemaddr: in bit_vector(4 downto 0);
	instrmemdata: in bit_vector(31 downto 0);
	instrmemwren: in bit;
        stall: in bit;
  	npc,ir: out bit_vector(31 downto 0));
  end component;
  for if0,if1,if2:ifstage use entity ifstage(logic);

  label ifid0, ifid1, ifid2;
  component IF_ID_REG
    port(instru_in, pcaddr_in: in bit_vector(31 downto 0);
       pclock, preset,stallsig: in bit;
       instru_out, pcaddr_out: out bit_vector(31 downto 0));
  end component;
  for ifid0,ifid1,ifid2 :IF_ID_REG use entity IF_ID_REG(logic);

  label id0, id1, id2;
  component idstage
    port(npc,ir,wbdata: in bit_vector(31 downto 0);
       wbaddr: in bit_vector(4 downto 0);
       writen,idclock,idreset,branchctrl: in bit;
       opcodeout: out bit_vector(5 downto 0);
       branchpc,idexa,idexb,ideximm: out bit_vector(31 downto 0);
       wbaddrpass0,wbaddrpass1: out bit_vector(4 downto 0);
       controlpc: out bit;
       s_enable_out: out bit;			--to switch.enable / 1:enable 0:not enable
       dest: out bit_vector(1 downto 0));        --to switch.dest / which dlx to send(00,01,10)

  end component;
  for id0, id1, id2:idstage use entity idstage(iddata);
	
	label switch1;
	component switch port(
        data_in1,data_in2,data_in3 : in bit_vector(31 downto 0);
        enable1,enable2,enable3 : in bit;
        dest1,dest2,dest3: in bit_vector(1 downto 0);
        in_reg1,in_reg2,in_reg3: in bit_vector(4 downto 0);
        data_out1,data_out2,data_out3 : out bit_vector(31 downto 0);
        out_enable1, out_enable2, out_enable3 : out bit;
        out_reg1, out_reg2, out_reg3: out bit_vector(4 downto 0));
end component;
	for switch1:switch use entity switch(logic);

   
  label idex0, idex1, idex2;
  component ID_EX_REG 
     port(data1_in, data2_in, sign_in: in bit_vector(31 downto 0);
       instr1_in, instr2_in,forwdesin0,forwdesin1: in bit_vector(4 downto 0);
       funcin: in bit_vector(3 downto 0);
       pclock, preset: in bit; 
       opcodein: in bit_vector(5 downto 0);
       data1_out, data2_out, sign_out: out bit_vector(31 downto 0);
       instr1_out, instr2_out,forwdesout0,forwdesout1: out bit_vector(4 downto 0);
       opcodeout: out bit_vector(5 downto 0);
       funcout: out bit_vector(3 downto 0));     
  end component;
  for idex0, idex1, idex2:ID_EX_REG use entity ID_EX_REG(logic);
   
  label ex0, ex1, ex2;
  component exstage 
    port(a, b0,fralu,frmem : in bit_vector (31 downto 0); --alu inputs
	func : in bit_vector (3 downto 0);   --function code, see alu_32
	s1,s2 : in bit;            --control : b0 ,Imm,fralu or frmem
        s3,s4 : in bit;       --control : a, fralu or frmem
	mux_s : in bit;        --control : instr1_in or instr2_in
	Imm : in bit_vector (31 downto 0);
	instr1_in : in bit_vector(4 downto 0);
	instr2_in : in bit_vector(4 downto 0);
	sum : out bit_vector (31 downto 0);        -- alu output
	b_out : out bit_vector (31 downto 0);      -- output to next stage
	CarryOut : out bit;                       -- overflow
 	instr_out : out bit_vector(4 downto 0));     -- output to next stage    
  end component;
  for ex0, ex1, ex2:exstage use entity exstage(logic);

  label exmem0, exmem1, exmem2;
  component EX_MEM_REG
    port(alures_in, data_in: in bit_vector(31 downto 0);
       instr_in,forwdesin0,forwdesin1: in bit_vector(4 downto 0);
       pclock, preset: in bit;
       opcodein: in bit_vector(5 downto 0);
       alures_out, data_out: out bit_vector(31 downto 0);
       instr_out,forwdesout0,forwdesout1: out bit_vector(4 downto 0); 
       opcodeout: out bit_vector(5 downto 0));
  end component;
  for exmem0, exmem1, exmem2:EX_MEM_REG use entity EX_MEM_REG(logic);

  label mem0, mem1, mem2;
  component memstage
    port( alu_in,data_in,frexe,frmem: in bit_vector(31 downto 0);
	write_en,smem1,smem2 : in bit;
       reg_addr_in: in bit_vector(4 downto 0);
       pclock : in bit;
       data_out, alu_out: out bit_vector(31 downto 0);
       reg_addr_out: out bit_vector(4 downto 0));
  end component;
  for mem0, mem1, mem2:memstage use entity memstage(logic);

  label memwb0, memwb1, memwb2;
  component MEM_WB_REG
     port(data_in,alures_in: in bit_vector(31 downto 0);
       instr_in: in bit_vector(4 downto 0);
       pclock, preset: in bit;
       s_enable_out: in bit;   --'send' enable
       data_out,alures_out: out bit_vector(31 downto 0);
       instr_out: out bit_vector(4 downto 0);
       s_reg_out : out bit_vector(4 downto 0)); --'send' register address
  end component;
  for memwb0, memwb1, memwb2:MEM_WB_REG use entity MEM_WB_REG(logic);

  --label wb0;
  --component WB_STG
    --port(data1_in, data2_in: in bit_vector(31 downto 0);
    --     instr_in: in bit_vector(4 downto 0);
    --     ps: in bit;
    --     data_out: out bit_vector(31 downto 0);
    --     instr_out: out bit_vector(4 downto 0));
  --end component;
  --for wb0:WB_STG use entity WB_STG(wbstg);

  label ctrl0, ctrl1, ctrl2;
  component control_unit
    port(IR : in bit_vector(5 downto 0);
	 lclock,stall: in bit;
	 if_id_reset : out bit;
	 c : out bit_vector(7 downto 0));
  end component; 
  for ctrl0, ctrl1, ctrl2:control_unit use entity control_unit(logic);

  label m0, m1, m2, m30, m31, m32;
  component mux32_4_1
    port(a,b,c,d : in bit_vector(31 downto 0);
	s1,s2 : in bit;
	q :   out bit_vector(31 downto 0));
  end component;
  for m0, m1, m2, m30, m31, m32:mux32_4_1 use entity mux32_4_1(logic);

  label m50, m51, m52;
  component mux4_2_1
     port (a,b : in bit_vector(4 downto 0);
        s : in bit;
        q : out bit_vector (4 downto 0)); 
  end component;  
  for  m50, m51, m52 : mux4_2_1 use entity mux4_2_1(logic);

  label hzdec0, hzdec1, hzdec2;
  component hd_detection
    port (if_id_src1 : in bit_vector(4 downto 0);
	      if_id_src2 : in bit_vector(4 downto 0);
	      if_id_opcode : in bit_vector(5 downto 0);
	      id_ex_des  : in bit_vector(4 downto 0);
	      id_ex_opcode : in bit_vector(5 downto 0);	
	      stall    : out bit);
  end component;
  for hzdec0, hzdec1, hzdec2:hd_detection use entity hd_detection(logic);

  label forw0, forw1, forw2;
  component forwarding
    port (    fclock: in bit;
	      if_id_src1 : in bit_vector(4 downto 0);
	      if_id_src2 : in bit_vector(4 downto 0);
	      if_id_opcode : in bit_vector(5 downto 0);
	      id_ex_des  : in bit_vector(4 downto 0);
	      id_ex_opcode : in bit_vector(5 downto 0);
	      ex_mem_des : in bit_vector(4 downto 0);
	      ex_mem_opcode : in bit_vector(5 downto 0);
	      stall : in bit;
	      controls1_exe : out bit_vector(1 downto 0);
	      controls2_exe : out bit_vector(1 downto 0);
	      controls1_mem : out bit_vector(1 downto 0));
  end component;
  for forw0, forw1, forw2:forwarding use entity forwarding(forwarding_logic);

--signal for dlx0
  signal npc0,ir0: bit_vector(31 downto 0); 
  signal opcode00,opcode01,opcode02 : bit_vector(5 downto 0);
  signal branchpc0 : bit_vector(31 downto 0);
  signal instr_out0,pcaddr_out0: bit_vector(31 downto 0);
  signal idexa0,idexb0,ideximm0: bit_vector(31 downto 0);
  signal wbaddrpass00,wbaddrpass01: bit_vector(4 downto 0);
  --signal writeen,
  signal controlpc0: bit;
  --signal rfclock,rfreset: bit;
  signal data1_out0,data2_out0,sign_out0: bit_vector(31 downto 0);
  signal instr1_out0,instr2_out0: bit_vector(4 downto 0);
  --signal func: bit_vector(3 downto 0);
  --signal s,mux_s,
  signal CarryOut0: bit;
  signal sum0,b_out0: bit_vector(31 downto 0);
  signal aludata0,data0,rdata0,alures0: bit_vector(31 downto 0);
  signal data_out0,alures_out0: bit_vector(31 downto 0);
  signal instr3_out0: bit_vector(4 downto 0);
  signal instr4_out0,instr5_out0: bit_vector(4 downto 0);
  signal functemp0: bit_vector(3 downto 0);
  signal c0 : bit_vector(7 downto 0);
  signal realwben0 : bit ;
  signal forwdespass00,forwdespass01,forwdespass02,forwdespass03:  bit_vector(4 downto 0);
  signal tmpalu0,tmpmem0,tempmem0: bit_vector(31 downto 0);
  signal stall0: bit;
  signal adderen0 : bit;
  signal wrbackdata0: bit_vector (31 downto 0);
  signal wraddress0: bit_vector(4 downto 0);
  signal if_id_reset0, tmp_reset0: bit;
  signal ctrls1_ex0,ctrls2_ex0,ctrls1_mem0 : bit_vector(1 downto 0);
  signal alusrc01,alusrc02 : bit;
  signal forkcnt0 : bit;   --enable fork
  signal s_data_out0: bit_vector(31 downto 0);
  signal s_enable_out0: bit;
  signal dest0: bit_vector(1 downto 0);  
  signal s_reg_out0:  bit_vector(4 downto 0); 
  signal s_data_in0:  bit_vector(31 downto 0);   --from switch.data_out , only to dlx0
  signal s_enable_in0:  bit;                     --from switch.enable , only to dlx0
  signal s_reg_in0:  bit_vector(4 downto 0);    --from switch.out_reg , only to dlx0

--signal for dlx1
  signal npc1,ir1: bit_vector(31 downto 0);
  signal opcode10,opcode11,opcode12 : bit_vector(5 downto 0);
  signal branchpc1 : bit_vector(31 downto 0);
  signal instr_out1,pcaddr_out1: bit_vector(31 downto 0);
  signal idexa1,idexb1,ideximm1: bit_vector(31 downto 0);
  signal wbaddrpass10,wbaddrpass11: bit_vector(4 downto 0);
  --signal writeen, 
  signal controlpc1: bit;
  --signal rfclock,rfreset: bit;
  signal data1_out1,data2_out1,sign_out1: bit_vector(31 downto 0);
  signal instr1_out1,instr2_out1: bit_vector(4 downto 0);
  --signal func: bit_vector(3 downto 0);
  --signal s,mux_s,
  signal CarryOut1: bit;
  signal sum1,b_out1: bit_vector(31 downto 0);
  signal aludata1,data1,rdata1,alures1: bit_vector(31 downto 0);
  signal data_out1,alures_out1: bit_vector(31 downto 0);
  signal instr3_out1: bit_vector(4 downto 0);
  signal instr4_out1,instr5_out1: bit_vector(4 downto 0);
  signal functemp1: bit_vector(3 downto 0);
  signal c1 : bit_vector(7 downto 0);
  signal realwben1 : bit ;
  signal forwdespass10,forwdespass11,forwdespass12,forwdespass13:  bit_vector(4 downto 0);
  signal tmpalu1,tmpmem1,tempmem1: bit_vector(31 downto 0);
  signal stall1: bit;
  signal adderen1 : bit;
  signal wrbackdata1: bit_vector (31 downto 0);
  signal wraddress1: bit_vector(4 downto 0);
  signal if_id_reset1, tmp_reset1: bit;
  signal ctrls1_ex1,ctrls2_ex1,ctrls1_mem1 : bit_vector(1 downto 0);
  signal alusrc11,alusrc12 : bit;
  signal forkcnt1 : bit;  --enable fork
  signal sendcnt1 : bit;  --enable send
  signal s_data_out1:  bit_vector(31 downto 0); --to switch.data_in / data in register
  signal s_enable_out1:  bit;                   --to switch.enable / 1:enable 0:not enable
  signal dest1: bit_vector(1 downto 0);        --to switch.dest / which dlx to send(00,01,10)
  signal s_reg_out1: bit_vector(4 downto 0);   --to switch.in_reg / register number to send out
  signal s_data_in1:  bit_vector(31 downto 0);   --from switch.data_out , only to dlx0
  signal s_enable_in1:  bit;                     --from switch.enable , only to dlx0
  signal s_reg_in1:  bit_vector(4 downto 0);    --from switch.out_reg , only to dlx0



--signal for dlx2
  signal npc2,ir2: bit_vector(31 downto 0);
  signal opcode20,opcode21,opcode22 : bit_vector(5 downto 0);
  signal branchpc2 : bit_vector(31 downto 0);
  signal instr_out2,pcaddr_out2: bit_vector(31 downto 0);
  signal idexa2,idexb2,ideximm2: bit_vector(31 downto 0);
  signal wbaddrpass20,wbaddrpass21: bit_vector(4 downto 0);
  --signal writeen, 
  signal controlpc2: bit;
  --signal rfclock,rfreset: bit;
  signal data1_out2,data2_out2,sign_out2: bit_vector(31 downto 0);
  signal instr1_out2,instr2_out2: bit_vector(4 downto 0);
  --signal func: bit_vector(3 downto 0);
  --signal s,mux_s,
  signal CarryOut2: bit;
  signal sum2,b_out2: bit_vector(31 downto 0);
  signal aludata2,data2,rdata2,alures2: bit_vector(31 downto 0);
  signal data_out2,alures_out2: bit_vector(31 downto 0);
  signal instr3_out2: bit_vector(4 downto 0);
  signal instr4_out2,instr5_out2: bit_vector(4 downto 0);
  signal functemp2: bit_vector(3 downto 0);
  signal c2 : bit_vector(7 downto 0);
  signal realwben2 : bit ;
  signal forwdespass20,forwdespass21,forwdespass22,forwdespass23:  bit_vector(4 downto 0);
  signal tmpalu2,tmpmem2,tempmem2: bit_vector(31 downto 0);
  signal stall2: bit;
  signal adderen2 : bit;
  signal wrbackdata2: bit_vector (31 downto 0);
  signal wraddress2: bit_vector(4 downto 0);
  signal if_id_reset2, tmp_reset2: bit;
  signal ctrls1_ex2,ctrls2_ex2,ctrls1_mem2 : bit_vector(1 downto 0);
  signal alusrc21,alusrc22 : bit;
  signal forkcnt2 : bit;    -- 1: enable fork
  signal sendcnt2 : bit;    -- 1: enable send
  signal s_data_out2:  bit_vector(31 downto 0); --to switch.data_in / data in register
  signal s_enable_out2:  bit;            --to switch.enable / 1:enable 0:not enable
  signal dest2: bit_vector(1 downto 0);  --to switch.dest / which dlx to send(00,01,10)
  signal s_reg_out2: bit_vector(4 downto 0);   --to switch.in_reg / register number to send out
  signal s_data_in2: bit_vector(31 downto 0);   --from switch.data_out , only to dlx0
  signal s_enable_in2: bit;                     --from switch.enable , only to dlx0
  signal s_reg_in2: bit_vector(4 downto 0);    --from switch.out_reg , only to dlx0


begin 

--dlx0

  realwben0 <= (c0(3) or wbenable) after 100ps;
  
  if_id_reset0<=((tmp_reset0 and instr_out0(31)) or dlxreset) after 1ns;
  adderen0 <= not(stall0) after 1ps;
  alusrc01 <= c0(6) or ctrls2_ex0(0) after 1ps;   
  alusrc02 <= c0(6) or ctrls2_ex0(1) after 1ps;

  forkcnt0 <= instr_out0(31) and (instr_out0(30)) and instr_out0(29) and (instr_out0(28)) and not(instr_out0(27)) and not(instr_out0(26)) and not(instr_out0(22)) and not(instr_out0(21)) after 1ps;
   --instr_out(31 downto 26) = '111100' | instr_out(25 downto 21)= '00000') fork #0

  branchpc0(31 downto 0) <= "00000000000000000000000000001111" when (forkcnt0) else "00000000000000000000000000000000"  after 100ps ; -- fork #0, #15
  controlpc0 <= "0" when (forkcnt0) else "1" after 100ps;  -- '0' select branchpc0, see ifstage

  if0: ifstage port map(branchpc0,controlpc0,adderen0,dlxclock,pcreset,instrmemaddr,instrmemdata,instrmemwren,stall0,npc0,ir0);
  ifid0: IF_ID_REG port map(ir0,npc0,dlxclock,if_id_reset0,stall0,instr_out0,pcaddr_out0);
  wrbackdata0 <= wbdata or result after 10ps;
  wraddress0 <= wbaddr or addres after 10ps;

  -- 'send', write back data from itself or from dlx1, dlx2  
  m30: mux32_4_1 port map (wrbackdata0, s_data_in0, x"00000000", x"00000000", "0", s_enable_in0, wrbackdata0); -- 00: wrbackdata0, 01:s_data_in
  m50: mux4_2_1 port map (wraddress0, s_reg_in0, s_enable_in0, wraddress0); --0:wraddress0, 1:s_reg_in

  id0: idstage port map(pcaddr_out0,instr_out0,wrbackdata0,wraddress0,realwben0,dlxclock,dlxreset,c0(0),opcode00,
			branchpc0,idexa0,idexb0,ideximm0,wbaddrpass00,wbaddrpass01,controlpc0,s_enable_out0, dest0);

  idex0: ID_EX_REG port map(idexa0,idexb0,ideximm0,wbaddrpass00,wbaddrpass01,instr_out0(20 downto 16),instr_out0(15 downto 11),instr_out0(3 downto
0),dlxclock,dlxreset,opcode00,data1_out0,data2_out0,sign_out0,instr1_out0,instr2_out0,forwdespass00,forwdespass01,opcode01,functemp0);
  ex0: exstage port map(data1_out0,data2_out0,tmpalu0,tmpmem0,functemp0,ctrls1_ex0(0),ctrls1_ex0(1),alusrc01,alusrc02,c0(7),sign_out0,instr1_out0,instr2_out0,sum0,b_out0,CarryOut0,instr3_out0);
  tmpalu0 <= sum0 after 100ps;
  exmem0: EX_MEM_REG port map(sum0,b_out0,instr3_out0,forwdespass00,forwdespass01,dlxclock,dlxreset,opcode01,alures0,data0,instr4_out0,forwdespass02,forwdespass03,opcode02);
  mem0: memstage port map(aludata0,data0,tmpalu0,tempmem0,c0(2),ctrls1_mem0(0),ctrls1_mem0(1),instr4_out0,dlxclock,rdata0,alures0,instr5_out0);
  tmpmem0 <= rdata0 after 100ps;
  tempmem0 <= rdata0 after 100ps;
  memwb0: MEM_WB_REG port map(rdata0,alures0,instr4_out0,dlxclock,dlxreset,s_enable_out0, data_out0,alures_out0,addres,s_reg_out0); --'send' s_reg_out

  m0: mux32_4_1 port map(data_out0,alures_out0,x"00000000",x"00000000",c0(5),c0(4),result);
  s_data_out0 <= result when(s_enable_out0) else "00000000000000000000000000000000" after 100ps;        --'send' s_data_out
  ctrl0: control_unit port map(instr_out0(31 downto 26),dlxclock,stall0,tmp_reset0,c0);
--  hzdec0: hd_detection port map(instr_out0(25 downto 21),instr_out0(20 downto 16),instr_out0(31 downto 26),forwdespass00,opcode01,stall0);

 --  forw0: forwarding port map(dlxclock,instr_out0(25 downto 21),instr_out0(20 downto 16),instr_out0(31 downto26),forwdespass00,opcode01,forwdespass02,opcode02,stall0,ctrls1_ex0,ctrls2_ex0,ctrls1_mem0);
  

--dlx1

  realwben1 <= (c0(3) or wbenable) after 100ps;
  if_id_reset1<=((tmp_reset1 and instr_out1(31)) or dlxreset ) after 1ns;
  adderen1 <= not(stall1) after 1ps;
  alusrc11 <= c1(6) or ctrls2_ex1(0) after 1ps;   
  alusrc12 <= c1(6) or ctrls2_ex1(1) after 1ps;
  
  -- implement 'fork'
  forkcnt1 <= instr_out0(31) and instr_out0(30) and instr_out0(29) and instr_out0(28) and not(instr_out0(27)) and not(instr_out0(26))
     and not(instr_out0(22)) and (instr_out0(21)) after 1ps; 
     --  instr_out(31 downto 26) = '111100' | instr_out(25 downto 21)= '00001') fork #1
  branchpc1(31 downto 0) <= "00000000000000000000000000000111" when (forkcnt1) else "00000000000000000000000000000000" after 100ps ; -- fork #1, #7
  controlpc1 <= '0' when (forkcnt1) else '1' after 100ps;  -- '0' select branchpc1, see ifstage

  if1: ifstage port map(branchpc1,controlpc1,adderen1,dlxclock,pcreset,instrmemaddr,instrmemdata,instrmemwren,stall1,npc1,ir1);
  ifid1: IF_ID_REG port map(ir1,npc1,dlxclock,if_id_reset1,stall1,instr_out1,pcaddr_out1);
  wrbackdata1 <= wbdata or result after 10ps;
  wraddress1 <= wbaddr or addres after 10ps;

  -- 'send', write back data from itself or from dlx0, dlx2
  m31: mux32_4_1 port map (wrbackdata1, s_data_in1, x"00000000", x"00000000", "0", s_enable_in1, wrbackdata1); -- 00: wrbackdata0, 01:s_data_in
  m51: mux4_2_1 port map (wraddress1, s_reg_in1, s_enable_in1, wraddress1); --0:wraddress0, 1:s_reg_in


  id1: idstage port map(pcaddr_out1,instr_out1,wrbackdata1,wraddress1,realwben1,dlxclock,dlxreset,c1(0),opcode10,
			branchpc1,idexa1,idexb1,ideximm1,wbaddrpass10,wbaddrpass11,controlpc1, s_enable_out1, dest1); --id stage decide it will send or not
  idex1: ID_EX_REG port map(idexa1,idexb1,ideximm1,wbaddrpass10,wbaddrpass11,instr_out1(20 downto 16),instr_out1(15 downto 11),instr_out1(3 downto 0),dlxclock,dlxreset,opcode11,data1_out1,data2_out1,sign_out1,instr1_out1,instr2_out1,forwdespass10,forwdespass11,opcode11,functemp1);
  ex1: exstage port map(data1_out1,data2_out1,tmpalu1,tmpmem1,functemp1,ctrls1_ex1(0),ctrls1_ex1(1),alusrc11,alusrc12,c1(7),sign_out1,instr1_out1,instr2_out1,sum1,b_out1,CarryOut1,instr3_out1);
  tmpalu1 <= sum1 after 100ps;
  exmem1: EX_MEM_REG port map(sum1,b_out1,instr3_out1,forwdespass10,forwdespass11,dlxclock,dlxreset,opcode11,alures1,data1,instr4_out1,forwdespass12,forwdespass13,opcode12);
  mem1: memstage port map(aludata1,data1,tmpalu1,tempmem1,c1(2),ctrls1_mem1(0),ctrls1_mem1(1),instr4_out1,dlxclock,rdata1,alures1,instr5_out1);
  tmpmem1 <= rdata1 after 100ps;
  tempmem1 <= rdata1 after 100ps;
  memwb1: MEM_WB_REG port map(rdata1,alures1,instr4_out1,dlxclock,dlxreset, s_enable_out2, data_out1,alures_out1,addres, s_reg_out1);  --'send' s_reg_out
  m1: mux32_4_1 port map(data_out1,alures_out1,x"00000000",x"00000000",c1(5),c1(4),result);
  s_data_out1 <= result when(s_enable_out1) else "00000000000000000000000000000000" after 100ps;  	--'send' s_data_out 
  ctrl1: control_unit port map(instr_out1(31 downto 26),dlxclock,stall1,tmp_reset1,c1);
  hzdec1: hd_detection port map(instr_out1(25 downto 21),instr_out1(20 downto 16),instr_out1(31 downto 26),forwdespass10,opcode11,stall1);
  forw1: forwarding port map(dlxclock,instr_out1(25 downto 21),instr_out1(20 downto 16),instr_out1(31 downto 26),forwdespass10,opcode11,forwdespass12,opcode12,stall1,ctrls1_ex1,ctrls2_ex1,ctrls1_mem1);



--dlx2

  realwben2 <= (c2(3) or wbenable) after 100ps;
  if_id_reset2 <=((tmp_reset2 and instr_out2(31)) or dlxreset) after 1ns;
  adderen2 <= not(stall2) after 1ps;
  alusrc21 <= c2(6) or ctrls2_ex2(0) after 1ps;   
  alusrc22 <= c2(6) or ctrls2_ex2(1) after 1ps;

   forkcnt2 <= instr_out2(31) and instr_out2(30) and instr_out2(29) and instr_out2(28) and not(instr_out2(27)) and not(instr_out2(26)) 
      and instr_out2(22) and not(instr_out2(21)) after 1ps; 
      --  instr_out(31 downto 26) = '111100' | instr_out(25 downto 21)= '00010') fork #2

  branchpc2(31 downto 0) <= "000000000000000000000000000001011" when (forkcnt2) else "000000000000000000000000000000000" after 100ps ; -- fork #2, #11
  controlpc2 <= '0' when (forkcnt2) else '1' after 100ps;  -- '0' select branchpc2 see ifstage

  if2: ifstage port map(branchpc2,controlpc2,adderen2,dlxclock,pcreset,instrmemaddr,instrmemdata,instrmemwren,stall2,npc2,ir2);
  ifid2: IF_ID_REG port map(ir2,npc2,dlxclock,if_id_reset2,stall2,instr_out2,pcaddr_out2);
  wrbackdata2 <= wbdata or result after 10ps;
  wraddress2 <= wbaddr or addres after 10ps;

  -- 'send', write back data from itself or from dlx0, dlx1
  m32: mux32_4_1 port map (wrbackdata2, s_data_in2, x"00000000", x"00000000", "0", s_enable_in2, wrbackdata2); -- 00: wrbackdata0, 01:s_data_in
  m52: mux4_2_1 port map (wraddress2, s_reg_in2, s_enable_in2, wraddress2); --0:wraddress0, 1:s_reg_in

  id2: idstage port map(pcaddr_out2,instr_out2,wrbackdata2,wraddress2,realwben2,dlxclock,dlxreset,c2(0),opcode20,
			branchpc2,idexa2,idexb2,ideximm2,wbaddrpass20,wbaddrpass21,controlpc2, s_enable_out2, dest2); --id stage decide it will send or not
  idex2: ID_EX_REG port map(idexa2,idexb2,ideximm2,wbaddrpass20,wbaddrpass21,instr_out2(20 downto 16),instr_out2(15 downto 11),instr_out2(3 downto 0),dlxclock,dlxreset,opcode20,data1_out2,data2_out2,sign_out2,instr1_out2,instr2_out2,forwdespass20,forwdespass21,opcode21,functemp2);
  ex2: exstage port map(data1_out2,data2_out2,tmpalu2,tmpmem2,functemp2,ctrls1_ex2(0),ctrls1_ex2(1),alusrc21,alusrc22,c2(7),sign_out2,instr1_out2,instr2_out2,sum2,b_out2,CarryOut2,instr3_out2);
  tmpalu2 <= sum2 after 100ps;
  exmem2: EX_MEM_REG port map(sum2,b_out2,instr3_out2,forwdespass20,forwdespass21,dlxclock,dlxreset,opcode21,alures2,data2,instr4_out2,forwdespass22,forwdespass23,opcode22);
  mem2: memstage port map(aludata2,data2,tmpalu2,tempmem2,c2(2),ctrls1_mem2(0),ctrls1_mem2(1),instr4_out2,dlxclock,rdata2,alures2,instr5_out2);
  tmpmem2 <= rdata2 after 100ps;
  tempmem2 <= rdata2 after 100ps;
  memwb2: MEM_WB_REG port map(rdata2,alures2,instr4_out2,dlxclock,dlxreset, s_enable_out2, data_out2,alures_out2,addres, s_reg_out2); --'send' s_reg_out
  m2: mux32_4_1 port map(data_out2,alures_out2,x"00000000",x"00000000",c2(5),c2(4),result);
  s_data_out2 <= result when(s_enable_out2) else "00000000000000000000000000000000"  after 100ps;  	--'send' s_data_out 
  ctrl2: control_unit port map(instr_out2(31 downto 26),dlxclock,stall2,tmp_reset2,c2);
  hzdec2: hd_detection port map(instr_out2(25 downto 21),instr_out2(20 downto 16),instr_out2(31 downto 26),forwdespass20,opcode21,stall2);
  forw2: forwarding port map(dlxclock,instr_out2(25 downto 21),instr_out2(20 downto 16),instr_out2(31 downto 26),forwdespass20,opcode21,forwdespass22,opcode22,stall2,ctrls1_ex2,ctrls2_ex2,ctrls1_mem2);

--switch 
switch1: switch port map(s_data_out0, s_data_out1, s_data_out2,s_enable_out0,s_enable_out1, s_enable_out2,
dest0, dest1, dest2, s_reg_out0, s_reg_out1, s_reg_out2, s_data_in0,
s_data_in1,s_data_in2,s_enable_in0, s_enable_in1, s_enable_in2,s_reg_in0, s_reg_in1, s_reg_in2);


end dlx_str;
