-- 32-bit ALU 
-- Functions : addition, substration, AND, OR

-- Control table

-- op(1)  op(0)  CarryIn  bi       Function
--   0      0       x     x          AND
--   0      1       0     0          ADD
--   0      1       1     1          SUB
--   1      0       x     x          OR

-- need 5ns to finisht execution

entity mux2_1 is port(
        a,b,s: in bit;
        q,q_bar:   out bit);
end mux2_1;

architecture logic of mux2_1 is

        begin
        q <=((a and (not(s)))  or (b and s)) ;
        q_bar <=((b and s) nor (a and (not(s)))) ;
end logic;

entity mux3_1 is port(
        a,b,c,s1,s2: in bit;
        q,q_bar:    out bit);
end mux3_1;

architecture logic of mux3_1 is

        signal t1,t2,t3: bit;

        begin
        t1 <= (a and (not(s1)) and (not(s2)));
        t2 <= (b and (not(s1)) and s2 );
        t3 <= (c and s1 and (not(s2)));

        q <=(t1 or t2 or t3 );
        q_bar <=(not (t1 or t2 or t3));
        end logic;




entity alu_1 is port(
	CarryIn, a, b,bi: in bit;
	op:in bit_vector(1 downto 0);
	sum, CarryOut: out bit);
end alu_1;

architecture logic of alu_1 is 
	signal t0,t0_bar,t1, sum_bar, t2,t3,t4, t5:bit;
	
	label mux1;
	component mux2_1
		port (a,b,s: in bit;q,q_bar:out bit);
	end component;
	for mux1 : mux2_1 use entity mux2_1(logic);
	
	label mux2;
	component mux3_1
		port(a,b,c,s1,s2: in bit;q,q_bar:out bit);
	end component;
	for mux2 : mux3_1 use entity mux3_1(logic);

	label adder;
	component fulladder
		port (CarryIn, a, b: in bit;sum,CarryOut:out bit);
	end component;
	for adder : fulladder use entity fulladder(logic);
	
	begin

	t4<= not(b) ;
	mux1: mux2_1 port map (b,t4,bi,t0,t0_bar);

	t1 <= (a and t0) ;
	t2 <= (a or t0) ;
	adder: fulladder port map (CarryIn, a, t0,t3, t5);

	CarryOut<=(t5 and op(0)) ;
	mux2: mux3_1 port map (t1,t2,t3,op(0),op(1),sum,sum_bar);
	
	end logic;

entity alu_8 is port(
	a,b: in bit_vector(7 downto 0);
	op : in bit_vector(1 downto 0);
	CarryIn,bi :in bit;
	sum: out bit_vector(7 downto 0);
	CarryOut : out bit);
end alu_8;

architecture logic of alu_8 is 
	signal g0, g1, g2, g3, g4, g5, g6, g7 : bit;
	signal p0, p1, p2, p3, p4, p5, p6, p7 : bit;
	signal c1, c2, c3, c4, c5, c6, c7: bit;
	signal t0, t1, t2, t3, t4, t5, t6, t7 : bit;

	label l0, l1, l2, l3, l4, l5, l6, l7;
	
	component alu_1	port (CarryIn, a, b,bi: in bit;
				op:in bit_vector(1 downto 0);
				sum, CarryOut: out bit);
	end component;
	for l0,l1,l2,l3,l4,l5,l6,l7: alu_1 use entity alu_1(logic);
	
	begin

	g0 <= (a(0) and ((b(0) and (not(bi))) or (bi and (not(b(0)))))) ;
	g1 <= (a(1) and ((b(1) and (not(bi))) or (bi and (not(b(1)))))) ;
	g2 <= (a(2) and ((b(2) and (not(bi))) or (bi and (not(b(2)))))) ;
	g3 <= (a(3) and ((b(3) and (not(bi))) or (bi and (not(b(3)))))) ;
	g4 <= (a(4) and ((b(4) and (not(bi))) or (bi and (not(b(4)))))) ;
	g5 <= (a(5) and ((b(5) and (not(bi))) or (bi and (not(b(5)))))) ;
	g6 <= (a(6) and ((b(6) and (not(bi))) or (bi and (not(b(6)))))) ;
	g7 <= (a(7) and ((b(7) and (not(bi))) or (bi and (not(b(7)))))) ;
	
	p0 <= (a(0) or ((b(0) and (not(bi))) or (bi and (not(b(0)))))) ;
	p1 <= (a(1) or ((b(1) and (not(bi))) or (bi and (not(b(1)))))) ;
	p2 <= (a(2) or ((b(2) and (not(bi))) or (bi and (not(b(2)))))) ;
	p3 <= (a(3) or ((b(3) and (not(bi))) or (bi and (not(b(3)))))) ;
	p4 <= (a(4) or ((b(4) and (not(bi))) or (bi and (not(b(4)))))) ;
	p5 <= (a(5) or ((b(5) and (not(bi))) or (bi and (not(b(5)))))) ;
	p6 <= (a(6) or ((b(6) and (not(bi))) or (bi and (not(b(6)))))) ;
	p7 <= (a(7) or ((b(7) and (not(bi))) or (bi and (not(b(7)))))) ;

	c1 <= (g0 or (p0 and CarryIn)) ;
	c2 <= (g1 or (p1 and g0) or (p1 and p0 and CarryIn)) ;
	c3 <= (g2 or (p2 and g1) or (p2 and p1 and g0) or (p2 and p1 and p0
		and CarryIn )) ;
	c4 <= (g3 or (p3 and g2) or (p3 and p2 and g1) or ( p3 and p2 and p1
		and g0) or ( p3 and p2 and p1 and p0 and CarryIn)) ;
	c5 <= (g4 or (p4 and g3) or (p4 and p3 and g2) or (p4 and p3 and p2
		and g1) or (p4 and p3 and p2 and p1 and g0) or (p4 and p3 and 
		p2 and p1 and p0 and CarryIn)) ;
	c6 <= (g5 or (p5 and g4) or (p5 and p4 and g3) or (p5 and p4 and p3 
		and g2) or (p5 and p4 and p3 and p2 and g1) or (p5 and p4 and 
		p3 and p2 and p1 and g0) or ( p5 and p4 and p3 and p2 and p1 
		and p0 and CarryIn)) ;
	c7 <= (g6 or (p6 and g5) or (p6 and p5 and g4) or (p6 and p5 
		and  p4 and g3) or (p6 and p5 and p4 and p3 and g2) or (p6 
		and p5 and p4 and p3 and p2 and g1) or (p6 and p5 and p4 and 
		p3 and p2 and p1 and g0) or (p6 and p5 and p4 and p3 and p2 
		and p1 and p0 and CarryIn)) ;
	CarryOut <= (g7 or (p7 and g6) or (p7 and p6 and g5) or (p7 and p6 
		and p5 and g4) or (p7 and p6 and p5 and p4 and g3) or (p7 
		and p6 and p5 and p4 and p3 and g2) or (p7 and p6 and p5 and 
		p4 and p3 and p2 and g1) or (p7 and p6 and p5 and p4 and p3 
		and p2 and p1 and g0) or (p7 and p6 and p5 and p4 and p3 and 
		p2 and p1 and p0 and CarryIn));

	l0: alu_1 port map (CarryIn, a(0), b(0),bi,op,sum(0),t0);
	l1: alu_1 port map (c1, a(1), b(1),bi,op,sum(1),t1);
	l2: alu_1 port map (c2, a(2), b(2),bi,op,sum(2),t2);
	l3: alu_1 port map (c3, a(3), b(3),bi,op,sum(3),t3);
	l4: alu_1 port map (c4, a(4), b(4),bi,op,sum(4),t4);
	l5: alu_1 port map (c5, a(5), b(5),bi,op,sum(5),t5);
	l6: alu_1 port map (c6, a(6), b(6),bi,op,sum(6),t6);
	l7: alu_1 port map (c7, a(7), b(7),bi,op,sum(7),t7);
	end logic;

entity alu_32 is port(
	a, b : in bit_vector (31 downto 0);
	CarryIn,bi : in bit;
	op : in bit_vector (1 downto 0);
	sum : out bit_vector (31 downto 0);
	CarryOut : out bit);
end alu_32;

architecture logic of alu_32 is 
	signal p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16:bit;
	signal p17,p18,p19,p20,p21,p22,p23,p24,p25,p26,p27,p28,p29,p30,p31:bit;
	signal g0, g1,g2,g3,g4,g5,g6,g7,g8,g9,g10,g11,g12,g13,g14,g15,g16:bit;
	signal g17,g18,g19,g20,g21,g22,g23,g24,g25,g26,g27,g28,g29,g30,g31:bit;
	signal c0, c1, c2, c3:bit;
	signal t0, t1, t2, t3:bit;
	signal pp0,pp1,pp2,pp3:bit;
	signal gg0, gg1,gg2,gg3:bit;
	label l0,l1,l2,l3;
	component alu_8
		 port (a,b: in bit_vector(7 downto 0);
			op : in bit_vector(1 downto 0);
			CarryIn,bi :in bit;
			sum: out bit_vector(7 downto 0);
			CarryOut : out bit);
	end component;
	for l0,l1,l2, l3: alu_8 use entity alu_8(logic);
	begin
	
	g0 <= (a(0) and ((b(0) and (not(bi))) or (bi and (not(b(0)))))) ;
	g1 <= (a(1) and ((b(1) and (not(bi))) or (bi and (not(b(1)))))) ;
	g2 <= (a(2) and ((b(2) and (not(bi))) or (bi and (not(b(2)))))) ;
	g3 <= (a(3) and ((b(3) and (not(bi))) or (bi and (not(b(3)))))) ;
	g4 <= (a(4) and ((b(4) and (not(bi))) or (bi and (not(b(4)))))) ;
	g5 <= (a(5) and ((b(5) and (not(bi))) or (bi and (not(b(5)))))) ;
	g6 <= (a(6) and ((b(6) and (not(bi))) or (bi and (not(b(6)))))) ;
	g7 <= (a(7) and ((b(7) and (not(bi))) or (bi and (not(b(7)))))) ;
	
	g31 <= (a(31) and ((b(31) and (not(bi))) or (bi and (not(b(31)))))) ;
	g8 <= (a(8) and ((b(8) and (not(bi))) or (bi and (not(b(8)))))) ;
	g9 <= (a(9) and ((b(9) and (not(bi))) or (bi and (not(b(9)))))) ;
	g10 <= (a(10) and ((b(10) and (not(bi))) or (bi and (not(b(10)))))) ;
	g11 <= (a(11) and ((b(11) and (not(bi))) or (bi and (not(b(11)))))) ;
	g12 <= (a(12) and ((b(12) and (not(bi))) or (bi and (not(b(12)))))) ;
	g13 <= (a(13) and ((b(13) and (not(bi))) or (bi and (not(b(13)))))) ;
	g14 <= (a(14) and ((b(14) and (not(bi))) or (bi and (not(b(14)))))) ;
	g15 <= (a(15) and ((b(15) and (not(bi))) or (bi and (not(b(15)))))) ;
	g16 <= (a(16) and ((b(16) and (not(bi))) or (bi and (not(b(16)))))) ;
	g17 <= (a(17) and ((b(17) and (not(bi))) or (bi and (not(b(17)))))) ;
	g18 <= (a(18) and ((b(18) and (not(bi))) or (bi and (not(b(18)))))) ;
	g19 <= (a(19) and ((b(19) and (not(bi))) or (bi and (not(b(19)))))) ;
	g20 <= (a(20) and ((b(20) and (not(bi))) or (bi and (not(b(20)))))) ;
	g21 <= (a(21) and ((b(21) and (not(bi))) or (bi and (not(b(21)))))) ;
	g22 <= (a(22) and ((b(22) and (not(bi))) or (bi and (not(b(22)))))) ;
	g23 <= (a(23) and ((b(23) and (not(bi))) or (bi and (not(b(23)))))) ;
	g24 <= (a(24) and ((b(24) and (not(bi))) or (bi and (not(b(24)))))) ;
	g25 <= (a(25) and ((b(25) and (not(bi))) or (bi and (not(b(25)))))) ;
	g26 <= (a(26) and ((b(26) and (not(bi))) or (bi and (not(b(26)))))) ;
	g27 <= (a(27) and ((b(27) and (not(bi))) or (bi and (not(b(27)))))) ;
	g28 <= (a(28) and ((b(28) and (not(bi))) or (bi and (not(b(28)))))) ;
	g29 <= (a(29) and ((b(29) and (not(bi))) or (bi and (not(b(29)))))) ;
	g30 <= (a(30) and ((b(30) and (not(bi))) or (bi and (not(b(30)))))) ;
	




	p0 <= (a(0) or ((b(0) and (not(bi))) or (bi and (not(b(0)))))) ;
	p1 <= (a(1) or ((b(1) and (not(bi))) or (bi and (not(b(1)))))) ;
	p2 <= (a(2) or ((b(2) and (not(bi))) or (bi and (not(b(2)))))) ;
	p3 <= (a(3) or ((b(3) and (not(bi))) or (bi and (not(b(3)))))) ;
	p4 <= (a(4) or ((b(4) and (not(bi))) or (bi and (not(b(4)))))) ;
	p5 <= (a(5) or ((b(5) and (not(bi))) or (bi and (not(b(5)))))) ;
	p6 <= (a(6) or ((b(6) and (not(bi))) or (bi and (not(b(6)))))) ;
	p7 <= (a(7) or ((b(7) and (not(bi))) or (bi and (not(b(7)))))) ;
	
	p31 <= (a(31) or ((b(31) and (not(bi))) or (bi and (not(b(31)))))) ;
	p8 <= (a(8) or ((b(8) and (not(bi))) or (bi and (not(b(8)))))) ;
	p9 <= (a(9) or ((b(9) and (not(bi))) or (bi and (not(b(9)))))) ;
	p10 <= (a(10) or ((b(10) and (not(bi))) or (bi and (not(b(10)))))) ;

	p11 <= (a(11) or ((b(11) and (not(bi))) or (bi and (not(b(11)))))) ;
	p12 <= (a(12) or ((b(12) and (not(bi))) or (bi and (not(b(12)))))) ;
	p13 <= (a(13) or ((b(13) and (not(bi))) or (bi and (not(b(13)))))) ;
	p14 <= (a(14) or ((b(14) and (not(bi))) or (bi and (not(b(14)))))) ;
	p15 <= (a(15) or ((b(15) and (not(bi))) or (bi and (not(b(15)))))) ;
	p16 <= (a(16) or ((b(16) and (not(bi))) or (bi and (not(b(16)))))) ;
	p17 <= (a(17) or ((b(17) and (not(bi))) or (bi and (not(b(17)))))) ;
	p18 <= (a(18) or ((b(18) and (not(bi))) or (bi and (not(b(18)))))) ;
	p19 <= (a(19) or ((b(19) and (not(bi))) or (bi and (not(b(19)))))) ;
	p20 <= (a(20) or ((b(20) and (not(bi))) or (bi and (not(b(20)))))) ;
	p21 <= (a(21) or ((b(21) and (not(bi))) or (bi and (not(b(21)))))) ;
	p22 <= (a(22) or ((b(22) and (not(bi))) or (bi and (not(b(22)))))) ;
	p23 <= (a(23) or ((b(23) and (not(bi))) or (bi and (not(b(23)))))) ;

	p23 <= (a(23) or ((b(23) and (not(bi))) or (bi and (not(b(23)))))) ;
	p24 <= (a(24) or ((b(24) and (not(bi))) or (bi and (not(b(24)))))) ;
	p25 <= (a(25) or ((b(25) and (not(bi))) or (bi and (not(b(25)))))) ;
	p26 <= (a(26) or ((b(26) and (not(bi))) or (bi and (not(b(26)))))) ;
	p27 <= (a(27) or ((b(27) and (not(bi))) or (bi and (not(b(27)))))) ;
	p28 <= (a(28) or ((b(28) and (not(bi))) or (bi and (not(b(28)))))) ;
	p29 <= (a(29) or ((b(29) and (not(bi))) or (bi and (not(b(29)))))) ;
	p30 <= (a(30) or ((b(30) and (not(bi))) or (bi and (not(b(30)))))) ;

	pp0 <= (p7 and p6 and p5 and p4 and p3 and p2 and p1 and p0) ;
	pp1 <= (p15 and p14 and p13 and p12 and p11 and p10 and p9 and p8) ;
	pp2 <= (p23 and p22 and p21 and p20 and p19 and p18 and p17 and p16) ;
	pp3 <= (p31 and p30 and p29 and p28 and p27 and p26 and p25 and p24) ;

	gg0 <= (g7 or (p7 and g6) or (p7 and p6 and g5) or (p7 and p6 and p5 
		and g4) or (p7 and p6 and p5 and p4 and g3) or(p7 and p6 and 
		p5 and p4 and p3 and g2) or (p7 and p6 and p5 and p4 and p3
		and p2 and g1) or (p7 and p6 and p5 and p4 and p3 and p2 and 
		p1 and g0) ) ;
	gg1 <= (g15 or (p15 and g14) or (p15 and p14 and g13) or (p15 and p14 
		and p13 and g12) or (p15 and p14 and p13 and p12 and g11) or 
		(p15 and p14 and p13 and p12 and p11 and g10) or (p15 and p14 
		and p13 and p12 and p11 and p10 and g9) or (p15 and p14 and 
		p13 and p12 and p11 and p10 and p9 and g8)) ;
	gg2 <= (g23 or (p23 and g22) or (p23 and p22 and g21) or (p23 and p22 
		and p21 and g20) or (p23 and p22 and p21 and p20 and g19) or 
		(p23 and p22 and p21 and p20 and p19 and g18) or (p23 and p22 
		and p21 and p20 and p19 and p18 and g17) or (p23 and p22 and 
		p21 and p20 and p19 and p18 and p17 and g16)) ;
	gg3 <= (g31 or (p31 and g30) or (p31 and p30 and g29) or (p31 and p30 
		and p29 and g28) or (p31 and p30 and p29 and p28 and g27) or 
		(p31 and p30 and p29 and p28 and p27 and g26) or (p31 and p30 
		and p29 and p28 and p27 and p26 and g25) or (p31 and p30 and 
		p29 and p28 and p27 and p26 and p25 and g24)) ;
	

	c0 <= (gg0 or (pp0 and CarryIn)) ;
	c1 <= (gg1 or (pp1 and gg0) or (pp1 and pp0 and CarryIn)) ;
	c2 <= (gg2 or (pp2 and gg1) or (pp2 and pp1 and gg0) or (pp2 and 
		pp1 and pp0 and CarryIn)) ;
	c3 <= (gg3 or (pp3 and gg2) or (pp3 and pp2 and gg1) or (pp3 and pp2 
		and pp1 and gg0) or (pp3 and pp2 and pp1 and pp0 and CarryIn)) 
		;
	l0: alu_8 port map (a(7 downto 0), b(7 downto 0),op,CarryIn, bi, sum(
		7 downto 0), t0);

	l1: alu_8 port map (a(15 downto 8), b(15 downto 8),op,c0, bi, sum(
		15 downto 8), t1);

	l2: alu_8 port map (a(23 downto 16), b(23 downto 16),op,c1, bi, 
		sum(23 downto 16), t2);

	l3: alu_8 port map (a(31 downto 24), b(31 downto 24),op,c2, bi, 
		sum(31 downto 24), t3);

	CarryOut <= (t3 and (bi nand CarryIn));
end logic;


