
-- 1 bit full adder
entity fulladder is port(
	carryin, a, b: in bit;
	sum, carryout:out bit);
end fulladder;

architecture logic of fulladder is
begin
	sum<= (a xor b) xor carryin after 100 ps;
carryout<= ((carryin and a) or (carryin or a)) or (a and b) after 100ps;
end logic;


-- 32 bit full adder, use 32 one-bit full adder.
entity adder_32 is port(
	a,b: in bit_vector(31 downto 0);
	carryin :in bit;
	sum: out bit_vector(31 downto 0);
	carryout : out bit);
end adder_32;

architecture logic of adder_32 is 
	signal c0, c1, c2, c3, c4, c5, c6, c7: bit;
	signal c8, c9, c10, c11, c12, c13, c14, c15: bit;
	signal c16, c17, c18, c19, c20, c21, c22, c23: bit;
	signal c24, c25, c26, c27, c28, c29, c30: bit;
	
	label 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16;
	label 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32;

	component fulladder port(
		carryin, a, b: in bit;	
		sum, carryout:out bit);
	end component;

	for 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16, 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32 : fulladder use entity fulladder(logic);
	
begin
	1: fulladder port map (carryin, a(0), b(0),sum(0),c0);
	2: fulladder port map (c0, a(1), b(1),sum(1),c1);
	3: fulladder port map (c1, a(2), b(2),sum(2),c2);
	4: fulladder port map (c2, a(3), b(3),sum(3),c3);
	5: fulladder port map (c3, a(4), b(4),sum(4),c4);
	6: fulladder port map (c4, a(5), b(5),sum(5),c5);
	7: fulladder port map (c5, a(6), b(6),sum(6),c6);
	8: fulladder port map (c6, a(7), b(7),sum(7),c7);
	9: fulladder port map (c7, a(8), b(8),sum(8),c8);
	10: fulladder port map (c8, a(9), b(9),sum(9),c9);
	11: fulladder port map (c9, a(10), b(10),sum(10),c10);
	12: fulladder port map (c10, a(11), b(11),sum(11),c11);
	13: fulladder port map (c11, a(12), b(12),sum(12),c12);
	14: fulladder port map (c12, a(13), b(13),sum(13),c13);
	15: fulladder port map (c13, a(14), b(14),sum(14),c14);
	16: fulladder port map (c14, a(15), b(15),sum(15),c15);
	17: fulladder port map (c15, a(16), b(16),sum(16),c16);
	18: fulladder port map (c16, a(17), b(17),sum(17),c17);
	19: fulladder port map (c17, a(18), b(18),sum(18),c18);
	20: fulladder port map (c18, a(19), b(19),sum(19),c19);
	21: fulladder port map (c19, a(20), b(20),sum(20),c20);
	22: fulladder port map (c20, a(21), b(21),sum(21),c21);
	23: fulladder port map (c21, a(22), b(22),sum(22),c22);
	24: fulladder port map (c22, a(23), b(23),sum(23),c23);
	25: fulladder port map (c23, a(24), b(24),sum(24),c24);
	26: fulladder port map (c24, a(25), b(25),sum(25),c25);
	27: fulladder port map (c25, a(26), b(26),sum(26),c26);
	28: fulladder port map (c26, a(27), b(27),sum(27),c27);
	29: fulladder port map (c27, a(28), b(28),sum(28),c28);
	30: fulladder port map (c28, a(29), b(29),sum(29),c29);
	31: fulladder port map (c29, a(30), b(30),sum(30),c30);
	32: fulladder port map (c30, a(31), b(31),sum(31),carryout);
end logic;
