.text 0x0		
				jal		Program
				trap	0x104
				trap	0	

.text 0x2000
Program:
				addui	r1,r0,20				; Find 20 Prime numbers
												; Number of Modulo-Operations: 177
				add		r2,r0,PrimeNumberList	; Address for next number

				sll		r3,r1,2					; Multiply by 4
				add		r3,r3,r2				; End-address of list

				addui	r4,r0,2					; 2 is the first Prime number
				sw		0(r2),r4				; Write into list
				addui	r2,r2,4					; Increment address

				addui	r5,r0,3					; r5: TestNumber, start with 3
SearchNext:		addui	r6,r0,PrimeNumberList+4 ; Check found numbers, do not check 2

TestLoop:		sge		r7,r6,r2				; All previous numbers checked ?
				bnez	r7,NumberFound			; Yes

				lw		r7,0(r6)				; Load found Prime number
				divu	f8,f5,f7				; Quotient := TestNumber / OldPrimeNumber
				multu	f8,f8,f7				; Product := Quotient * OldPrimeNumber
				seq		r8,r8,r5				; Set flag if remainder of division is zero
				bnez	r8,NoPrimeNumber
				addui	r6,r6,4					; Increment pointer to next found number
				j		TestLoop

NumberFound:	sw		0(r2),r5				; Store new prime number
				addui	r2,r2,4					; Increment pointer for next Prime number

NoPrimeNumber:	addui	r5,r5,2					; Increment TestNumber
				slt		r7,r2,r3				; Search next Prime number ?
				bnez	r7,SearchNext			; Yes

				; Print numbers to file, output file is 'dlx.dump'
				lhi		r16,0xffff
				addui	r17,r0,0xff00
				add		r16,r16,r17				; Base address of external registers
				addui	r17,r0,0x3000
				trap	0x104					; Wait until Write-Buffer is empty, avoid merge
				sw		0(r16),r17				; Start address of memory block
				addui	r17,r0,32
				trap	0x104
				sw		4(r16),r17				; Number of elements ( 32 )
				trap	0x104
				sw		8(r16),r0				; Start transfer of words

				jr		r31						; Done

.text 0x3000
PrimeNumberList:
