.text 0x0000	; Reset
			jal		Program
										; Never executed
			trap	0x104				; Wait until Write-Buffer is empty
			trap	0					; Halt

.text 0x0100	; Store Transfer-Error
			trap	0x104				; Wait until Write-Buffer is empty
			trap	0					; Halt

.text 0x0A00	; External Interrupt
			lw		r30,-0xc0(r0)		; 0xffff_ff40, Interrupt Acknowledge
										; r30 can be used to determine the device
										;               that caused the interrupt
			nop
			rfe		0					; Assembler needs dummy parameter

.text 0x2000
Program:								; Evaluate some Fibonacci numbers
			addui	r1,r0,List + 4		; r1: Pointer to list of numbers ( Word )
			addui	r2,r0,1				; Initialise register
			sw		-0x80(r0),r2		; 0xffff_ff80 Interrupt-Enable register,
										; enable Interrupt
			add		r3,r0,r2			; Initialise register
			lhu		r4,CountLoops(r0)	; Run loop 3 times
			sw		-4(r1),r2			; Store first Fibonacci number ( 1 )
Loop:			; Two Fibonacci numbers per run
			sw		0(r1),r3
			add		r2,r2,r3			; Compute next Fibonacci number
			sw		4(r1),r2
			addui	r1,r1,8				; Increment pointer
			add		r3,r2,r3			; Compute next Fibonacci number
			sub		r4,r4,1				; Decrement counter
										; Yes, it would be better to do this two
										; instructions earlier. But in this
										; program I want to demonstrate unresolved
										; branches and speculative execution.
			bnez	r4,Loop				; Run again ?

			; Print list to file, output file is 'dlx.dump'
			addui	r7,r0,List
			trap	0x104				; Wait until Write-Buffer is empty,  avoid merge
			sw		-0x100(r0),r7		; Start address of memory block
			addui	r7,r0,20
			trap	0x104
			sw		-0xfc(r0),r7		; Number of elements ( 20 )
			trap	0x104
			sw		-0xf8(r0),r0		; Start transfer of words

				; Force Store-Error
			sw		-0x1000(r0),r0		; The exception handler  will halt the DLX

			jr		r31					; Done
CountLoops:	.word	0x00030000

.text 0x3000
List:
