.text 0x0		
				jal		Program
				trap	0x104
				trap	0	

.text 0x2000
Program:
				addui	r1,r0,50			; Sort 50 numbers ( Bubble-Sort )
				subi	r1,r1,1				; Index 0 ... n-1
				sll		r1,r1,1				; Sort half-words
				add		r2,r0,r0			; r1: SortedFlag, list not sorted

RunAgain:		slti	r3,r1,0				; List sorted ?
				bnez	r3,Ready			; Yes

				add		r3,r0,r0			; Index := 0
				addui	r2,r0,1				; SortedFlag, list sorted
Compare:		sge		r4,r3,r1			; End of unsorted head of list reached ?
				bnez	r4,EndCompare		; Yes

				lh		r5,List(r3)			; Read
				lh		r6,List+2(r3)		; Read successor
				addui	r3,r3,2				; Increment pointer ( half-word )
				sle    	r4,r5,r6			; Right order ?
 				bnez	r4,Compare			; Yes, compare next

				sh		List-2(r3),r6		; Wrong order, swap, r3 was incremented
				add		r2,r0,r0			; SortedFlag, list not sorted
				sh		List(r3),r5
				beqz	r0,Compare			; Branch always

EndCompare:		bnez	r2,Ready			; Ready when list sorted
				subi	r1,r1,2				; Next run to previous index
				j		RunAgain
Ready:
				; Print sorted list to file, output file is 'dlx.dump'
				lhi		r16,0xffff
				addui	r17,r0,0xff00
				add		r16,r16,r17			; Base address of external registers
				addui	r17,r0,List
				trap	0x104				; Wait until Write-Buffer is empty, avoid merge
				sw		0(r16),r17			; Start address of memory block
				addui	r17,r0,60
				trap	0x104
				sw		4(r16),r17			; Number of elements ( 60 )
				trap	0x104
				sw		12(r16),r0			; Start transfer of half-words

				jr		r31					; Done
.text 0x3000
List:
		.word	0x7b878e63
		.word	0x4d36a53a
		.word	0x34a56f27
		.word	0x8902ba5f
		.word	0x02bd8efb
		.word	0x296ac736
		.word	0x77777777
		.word	0x878e28df
		.word	0x0fc46ba8
		.word	0x14fd3556
		.word	0x348efc22
		.word	0x1904f6dc
		.word	0x28b2d2ab
		.word	0x6f278e63
		.word	0x2972befa
		.word	0x293c62f3
		.word	0x8c7f22b9
		.word	0xa3289281
		.word	0x4d36bedc
		.word	0xfff27191
		.word	0x282fca29
		.word	0x1c227101
		.word	0x21761efd
		.word	0x7b8728fd
		.word	0xd27a3bc2
