entity switch is port(
	data_in1,data_in2,data_in3 : in bit_vector(31 downto 0);
	enable1,enable2,enable3 : in bit;
	dest1,dest2,dest3: in bit_vector(1 downto 0);
	in_reg1,in_reg2,in_reg3: in bit_vector(4 downto 0);
	data_out1,data_out2,data_out3 : out bit_vector(31 downto 0);
	out_enable1,out_enable2,out_enable3 : out bit;
	out_reg1,out_reg2,out_reg3: out bit_vector(4 downto 0));
end switch;

architecture logic of switch is
        signal t1,t2,t3,t4: bit_vector(31 downto 0);
        signal tt1,tt2,tt3,tt4: bit_vector(4 downto 0);
	signal out_ee1,out_ee2, out_ee3: bit;
begin
-- generate out value 
        t1(31 downto 0) <= data_in3(31 downto 0)
                when ((not(enable1)) and (not(enable2)) and enable3)
                else "00000000000000000000000000000000" after 100ps;

        t2(31 downto 0) <= data_in2(31 downto 0)
                when ((not(enable1)) and enable2  and (not(enable3)))
                else "00000000000000000000000000000000" after 100ps;

        t3(31 downto 0) <= data_in1(31 downto 0)
                when (enable1 and (not(enable2)) and (not(enable3)))
                else "00000000000000000000000000000000" after 100ps;

        t4(31 downto 0) <=(t1(31 downto 0) or t2(31 downto 0)
                or t3(31 downto 0) ) after 100ps;
	
	data_out1(31 downto 0) <=t4(31 downto 0) after 100 ps;	
	data_out2(31 downto 0) <=t4(31 downto 0) after 100 ps;	
	data_out3(31 downto 0) <=t4(31 downto 0) after 100 ps;	

-- generate register index
	tt1(4 downto 0) <= in_reg3(4 downto 0)
                when ((not(enable1)) and (not(enable2)) and enable3)
                else "00000" after 100ps;

	tt2(4 downto 0) <= in_reg2(4 downto 0)
                when ((not(enable1)) and (not(enable3)) and enable2)
                else "00000" after 100ps;

	tt3(4 downto 0) <= in_reg1(4 downto 0)
                when ((not(enable3)) and (not(enable2)) and enable1)
                else "00000" after 100ps;

        tt4(4 downto 0) <=(t1(4 downto 0) or t2(4 downto 0)
                or t3(4 downto 0) ) after 100ps;

        out_reg1(4 downto 0) <=tt4(4 downto 0) after 100 ps;
        out_reg2(4 downto 0) <=tt4(4 downto 0) after 100 ps;
        out_reg3(4 downto 0) <=tt4(4 downto 0) after 100 ps;

-- generate out_enable
	out_ee1 <= (dest1(0) and enable1) or (dest2(0) and enable2) or
		(dest3(0) and enable3);
	out_ee2 <= (dest1(1) and enable1) or (dest2(1) and enable2) or
                (dest3(1) and enable3);
	out_ee3 <= enable1 or enable2 or enable3 ;
	out_enable1 <= ((not(out_ee1)) and (not(out_ee2))) and out_ee3;
	out_enable2 <= ((not(out_ee1)) and out_ee2) and out_ee3;
 	out_enable3 <= (out_ee1 and (not(out_ee2))) and out_ee3;
end logic;
