entity D_LATCH1 is
    port(dlin : in bit;
	lclock,lreset :	in bit;
	dlout,dloutbar: out bit);
end D_LATCH1;

architecture logic of D_LATCH1 is
	signal t1, t2, t3,t4,t5 : bit;
begin
	t1 <= not(dlin);
	t2 <= "1" when (lclock) 
		else "0";
	t3 <= (t2 and t1);
	t4 <= (dlin and t2);
	t5 <= "1" when (lreset)
		else "0";
	dlout <= ((dloutbar nor t3) and (not(t5))) after 100ps;
	dloutbar <= (dlout nor t4) after 300ps;
	
end logic;

entity reg1 is
	port( 	data_in : in bit;
		lclock, lreset: in bit;
		data_out : out bit);
end reg1;

architecture logic of reg1 is
	signal q0,q0bar,tmp: bit;
	signal lclock_bar,lclock_bar_bar : bit;
	label l0,l1;
	component D_LATCH1
		port(dlin : in bit;
		lclock,lreset :	in bit;
		dlout,dloutbar: out bit);
	end component;
	for l0,l1:D_LATCH1 use entity D_LATCH1(logic);
begin
	lclock_bar<= (not(lclock));
	lclock_bar_bar<=(not(lclock_bar));
	l0:D_LATCH1 port map(data_in,lclock_bar,lreset,q0,q0bar);
  	l1:D_LATCH1 port map(q0,lclock,lreset,data_out,tmp);
end logic;
