entity memstage is
  	port( 
	alu_in,data_in,frexe,frmem: in bit_vector(31 downto 0);
	write_en,smem1,smem2 : in bit;
       	reg_addr_in: in bit_vector(4 downto 0);
       	pclock : in bit;
       	data_out, alu_out: out bit_vector(31 downto 0);
       	reg_addr_out: out bit_vector(4 downto 0));
end memstage;

architecture logic of memstage is
  	label memd1;
  	component data_memory
		port (read0addr,read1addr,writeaddr: in bit_vector(4 downto 0);
		writedata: in bit_vector(31 downto 0);
		write_en,rf_clock,rf_reset: in bit;
		read0data,read1data: out bit_vector(31 downto 0));	
  	end component;
  	for memd1: data_memory use entity data_memory(logic);
  	label m0;
  	component mux32_4_1
   		port(a,b,c,d : in bit_vector(31 downto 0);
		s1,s2 : in bit ;
		q :   out bit_vector(31 downto 0));
  	end component;
  	for m0: mux32_4_1 use entity mux32_4_1(logic);

  	signal tmp,tmp0: bit_vector(31 downto 0);

begin
  	m0: mux32_4_1 port map(data_in,frexe,frmem,x"00000000",smem1,smem2,tmp0);
  	memd1:data_memory port map(alu_in(4 downto 0),alu_in(4 downto 0), 
	alu_in(4 downto 0),tmp0,write_en,pclock,"0",data_out,tmp);
  	reg_addr_out<=reg_addr_in after 100ps;
  	alu_out<=alu_in after 100ps;
end logic;
