-- signextend, extend 16 bit sign to 32 bit sign
-- Imm <-- ((IR(16))e16 ## IR(16..31)

entity signextend is
  port(data_in: in bit_vector(15 downto 0);
       data_out : out bit_vector(31 downto 0));
end signextend;

architecture sign_data of signextend is
begin
-- put data_in(15) in data_out(0..15), put data_in(0..15) to data_out(16..31)
	data_out(0) <= data_in(15) after 100 ps;
	data_out(1) <= data_in(15) after 100 ps;
	data_out(2) <= data_in(15) after 100 ps;
	data_out(3) <= data_in(15) after 100 ps;
	data_out(4) <= data_in(15) after 100 ps;
	data_out(5) <= data_in(15) after 100 ps;
	data_out(6) <= data_in(15) after 100 ps;
	data_out(7) <= data_in(15) after 100 ps;
	data_out(8) <= data_in(15) after 100 ps;
	data_out(9) <= data_in(15) after 100 ps;
	data_out(10) <= data_in(15) after 100 ps;
	data_out(11) <= data_in(15) after 100 ps;
	data_out(12) <= data_in(15) after 100 ps;
	data_out(13) <= data_in(15) after 100 ps;
	data_out(14) <= data_in(15) after 100 ps;
	data_out(15) <= data_in(15) after 100 ps;
	data_out(16) <= data_in(0) after 100 ps;
	data_out(17) <= data_in(1) after 100 ps;
	data_out(18) <= data_in(2) after 100 ps;
	data_out(19) <= data_in(3) after 100 ps;
	data_out(20) <= data_in(4) after 100 ps;
	data_out(21) <= data_in(5) after 100 ps;
	data_out(22) <= data_in(6) after 100 ps;
	data_out(23) <= data_in(7) after 100 ps;
	data_out(24) <= data_in(8) after 100 ps;
	data_out(25) <= data_in(9) after 100 ps;
	data_out(26) <= data_in(10) after 100 ps;
	data_out(27) <= data_in(11) after 100 ps;
	data_out(28) <= data_in(12) after 100 ps;
	data_out(29) <= data_in(13) after 100 ps;
	data_out(30) <= data_in(14) after 100 ps;
	data_out(31) <= data_in(15) after 100 ps;
end sign_data;

-- compare if data_in==0 ,
-- if data_in==0, and control=1, output 0,
-- else output 1
-- used for branch control 
entity compzero is
  	port(data_in: bit_vector(31 downto 0);
       		control: in bit;
       		data_out: out bit);
end compzero;

architecture compzero_data of compzero is
begin
  	data_out <= data_in(0) or data_in(1) or data_in(2) or data_in(3) or 
		data_in(4) or data_in(5) or data_in(6) or data_in(7) or 
		data_in(8) or data_in(9) or data_in(10) or data_in(11) or 
	  	data_in(12) or data_in(13) or data_in(14) or data_in(15) or
		data_in(16) or data_in(17) or data_in(18) or data_in(19) or 
		data_in(20) or data_in(21) or data_in(22) or data_in(23) or 
		data_in(24) or data_in(25) or data_in(26) or data_in(27) or 
		data_in(28) or data_in(29) or data_in(30) or data_in(31)   
		or (not (control)) after 100ps;
end compzero_data;

entity idstage is
  	port(npc,ir,wbdata: in bit_vector(31 downto 0);  
--ir:instr_out
       		wbaddr: in bit_vector(4 downto 0);
       		writen,idclock,idreset,branchctrl: in bit;
       		opcodeout: out bit_vector(5 downto 0);
       		branchpc,idexa,idexb,ideximm: out bit_vector(31 downto 0);
       		wbaddrpass0,wbaddrpass1: out bit_vector(4 downto 0);
       		controlpc: out bit;
       		s_enable_out: out bit;               
    --to switch.enable / 1:enable 0:not enable
 		dest: out bit_vector(1 downto 0));      
  --to switch.dest / which dlx to send(00,01,10)
             
end idstage;

architecture iddata of idstage is
  	label a0;
  	component adder_32
    		port(a, b : in bit_vector (31 downto 0);
		CarryIn : in bit;
		sum : out bit_vector (31 downto 0);
		CarryOut : out bit);
  	end component;
  	for a0:adder_32 use entity adder_32(logic); 
  	label rf0;
  	component registers 
    		port (read0addr,read1addr,writeaddr: in bit_vector(4 downto 0);
	  	writedata: in bit_vector(31 downto 0);
	  	write_en,rf_clock,rf_reset: in bit;
	  	read0data,read1data: out bit_vector(31 downto 0));  
  	end component;
  	for rf0:registers use entity registers(logic);
  	label ex0;
  	component signextend
    		port(data_in: in bit_vector(15 downto 0);
       		data_out : out bit_vector(31 downto 0));
  	end component;
  	for ex0:signextend use entity signextend(sign_data);  
  	label comp0;
  	component compzero
    		port(data_in: bit_vector(31 downto 0);
	 	control: in bit;
         	data_out: out bit); 
  	end component;
  	for comp0:compzero use entity compzero(compzero_data);

  	signal carryin,carryout: bit;
  
begin
  	carryin <= "0";
  	opcodeout <= ir(31 downto 26) after 100ps;
  	ex0: signextend port map(ir(15 downto 0),ideximm);  
  	a0: adder_32 port map(npc,ideximm,carryin,branchpc,carryout);
  	rf0: registers port map(ir(25 downto 21),ir(20 downto 16),wbaddr,wbdata,writen,idclock,"0",idexa,idexb);
  	comp0: compzero port map(idexa,branchctrl,controlpc);
  	wbaddrpass0 <= ir(20 downto 16) after 100ps;
  	wbaddrpass1 <= ir(15 downto 11) after 100ps;


--implement 'send'
  	s_enable_out <= ir(31) and (not(ir(30))) and (not(ir(29))) and (not(ir(28))) and (not(ir(27))) and ir(26) and ir(2) and ir(1) and ir(0) after 1ps;
--  instr_out(31 downto 26) = '100001' | instr_out(3 downto 0)= '111') : send

  	dest(0) <= not(s_enable_out) after 1ps;
  	dest(1) <= not(s_enable_out) after 1ps;
end iddata;
