entity ID_EX_REG is
  	port(data1_in, data2_in, sign_in: in bit_vector(31 downto 0);
       instr1_in, instr2_in,forwdesin0,forwdesin1: in bit_vector(4 downto 0);
       funcin: in bit_vector(3 downto 0);
       pclock, preset: in bit; 
       opcodein: in bit_vector(5 downto 0);
       data1_out, data2_out, sign_out: out bit_vector(31 downto 0);
       instr1_out, instr2_out,forwdesout0,forwdesout1: out bit_vector(4 downto 0);
       opcodeout: out bit_vector(5 downto 0);
       funcout: out bit_vector(3 downto 0)); 
end ID_EX_REG;

architecture logic of ID_EX_REG is
	signal t3:bit;
  label idexr0,idexr1,idexr2,idexr3,idexr4,idexr5,idexr6,idexr7;
  component REG32
    port(data_in: in bit_vector(31 downto 0);
         clock,lreset: in bit;
         data_out: out bit_vector(31 downto 0));
  end component;

  label opcode;
  component reg6
    port(  data_in : in bit_vector(5 downto 0);
           lclock, lreset: in bit;
           data_out : out bit_vector(5 downto 0));
  end component;
  for opcode: reg6 use entity reg6(logic);

  component reg5
    port(data_in: in bit_vector(4 downto 0);
         clock,lreset: in bit;
         data_out: out bit_vector(4 downto 0));
  end component;

  component reg4
    port(data_in: in bit_vector(3 downto 0);
         clock,lreset: in bit;
         data_out: out bit_vector(3 downto 0));
  end component;
  
  for idexr0,idexr1,idexr2: REG32 use entity REG32(reg_data);
  for idexr3,idexr4,idexr6,idexr7 : reg5 use entity reg5(logic);
  for idexr5: reg4 use entity reg4(logic);

begin
	
  idexr0:REG32 port map(data1_in,pclock,preset,data1_out);
  idexr1:REG32 port map(data2_in,pclock,preset,data2_out);
  idexr2:REG32 port map(sign_in,pclock,preset,sign_out);
  idexr3:reg5 port map(instr1_in,pclock,preset,instr1_out);
  idexr4:reg5 port map(instr2_in,pclock,preset,instr2_out);
  opcode:reg6 port map(opcodein,pclock,preset,opcodeout);
  idexr5:reg4 port map(funcin,pclock,preset,funcout);
  idexr6:reg5 port map(forwdesin0,pclock,preset,forwdesout0);
  idexr7:reg5 port map(forwdesin1,pclock,preset,forwdesout1);  
end logic;
