entity forwarding is 
	port (fclock: in bit;
	      if_id_src1 : in bit_vector(4 downto 0);
	      if_id_src2 : in bit_vector(4 downto 0);
	      if_id_opcode : in bit_vector(5 downto 0);
	      id_ex_des  : in bit_vector(4 downto 0);
	      id_ex_opcode : in bit_vector(5 downto 0);
	      ex_mem_des : in bit_vector(4 downto 0);
	      ex_mem_opcode : in bit_vector(5 downto 0);
	      stall : in bit;
	      controls1_exe : out bit_vector(1 downto 0); --alu
	      controls2_exe : out bit_vector(1 downto 0); --alu
	      controls1_mem : out bit_vector(1 downto 0));--mem
end forwarding;

architecture forwarding_logic of forwarding is

	signal t11, t12, t21, t22, t111, t121 : bit;
	signal alu_t, idex_swt, exmem_swt, ld_t, sw_t, idex_ldt, exmem_ldt, idex_alut, exmem_alut : bit;
	signal tmp_contr_exe1, tmp_contr_exe2, tmp_contr_mem1, tmp_contr_mem2 : bit_vector(1 downto 0);
	label r1,r2,r3, r4;

	component reg2
	port( 	data_in : in bit_vector(1 downto 0);
		lclock, lreset: in bit;
		data_out : out bit_vector(1 downto 0));
	end component;
	for all : reg2 use entity reg2(logic);

begin

	alu_t<=if_id_opcode(5) and not(if_id_opcode(4)) and 
		not(if_id_opcode(3)) and not(if_id_opcode(2)) 
		and not(if_id_opcode(1));

        idex_alut <= id_ex_opcode(5) and not(id_ex_opcode(4)) and not(id_ex_opcode(3))
		     and not(id_ex_opcode(2)) and not(id_ex_opcode(1)); 
	exmem_alut <= ex_mem_opcode(5) and not(ex_mem_opcode(4)) and not(ex_mem_opcode(3))
		     and not(ex_mem_opcode(2)) and not(ex_mem_opcode(1));
	idex_swt <= id_ex_opcode(5) and id_ex_opcode(4) and id_ex_opcode(3)
		    and not(id_ex_opcode(2)) and not(id_ex_opcode(1));
	exmem_swt <= ex_mem_opcode(5) and ex_mem_opcode(4) and ex_mem_opcode(3)
		     and not(ex_mem_opcode(2)) and not(ex_mem_opcode(1));
	idex_ldt <= id_ex_opcode(5) and id_ex_opcode(4) and not(id_ex_opcode(3))
		    and not(id_ex_opcode(2)) and not(id_ex_opcode(1));
	exmem_ldt <= ex_mem_opcode(5) and ex_mem_opcode(4) and not(ex_mem_opcode(3))
		     and not(ex_mem_opcode(2)) and not(ex_mem_opcode(1));

	ld_t <= if_id_opcode(5) and if_id_opcode(4) and not(if_id_opcode(3)) and
		not(if_id_opcode(2)) and not(if_id_opcode(1));
	sw_t <= if_id_opcode(5) and if_id_opcode(4) and if_id_opcode(3) and
		not(if_id_opcode(2)) and not(if_id_opcode(1));

        t11   <= not((if_id_src1(0) xor id_ex_des(0)) or (if_id_src1(1) xor id_ex_des(1)) or 
	         (if_id_src1(2) xor id_ex_des(2)) or (if_id_src1(3) xor id_ex_des(3)) or
		 (if_id_src1(4) xor id_ex_des(4))) and not(idex_swt) and alu_t;
	t12   <= not((if_id_src1(0) xor ex_mem_des(0)) or (if_id_src1(1) xor ex_mem_des(1))or
		 (if_id_src1(2) xor ex_mem_des(2)) or (if_id_src1(3) xor ex_mem_des(3)) or
		 (if_id_src1(4) xor ex_mem_des(4))) and not(exmem_swt) and alu_t;

	t21   <= not((if_id_src2(0) xor id_ex_des(0)) or (if_id_src2(1) xor id_ex_des(1)) or 
	         (if_id_src2(2) xor id_ex_des(2)) or (if_id_src2(3) xor id_ex_des(3)) or
		 (if_id_src2(4) xor id_ex_des(4))) and not(idex_swt) and alu_t;
	t22   <= not((if_id_src2(0) xor ex_mem_des(0)) or (if_id_src2(1) xor ex_mem_des(1)) or
		 (if_id_src2(2) xor ex_mem_des(2)) or (if_id_src2(3) xor ex_mem_des(3)) or
		 (if_id_src2(4) xor ex_mem_des(4))) and not(exmem_swt) and alu_t;

	tmp_contr_exe1(0) <= "0" when ((stall and alu_t and t11)
				     or (not(stall) and alu_t and t12)) else "0";
	tmp_contr_exe1(1) <= "1" when ((stall and alu_t and t11)
				     or (not(stall) and alu_t and t12)) else "0";
	tmp_contr_exe1(0) <= "1" when (not(stall) and alu_t and t11) else "0";
	tmp_contr_exe1(1) <= "0" when (not(stall) and alu_t and t11) else "0";

	tmp_contr_exe2(0) <= "0" when ((stall and alu_t and t21)
				     or (not(stall) and alu_t and t22)) else "0";
	tmp_contr_exe2(1) <= "1" when ((stall and alu_t and t21)
				     or (not(stall) and alu_t and t22)) else "0";
	tmp_contr_exe2(0) <= "1" when (not(stall) and alu_t and t21) else "0";
	tmp_contr_exe2(1) <= "0" when (not(stall) and alu_t and t21) else "0";

	t111 <= not((if_id_src1(0) xor id_ex_des(0)) or (if_id_src1(1) xor id_ex_des(1)) or 
	         (if_id_src1(2) xor id_ex_des(2)) or (if_id_src1(3) xor id_ex_des(3)) or
		 (if_id_src1(4) xor id_ex_des(4))) and ((idex_swt and ld_t) or 
		 (idex_ldt and sw_t) or (sw_t and idex_alut));
	t121 <= not((if_id_src1(0) xor ex_mem_des(0)) or (if_id_src1(1) xor ex_mem_des(1))or
		 (if_id_src1(2) xor ex_mem_des(2)) or (if_id_src1(3) xor ex_mem_des(3)) or
		 (if_id_src1(4) xor ex_mem_des(4))) and ((exmem_swt and ld_t) or
		 (exmem_ldt and sw_t));
	tmp_contr_mem1(0) <= "0" when t111 else "0";
	tmp_contr_mem1(1) <= "1" when t111 else "0";

	r1:reg2 port map (tmp_contr_exe1,fclock,"0", controls1_exe);
	r2:reg2 port map (tmp_contr_exe2,fclock,"0", controls2_exe);	
	
	r3:reg2 port map (tmp_contr_mem1,fclock,"0", tmp_contr_mem2);
	r4:reg2 port map (tmp_contr_mem2,fclock,"0", controls1_mem);
	
end forwarding_logic;
