entity data_memory is
  port (read0addr,read1addr,writeaddr: in bit_vector(4 downto 0);
	writedata: in bit_vector(31 downto 0);
	write_en,rf_clock,rf_reset: in bit;
	read0data,read1data: out bit_vector(31 downto 0));	
end data_memory;

architecture logic of data_memory is
  signal R0,R1,R2,R3,R4,R5,R6,R7,R8,R9,R10,R11,R12,R13,R14,R15,R16,
	 R17,R18,R19,R20,R21,R22,R23,R24,R25,R26,R27,R28,R29,R30,R31:
	 bit_vector(31 downto 0);
  signal read0databar,read1databar: bit_vector(31 downto 0);
  signal value,rfw_clock: bit_vector(31 downto 0);

  label RR0,RR1,RR2,RR3,RR4,RR5,RR6,RR7,RR8,RR9,RR10,RR11,RR12,RR13,RR14,RR15;
      --  RR16,RR17,RR18,RR19,RR20,RR21,RR22,RR23,RR24,RR25,RR26,RR27,RR28,RR29,RR30,RR31;
  component REG32
    port(data_in: in bit_vector(31 downto 0);rclock,rreset: in bit;data_out: out bit_vector(31 downto 0)); 
  end component;
  for RR0,RR1,RR2,RR3,RR4,RR5,RR6,RR7,RR8,RR9,RR10,RR11,RR12,RR13,RR14,RR15:REG32
	--RR16,RR17,RR18,RR19,RR20,RR21,RR22,RR23,RR24,RR25,RR26,RR27,RR28,RR29,RR30,RR31:REG32
    use entity REG32(reg_data);
  label m0,m1;
  component mux32_32_1
    port (address : in bit_vector(4 downto 0);
	D0,D1,D2,D3,D4,D5,D6,D7,D8,D9,D10,D11,D12,D13,D14,D15,D16,
	D17,D18,D19,D20,D21,D22,D23,D24,D25,D26,D27,D28,D29,D30,D31:in bit_vector(31 downto 0);
	out_D,out_Dbar: out bit_vector(31 downto 0));
  end component;
  for m0,m1:mux32_32_1
    use entity mux32_32_1(mux32_32_1_str);
  label dc0;
  component Decode32
    port(address: in bit_vector(4 downto 0);out_value: out bit_vector(31 downto 0));
  end component;
  for dc0:Decode32 use entity Decode32(Decode32_data);
  

begin

  dc0: Decode32 port map(writeaddr,value);

  rfw_clock(0) <= write_en and value(0) and rf_clock after 100ps;  
  RR0: REG32 port map(writedata,rfw_clock(0),rf_reset,R0);
 
  rfw_clock(1) <= write_en and value(1) and rf_clock after 100ps ;
  RR1: REG32 port map(writedata,rfw_clock(1),rf_reset,R1);
  
  rfw_clock(2) <= write_en and value(2) and rf_clock after 100ps;
  RR2: REG32 port map(writedata,rfw_clock(2),rf_reset,R2);
  
  rfw_clock(3) <= write_en and value(3) and rf_clock after 100ps;
  RR3: REG32 port map(writedata,rfw_clock(3),rf_reset,R3); 
  
  rfw_clock(4) <= write_en and value(4) and rf_clock after 100ps;
  RR4: REG32 port map(writedata,rfw_clock(4),rf_reset,R4);
  
  rfw_clock(5) <= write_en and value(5) and rf_clock after 100ps;
  RR5: REG32 port map(writedata,rfw_clock(5),rf_reset,R5);
  
  rfw_clock(6) <= write_en and value(6) and rf_clock after 100ps;
  RR6: REG32 port map(writedata,rfw_clock(6),rf_reset,R6);
  
  rfw_clock(7) <= write_en and value(7) and rf_clock after 100ps;
  RR7: REG32 port map(writedata,rfw_clock(7),rf_reset,R7);
  
  rfw_clock(8) <= write_en and value(8) and rf_clock after 100ps;
  RR8: REG32 port map(writedata,rfw_clock(8),rf_reset,R8);
  
  rfw_clock(9) <= write_en and value(9) and rf_clock after 100ps;
  RR9: REG32 port map(writedata,rfw_clock(9),rf_reset,R9);
  
  rfw_clock(10) <= write_en and value(10) and rf_clock after 100ps;
  RR10: REG32 port map(writedata,rfw_clock(10),rf_reset,R10);
  
  rfw_clock(11) <= write_en and value(11) and rf_clock after 100ps;
  RR11: REG32 port map(writedata,rfw_clock(11),rf_reset,R11); 
  
  rfw_clock(12) <= write_en and value(12) and rf_clock after 100ps;
  RR12: REG32 port map(writedata,rfw_clock(12),rf_reset,R12);
  
  rfw_clock(13) <= write_en and value(13) and rf_clock after 100ps;
  RR13: REG32 port map(writedata,rfw_clock(13),rf_reset,R13);
  
  rfw_clock(14) <= write_en and value(14) and rf_clock after 100ps;
  RR14: REG32 port map(writedata,rfw_clock(14),rf_reset,R14);
  
  rfw_clock(15) <= write_en and value(15) and rf_clock after 100ps;
  RR15: REG32 port map(writedata,rfw_clock(15),rf_reset,R15); 
  
 -- rfw_clock(16) <= write_en and value(16) and rf_clock after 100ps;
 -- RR16: REG32 port map(writedata,rfw_clock(16),rf_reset,R16);
  
  --rfw_clock(17) <= write_en and value(17) and rf_clock after 100ps;
  --RR17: REG32 port map(writedata,rfw_clock(17),rf_reset,R17);
  
  --rfw_clock(18) <= write_en and value(18) and rf_clock after 100ps;
  --RR18: REG32 port map(writedata,rfw_clock(18),rf_reset,R18);
  
  --rfw_clock(19) <= write_en and value(19) and rf_clock after 100ps;
  --RR19: REG32 port map(writedata,rfw_clock(19),rf_reset,R19); 
  
  --rfw_clock(20) <= write_en and value(20) and rf_clock after 100ps;
  --RR20: REG32 port map(writedata,rfw_clock(20),rf_reset,R20);

  --rfw_clock(21) <= write_en and value(21) and rf_clock after 100ps;
  --RR21: REG32 port map(writedata,rfw_clock(21),rf_reset,R21);

  --rfw_clock(22) <= write_en and value(22) and rf_clock after 100ps;
  --RR22: REG32 port map(writedata,rfw_clock(22),rf_reset,R22);

  --rfw_clock(23) <= write_en and value(23) and rf_clock after 100ps;
  --RR23: REG32 port map(writedata,rfw_clock(23),rf_reset,R23);

  --rfw_clock(24) <= write_en and value(24) and rf_clock after 100ps;
  --RR24: REG32 port map(writedata,rfw_clock(24),rf_reset,R24);

  --rfw_clock(25) <= write_en and value(25) and rf_clock after 100ps;
  --RR25: REG32 port map(writedata,rfw_clock(25),rf_reset,R25);

  --rfw_clock(26) <= write_en and value(26) and rf_clock after 100ps;
  --RR26: REG32 port map(writedata,rfw_clock(26),rf_reset,R26);

  --rfw_clock(27) <= write_en and value(27) and rf_clock after 100ps;
  --RR27: REG32 port map(writedata,rfw_clock(27),rf_reset,R27);
 
  --rfw_clock(28) <= write_en and value(28) and rf_clock after 100ps;
  --RR28: REG32 port map(writedata,rfw_clock(28),rf_reset,R28);

  --rfw_clock(29) <= write_en and value(29) and rf_clock after 100ps;
  --RR29: REG32 port map(writedata,rfw_clock(29),rf_reset,R29);

  --rfw_clock(30) <= write_en and value(30) and rf_clock after 100ps;
  --RR30: REG32 port map(writedata,rfw_clock(30),rf_reset,R30);

  --rfw_clock(31) <= write_en and value(31) and rf_clock after 100ps;
  --RR31: REG32 port map(writedata,rfw_clock(31),rf_reset,R31);

  R16 <= x"00000000" after 100ps;
  R17 <= x"00000000" after 100ps;
  R18 <= x"00000000" after 100ps;
  R19 <= x"00000000" after 100ps;
  R20 <= x"00000000" after 100ps;
  R21 <= x"00000000" after 100ps;
  R22 <= x"00000000" after 100ps;
  R23 <= x"00000000" after 100ps;
  R24 <= x"00000000" after 100ps;
  R25 <= x"00000000" after 100ps;
  R26 <= x"00000000" after 100ps;
  R27 <= x"00000000" after 100ps;
  R28 <= x"00000000" after 100ps;
  R29 <= x"00000000" after 100ps;
  R30 <= x"00000000" after 100ps;
  R31 <= x"00000000" after 100ps;
  
  
  m0: mux32_32_1 port map(read0addr,R0,R1,R2,R3,R4,R5,R6,R7,R8,R9,R10,
		     R11,R12,R13,R14,R15,R16,R17,R18,R19,R20,R21,R22,
		     R23,R24,R25,R26,R27,R28,R29,R30,R31,read0data,read0databar);
 
  m1: mux32_32_1 port map(read1addr,R0,R1,R2,R3,R4,R5,R6,R7,R8,R9,R10,
		     R11,R12,R13,R14,R15,R16,R17,R18,R19,R20,R21,R22,
		     R23,R24,R25,R26,R27,R28,R29,R30,R31,read1data,read1databar);

end logic;
