--generate the control signals which used in pipeline stages.
--c(7) Rd_Des
--c(6) AluSrc
--c(5) MemToReg
--c(4) MemToReg
--c(3) RegWr
--c(2) MemWr
--c(1) MemRd
--c(0) Branch

entity control_unit is
	port(IR : in bit_vector(5 downto 0);
	     lclock,stall : in bit;
	     if_id_reset: out bit;
	     c : out bit_vector(7 downto 0));
end control_unit;

architecture logic of control_unit is 
	signal tmp : bit_vector (7 downto 0);
	signal t0 : bit_vector(6 downto 0);
	signal t1 : bit_vector(4 downto 0);
	signal lreset,tmp_c0 : bit;
	
	label rg;
	component reg1
		port(data_in: in bit;
       		rclock,rreset: in bit;
       		data_out: out bit);
	end component;

	for rg : reg1 use entity reg1(logic);
	
	label l1,l2,l3;
	
	component reg7
	port( 	data_in : in bit_vector(6 downto 0);
		lclock, lreset: in bit;
		data_out : out bit_vector(6 downto 0));
	end component;
	
	component reg5
	port( 	data_in : in bit_vector(4 downto 0);
		lclock, lreset: in bit;
		data_out : out bit_vector(4 downto 0));
	end component;

	component reg3
	port( 	data_in : in bit_vector(2 downto 0);
		lclock, lreset: in bit;
		data_out : out bit_vector(2 downto 0));
	end component;

	for l1 : reg7 use entity reg7(logic);
	for l2 : reg5 use entity reg5(logic);
	for l3 : reg3 use entity reg3(logic);

begin
	tmp(7)<= IR(5) and IR(4) and IR(3) and not(IR(2)); --Alu or SW op
	tmp(6)<= IR(0);--AluSrc and BEQZ or BNEZ

	--mem or alu will be write back
	tmp(5)<=IR(5) and IR(1);
	tmp(4)<=not((IR(5) and IR(4)) or (IR(5) and IR(1)));
	tmp(3)<=not(IR(5) and IR(4) and IR(3)) and not(stall);--RegWr
	tmp(2)<=IR(5) and IR(4) and IR(3) and not(IR(2)); --MemWr
	tmp(1)<=IR(5) and IR(4) and not(IR(3)); --MemRD;

	c(0)<=IR(5) and IR(4) and IR(3) and IR(2);--branch
	rg: reg1 port map (c(0), lclock,"0",if_id_reset);
	l1: reg7 port map (tmp(7 downto 1),lclock,lreset, t0);
	c(7 downto 6)<=t0(6 downto 5);
	l2: reg5 port map (t0(4 downto 0), lclock,lreset, t1);
	c(2 downto 1)<=t1(1 downto 0);
	l3: reg3 port map (t1( 4 downto 2), lclock, lreset, c(5 downto 3));
  
end logic;
