
import java.sql.SQLException;
import java.util.Vector;
import java.io.*;

import Zql.*;

/**
 * <pre>
 * ZDemo is able to send SQL queries to simple CSV (comma-separated values)
 * files; the CSV syntax used here is very simple:
 *  The 1st line contains the column names
 *  Other lines contain column values (tuples)
 *  Values are separated by commas, so they can't contain commas (it's just
 *  for demo purposes).
 * Example:
 * Create a num.db text file that contains the following:
 *  a,b,c,d,e
 *  1,1,1,1,1
 *  2,2,2,2,2
 *  1,2,3,4,5
 *  5,4,3,2,1
 * You can then run ZDemo, and query it; some legal queries follow:
 *  select * from num;
 *  select a, b from num;
 *  select a+b, c from num;
 *  select * from num where a = 1 or e = 1;
 *  select * from num where a = 1 and b = 1 or e = 1;
 *  select d, e from num where a + b + c <= 3;
 *  select * from num where 3 = a + b + c;
 *  select * from num where a = b or e = d - 1;
 *  select * from num where b ** a <= 2;
 * </pre>
 */
public class t1 {

  public static void main(String args[]) {
    try {

      ZqlParser p = null;

      if(args.length < 1) {
        System.out.println("Reading SQL from stdin (quit; or exit; to quit)");
        p = new ZqlParser(System.in);
      } else {
        p = new ZqlParser(new DataInputStream(new FileInputStream(args[0])));
      }

      // Read all SQL statements from input
      ZStatement st;

      while((st = p.readStatement()) != null) {

      	System.out.println(st.toString()); // Display the statement
		/*  see the contents of each objects */
		if(st instanceof ZQuery)  {  // An SQL query
			Vector sel = ((ZQuery)st).getSelect();
			System.out.println("\n\nselect clause:");
			for(int i=0; i<sel.size(); i++)
			      System.out.println(sel.elementAt(i).toString());

			Vector frm = ((ZQuery)st).getFrom();
			System.out.println("\n\nfrom clause:");
			for(int i=0; i<frm.size(); i++)
			      System.out.println(frm.elementAt(i).toString());

			ZExpression wr = (ZExpression)(((ZQuery)st).getWhere());
			extract_Constant(wr);
    	}
    	else {
		System.out.println("st is not an instance of ZQuery");
		}
	  }  // end of while
    } catch(Exception e) {e.printStackTrace();}
  }


public static void extract_Constant(ZExpression  ze)
	{
		if(ze==null)  // no where clause present
			{System.out.println("no where clause");}
		else  {
			System.out.println("\n\nwhere clause:");
			System.out.println("operator:\n" + ze.getOperator());
			System.out.println("\noperands:");
			Vector opnd = ze.getOperands();
			for(int i=0; i<opnd.size(); i++)	{
			      System.out.println(opnd.elementAt(i).toString());
			      // each element is of type ZConstant ??
			      if(opnd.elementAt(i) instanceof ZConstant) {System.out.println("a ZConstant");}
			      else
			      if(opnd.elementAt(i) instanceof ZExpression) {
					  System.out.println("a ZExpression");
					  extract_Constant((ZExpression)opnd.elementAt(i));
					}
				  else     { System.out.println("neither Zconst nor ZExp"); }
				  // System.out.println(  ((ZConstant)opnd.elementAt(i)).getType()  );
			 }
            System.out.println("\n\nThe entire ZExpression WHERE clause:\n" + ze.toString());
		}

	}



};
