import java.sql.*;
import java.util.*;
import java.io.*;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.ROWID;


public class ReplacementModule
{

private ResultSet result;
private Statement stmt, tempStmt, tempStmtOrd;
private PreparedStatement pstmt;
private Connection conn;
private EstabConn localdb;

private int selectivity;

public ReplacementModule()
{
	// establish connection to the database
		try {
				localdb = new EstabConn();
				conn = localdb.connectdb(new String("orcl"));
				stmt = conn.createStatement (ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);
				tempStmt = conn.createStatement (ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);
				tempStmtOrd = conn.createStatement();
				result = null;
		} catch(SQLException ex)  {
				ex.printStackTrace();
				System.out.println("Error in establishing connection with the database: in class ExecutionModule");
				System.exit(0);
	}


		Properties properties = new Properties();
	    try {
	        properties.load(new FileInputStream("properties.properties"));
	    } catch (IOException e) {	    }

		// query results should be of max what size.
		selectivity = Integer.parseInt(properties.getProperty("selectivity"));

}


public void close()
{
	try {
		stmt.close();
		tempStmt.close();
		tempStmtOrd.close();
		conn.close();
		localdb.close();
		} catch(SQLException ex)  {
			ex.printStackTrace();
			System.out.println("Error in closing connection to the database: in class ExecutionModule ");
			System.exit(0);
		}

}




// we check if we can fit the new query inside the cache
public void checkCache() throws SQLException
{
	// if current query size = 0 , do nothing
	 if(queryInfoStruct.currQuerySize == 0)
		{
			return;

		}
	else if(queryInfoStruct.currQuerySize > selectivity) // currQuerySize ==> we will put a cap on max data transfer, and not the actual size of the query.
		{
			// do not store the query in cache.
			// delete data from appropriate tables
			String s;
			s = "delete from cacheinfo where qid = '" + queryInfoStruct.id + "'";
			tempStmtOrd.executeUpdate(s);
			s = "delete from CT where qid = '" + queryInfoStruct.id + "'";
			tempStmtOrd.executeUpdate(s);


		}
		// if query size will lead to breaching max cache size, run the replacement algorithm
	else if(cacheInfoStruct.currCacheSize + queryInfoStruct.currQuerySize > cacheInfoStruct.maxCacheSize)
		{
			//we need to execute replace Module
			System.out.println("*****   we need to execute replace Module  ***** ");
			replace_algorithm();


		}
	else   // we can easily fit in the new query
		{
			cacheInfoStruct.currCacheSize += queryInfoStruct.currQuerySize ;
			cacheInfoStruct.currQueries += 1 ;


		}


	// update wieghts for each query stored in cache.
	update_cache_table();

	cacheInfoStruct.printStats();
	queryInfoStruct.printStats();
	System.out.println("........................");
	System.out.println("........................");

}


public void replace_algorithm() throws SQLException
{

	// lets use LRU first
	// query with lowest final score is removed

	// assign a weight to the query.
	// compare weights amongsts all queries in cache
	// decide a replacement victim

	// update cacheInfoStruct


	// we first calculate final score
	// query with lowest final score is removed

	String QID;

	do {

	tempStmt = conn.createStatement();
	tempStmt = conn.createStatement();

	String s = "select qid from cacheinfo where finalscore = (select min(finalscore) from cacheinfo)";
	ResultSet t1 = tempStmt.executeQuery(s);
	t1.next();


	QID = t1.getString(1);
	System.out.println(QID);
	//t1.close();

	// delete data from appropriate tables
	s = "delete from cacheinfo where qid = '" + QID + "'";
	tempStmtOrd.executeUpdate(s);


	s = "delete from CT where qid = '" + QID + "'";
	tempStmtOrd.executeUpdate(s);
	//tempStmtOrd.close();


	// currCacheSize is the number of unique tuples present in CT table
	s = "select count(distinct(rid)) from CT" ;
	t1 = tempStmt.executeQuery(s);
	t1.next();

	cacheInfoStruct.currCacheSize =  t1.getInt(1);
	cacheInfoStruct.currQueries = cacheInfoStruct.currQueries - 1;
	//t1.close();

	System.out.println("Query deleted : " + QID);
	System.out.println("New cacheSize : " + cacheInfoStruct.currCacheSize);
	} while (cacheInfoStruct.currCacheSize + queryInfoStruct.currQuerySize > cacheInfoStruct.maxCacheSize);


}


public void update_cache_table() throws SQLException
{

	int finalscore = queryInfoStruct.id;

	pstmt = conn.prepareStatement("insert into cacheinfo(QID,string,freshness,qsize,currX,currY,finalscore)  values(?,?,?,?,?,?,?)");
	pstmt.setInt(1,queryInfoStruct.id);
	pstmt.setObject(2,queryInfoStruct.currQueryString);
	pstmt.setInt(3,queryInfoStruct.freshness);  // freshness count starts with 0. for all other queries it is incremented.
	pstmt.setInt(4,queryInfoStruct.currQuerySize);
	pstmt.setInt(5,queryInfoStruct.currX); // this needs to be changed
	pstmt.setInt(6,queryInfoStruct.currY); //
	pstmt.setInt(7,finalscore);
	pstmt.addBatch();
	pstmt.executeBatch();

}




/*  we may use this later
	pstmt = conn.prepareStatement("insert into queryinfo(ID,string,freshness,qsize,currX,currY)  values(?,?,?,?,?,?)");
	pstmt.setInt(1,QIDStart);
	pstmt.setObject(2,sSql);
	pstmt.setInt(3,0);  // freshness count starts with 0. for all other queries it is incremented.
	pstmt.setInt(4,rowCount);
	pstmt.setInt(5,0); // this needs to be changed
	pstmt.setInt(6,0); //
	pstmt.addBatch();
	pstmt.executeBatch();
	*/




}