import java.sql.*;

public class RemoteProcessing
{


/**
*  Input : The remainder query.
*  Connect to the remote database.
*  execute the remainder query against the database and fetch the results.
*  Output : The ResultSet
*/


private ResultSet result;
private Statement stmt;
private Connection conn;
private EstabConn remotedb;

public RemoteProcessing()
{
	try {
			// specifiy the database name
			remotedb = new EstabConn();
			conn = remotedb.connectdb(new String("orcl"));
			stmt = conn.createStatement ();
	} catch(SQLException ex)  {
			ex.printStackTrace();
			System.out.println("Error in establishing connection with the database: in class RemoteProcessing");
			System.exit(0);
	}

}


public ResultSet executeRemainder(String sqlQuery)
{
	if(sqlQuery == null)
		{
			System.out.println("Remainder Query is null: in class RemoteProcessing");
			return null;
		}
	else   		/* get results from the database */
		{
			try {
		    // Execute the query
			result = stmt.executeQuery (sqlQuery);
			System.out.println(sqlQuery.toString() + "... Query executed in RemoteProcessing")	;
			return result;
			} catch(SQLException ex)  {
				ex.printStackTrace();
				System.out.println("Error in executing the sqlQuery: in RemoteProcessing");
			}

			System.out.println("returning null ResultSet");
			return null;
		}

}


public void close()
{
	try {
	result.close();
	stmt.close();
	conn.close();
	remotedb.close();
	} catch(SQLException ex)  {
		ex.printStackTrace();
		System.out.println("Error in closing connection to the database: in class RemoteProcessing");
		System.exit(0);
	}

}





}

