import Zql.*;
import java.util.*;

public class QueryObject
{

private int id;
private ZQuery zquery;
private String sqlquery;
private HashSet signature;
private Vector predicates;  // a vector of Atoms
private Vector negatedPredicates;



public QueryObject(ZQuery zq)
{
	this.zquery = zq;
	this.sqlquery = zq.toString();
	this.id = Auxiliary.getQueryID();  // get a unique ID from Auxiliary class
	createSignature();
	createPredicates();
	createNegatedPredicates();
}


public int getId() {return id;}
public ZQuery getZQuery() {return zquery;}
public String getSqlquery() {return sqlquery;}
public Vector getPredicates() {return predicates;}
public Vector getNegatedPredicates() {return negatedPredicates;}
public HashSet getSignature() {return signature;}



public void printQueryObject()
{
	System.out.println();
	System.out.println("SQL query: " + this.getSqlquery());
	System.out.println("Query ID: " + this.getId());
	System.out.println("Signature: " + this.getSignature().toString());

	System.out.println("Predicates: ");
	 Vector pred = this.getPredicates();
	 for(int i=0; i<pred.size(); i++)
	 	System.out.println(((Atom)pred.get(i)).toString());

	System.out.println("Negated Predicates: ");
	 Vector neg = this.getNegatedPredicates();
	 for(int i=0; i<neg.size(); i++)
	 	System.out.println(((Atom)neg.get(i)).toString());

}


/* create a HashSet consisting of attribute(from the predicates) and relation names present in a query */
private void createSignature()
{
	signature = new HashSet();

	ZExpression wr = (ZExpression)(((ZQuery)zquery).getWhere());
	extract_Constant(wr);

	Vector frm = zquery.getFrom();
	for(int i=0; i<frm.size(); i++)
		signature.add(new String( frm.elementAt(i).toString() ));

}


private void extract_Constant(ZExpression  ze)
	{
		if(ze==null)  // no where clause present
			{//System.out.println("no where clause");

			}
		else
			{
				Vector opnd = ze.getOperands();
				for(int i=0; i<opnd.size(); i++)	{
					  //System.out.println(opnd.elementAt(i).toString());
					  if(opnd.elementAt(i) instanceof ZConstant)
						{ //System.out.println("a ZConstant");
						 if( ((ZConstant)opnd.elementAt(i)).getType()==ZConstant.COLUMNNAME  ) // add to the hash set if the ZConstant is of type COLUMN
							signature.add(((ZConstant)opnd.elementAt(i)).getValue()); // THIS IS THE KEY STATEMENT
						}
					  else
					  if(opnd.elementAt(i) instanceof ZExpression) {
						 // System.out.println("a ZExpression");
						  extract_Constant((ZExpression)opnd.elementAt(i));
						}
					  else     { //System.out.println("neither Zconst nor ZExp");
						}
					  // System.out.println(  ((ZConstant)opnd.elementAt(i)).getType()  );
				 }
				//System.out.println("\n\nThe entire ZExpression WHERE clause:\n" + ze.toString());
			}

	}


private void createPredicates()
{

predicates = new Vector();

ZExpression wr = (ZExpression)(((ZQuery)zquery).getWhere());
extract_Predicates(wr);


}


private void extract_Predicates(ZExpression  ze)
{
	if(ze==null)  // no where clause present
		{
			predicates = null;
		}
	else
		{
			Vector opnd = ze.getOperands();
			String optr = ze.getOperator();
			for(int i=0; i<opnd.size(); i++)
			{

			  if( (opnd.elementAt(i) instanceof ZExpression) )
			  	{
			  		extract_Predicates((ZExpression)opnd.elementAt(i));
				}
			  else
			  if( (opnd.elementAt(i) instanceof ZConstant) && (opnd.elementAt(i+1) instanceof ZConstant))
				{

// check whether constant is column name or constant
// the problem is we dont know whether the second operand is a constant (x op c) or a variable (x op y)
					ZConstant ztemp1 = (ZConstant)opnd.elementAt(i);
					ZConstant ztemp2 = (ZConstant)opnd.elementAt(i+1);
					Atom at = new Atom();

					if(ztemp2.getType() == ZConstant.COLUMNNAME) // is a column
						{
							at = new Atom(ztemp1.getValue(),optr,ztemp2.getValue());// CREATE AN APPROPRIATE ATOM
						}
					else
					if(ztemp2.getType() == ZConstant.NUMBER) // is a constant
						{
							int ztemp2int = Integer.parseInt(ztemp2.getValue());
							at = new Atom(ztemp1.getValue(),optr,ztemp2int);
						}

					predicates.add(at);
					i++; // important step . we increment i , because we take care of 2 constants here
				}
			  else
				{
					System.out.println("Something is fishy here: QueryObject:createPredicates()");
					// one zconstant and other zexpression ... case not handled here
				}
			}

		}

}

private void createNegatedPredicates()
{
  negatedPredicates = new Vector();
  if (predicates == null)
  	negatedPredicates = null;
  else
  {
	  Atom at;
	  for(int i=0; i<predicates.size(); i++)
	  {
		at = (Atom) predicates.get(i);
		at = Atom.getComplement(at);
		negatedPredicates.add(i,at);
	  }

  }

}



}