import java.util.Vector;
import Zql.*;


public class QueryNode
{

private String relation;  // single relation
private Vector attributes;
private Vector localPredicates;  // vector of ZExpression ( operator + operands )


private Vector associativePredicate;
private Vector associativeOperator;

// constructor
public QueryNode(String relation)
{
	this.relation = relation;
	attributes = new Vector();
	localPredicates = new Vector();
}


public void   setRelation(String relation) { this.relation = relation; }
public String getRelation() { return relation; }

public void   setAttributes(Vector attributes) { this.attributes = attributes; }
public Vector getAttributes() { return attributes; }

public void   addAttribute(String attribute) { (this.attributes).add(attribute); }


public void   setLocalPredicates(Vector localPredicates) { this.localPredicates = localPredicates; }
public Vector getLocalPredicates() { return localPredicates; }

public void   addLocalPredicate(ZExpression localPredicate) { (this.localPredicates).add(localPredicate); }

public Vector getAssociativePredicates() { return associativePredicate; }

public Vector getAssociativeOperator() { return associativeOperator; }

public void printNode()
{
	System.out.println("Node details are as follows:");
	System.out.println("Relation name:\n" + relation );
	System.out.println("Attributes: ");
	for (int i=0;i<attributes.size();i++)
		System.out.println(attributes.get(i));
	System.out.println("Local Predicates: ");
	for (int i=0;i<localPredicates.size();i++)
		System.out.println(localPredicates.get(i));
}

public QueryNode createAssociativeStructure(QueryNode in)
{

	associativePredicate = new Vector();
	associativeOperator  = new Vector();
	for(int i=0;i<localPredicates.size();i++)
		{
			ZExpression ze = (ZExpression) localPredicates.get(i);
			Vector opnd = ze.getOperands();
			ZConstant zc1 = (ZConstant)opnd.elementAt(0);
			ZConstant zc2 = (ZConstant)opnd.elementAt(1);
			if( (zc1.getType()==ZConstant.COLUMNNAME) &&  (zc2.getType()==ZConstant.COLUMNNAME) )
				associativePredicate.add(new String("2" + "#" + zc1.getValue().toString()  + "#" + zc2.getValue().toString() )  	);
			else
			if( (zc1.getType()==ZConstant.COLUMNNAME) )
				associativePredicate.add(new String("1" + "#" + zc1.getValue().toString()  + "#" + zc2.getValue().toString() )  	);
			else
			if( (zc2.getType()==ZConstant.COLUMNNAME) )
				associativePredicate.add(new String("0" + "#" + zc1.getValue().toString()  + "#" + zc2.getValue().toString() )  	);
			else
			 { System.out.println("this case is not handled"); System.exit(0); }

			associativeOperator.add(new String(ze.getOperator()));
		}


	return in;
}


}