import Zql.*;
import java.util.*;

/*
 * QueryGraph is the complete representaion of a query
 * It consists of uniquer ID, a vector of nodes, egdes and globla predicates
 */


public class QueryGraph
{

private int QGID;
private Vector nodeList;  // a vector of type "QueryNode"
private Vector edgeList;  // a vector of type "Edge"
private Vector globalPredicates; //  a vector of type ZExpression
private ZQuery query;

/* we create a temporary hashtable of relation name and its QueryNode */
/* we use this hashtable to fill in the values in the QueryNode*/
/* finally we iterate over the hashtable and store the QueryNodes in the nodeList Vector */
Hashtable temporary;


public Vector getNodeList()  { return nodeList; }
public Vector getEdgeList()  { return edgeList; }
public Vector getGlobalPredicates()  { return globalPredicates; }
public ZQuery getZQuery()  { return query; }

public Vector getLocalPredicates()  // local predicates are stored in the QueryNode
{
	Vector localPredicates = new Vector();
	Vector temp;
	for(int i=0;i<nodeList.size();i++)
	{
		temp = ((QueryNode)(nodeList.get(i))).getLocalPredicates();
		localPredicates.addAll(temp);
	}
	return localPredicates;
}



public void printGraph()
{

	System.out.println("Query Graph details are as follows: QGID:" + QGID);
	for(int i=0;i<nodeList.size();i++)
	{
		((QueryNode)(nodeList.get(i))).printNode();


	}

	System.out.println("Global Predicates are:");
	for(int i=0;i<globalPredicates.size();i++)
	{
		System.out.println((globalPredicates.get(i)).toString());
	}

	/*  GET THIS WORKING -------------------------

	for(int i=0;i<edgeList.size();i++)
	{
		((Edge)(edgeList.get(i))).printEdge();

	}


	*/


}


// WHY DO WE NEED EDGES ????



/* create a QueryNode from ZQuery object with the relation name given  */
public void createNode(Integer id, ZQuery zq)
{

temporary = new Hashtable();
String relation;
globalPredicates = new Vector();

/* set the QGID */
this.QGID = id.intValue();


/* store the original zquery */
this.query = zq;



/* number of QueryNodes will depend on the number of relations present in the SQL query */
Vector frm = zq.getFrom();
for(int i=0; i<frm.size(); i++)
	{
		relation = (frm.get(i)).toString();
		temporary.put(relation,new QueryNode(relation));
	}


/* we will need the auxilary structure Auxillary.lookuptable
 to determine which attributes belong to which particular relation */

QueryNode qn;  // it will be assigned to a QueryNode from the temporary hashtable
Vector sel = zq.getSelect();
for(int i=0; i<sel.size(); i++)
	{
		relation = (String) Auxillary.lookuptable.get( sel.elementAt(i).toString() );
		qn = (QueryNode) temporary.remove(relation);
		qn.addAttribute( (sel.elementAt(i)).toString() );
		temporary.put(relation,qn);
	}


/* now we need to fill the local predicates as well as the global predicates */
/*  if both attributes belong to the same relation, add the predicate to localPredicates */
ZExpression wr = (ZExpression)(zq.getWhere()); // get the where clause
extract_Constant(wr);


/* we create an associative predicate structure for   */
/* now we need to store the QueryNodes in nodeList */
Vector after = new Vector(temporary.values());

nodeList = new Vector();
for(int i=0;i<after.size(); i++)
	nodeList.add(  ((QueryNode)after.get(i)).createAssociativeStructure((QueryNode)after.get(i)));


}




public void extract_Constant(ZExpression  ze)
{
QueryNode qn;

if(ze==null)  // no where clause present
	{
		System.out.println("no where clause");
		// do something here.. returning null or somethiung
	}
else
	{

		Vector opnd = ze.getOperands();
		if( (opnd.elementAt(0) instanceof ZConstant) && (opnd.elementAt(1) instanceof ZConstant) )
		      	{
					// CHECK WHETHER THESE ARE PRESENT IN THE RELATION

					ZConstant zc1 = (ZConstant)opnd.elementAt(0);
					ZConstant zc2 = (ZConstant)opnd.elementAt(1);

					if( (zc1.getType()==ZConstant.COLUMNNAME) &&  (zc2.getType()==ZConstant.COLUMNNAME) )
					{
						if(	Auxillary.lookuptable.get( zc1.getValue().toString()) == Auxillary.lookuptable.get(zc2.getValue().toString() ))
						{
							String relation = (String) Auxillary.lookuptable.get( zc1.getValue().toString() );
							qn = (QueryNode) temporary.remove(relation);
							qn.addLocalPredicate(ze);
							temporary.put(relation,qn);
						}
						else
						{
							// both operands are from different tables
							globalPredicates.add(ze);
						}

					}
					else
					if(zc1.getType()==ZConstant.COLUMNNAME)
					{
						String relation = (String) Auxillary.lookuptable.get( zc1.getValue().toString());
						qn = (QueryNode) temporary.remove(relation);
						qn.addLocalPredicate(ze);
						temporary.put(relation,qn);

					}
					else
					if(zc2.getType()==ZConstant.COLUMNNAME)
					{
						/*HAVING SECOND OPERAND AS A COLUMN NAME WILL RESULT IN ERROR IN
						SOLVER DURING DIRECT ELIMINATION */
						String relation = (String) Auxillary.lookuptable.get(zc2.getValue().toString());
						qn = (QueryNode) temporary.remove(relation);
						qn.addLocalPredicate(ze);
						temporary.put(relation,qn);
					}
					else
					{
						System.out.println(" both are constants: this case not handled ");
					}

		      	}
		else
		if( (opnd.elementAt(0) instanceof ZExpression) && (opnd.elementAt(1) instanceof ZExpression) )
		        {
				  extract_Constant((ZExpression)opnd.elementAt(0));
				  extract_Constant((ZExpression)opnd.elementAt(1));
				}
		else
				{
					System.out.println("neither both Zconst nor both ZExp");
					System.out.println("this case is not handled");
				}
	 }
}
}