import java.util.*;
import java.io.*;

public class QueryGenerator
{

static Vector LAqueryset;
static Vector LDqueryset;
static Vector NLRqueryset;
static Vector Fqueryset;
static TreeMap TimeLoc;

public static int groups;
public static int overlap;
public static int iQueries;

public Location lt;

public QueryGenerator()
{
	// initial x,y coordinates are 0,0
	lt = new Location(0,0);

	LAqueryset = new Vector();
	LDqueryset = new Vector();
	NLRqueryset = new Vector();
	Fqueryset = new Vector();
	TimeLoc = new TreeMap();
	String str = new String();

	ReadFile rf = new ReadFile("LAqueryset.txt");

	while( (str=rf.readLine()) != null )
	{
	    LAqueryset.add(str)  ;
	}
	rf.close();


	rf = new ReadFile("LDqueryset.txt");
	while( (str=rf.readLine()) != null )
	{
	    LDqueryset.add(str)  ;
	}
	rf.close();


	rf = new ReadFile("NLRqueryset.txt");
	while( (str=rf.readLine()) != null )
	{
		NLRqueryset.add(str)  ;
	}
	rf.close();

// file format
// t x y
// rf = new ReadFile("TimeLoc.txt");
// create a location object .
// create a TreeMap instance of the time and location object.

	StringTokenizer st;
	Integer time;
	Location tl = new Location();

	rf = new ReadFile("TimeLoc.txt");
	while( (str=rf.readLine()) != null )
	{
		st = new StringTokenizer(str, " ", false);
		time = new Integer(Integer.parseInt(st.nextToken()));
		tl = new Location(Integer.parseInt(st.nextToken()),Integer.parseInt(st.nextToken()));
		TimeLoc.put(time,tl); // add time and location to TreeMap

	}
	//System.out.println(TimeLoc);
	rf.close();


// load all properties from the properties file

	Properties properties = new Properties();
    try {
        properties.load(new FileInputStream("properties.properties"));
    } catch (IOException e) {
    }

	iQueries = Integer.parseInt(properties.getProperty("iQueries"));
	groups = Integer.parseInt(properties.getProperty("groups"));
	overlap = Integer.parseInt(properties.getProperty("overlap"));  // every



}


public static void main(String args[])
{

QueryGenerator gen = new QueryGenerator();
// read queries from the three data sets in a round robin fashion.
// if you read from LDqueryset, you will have to map the realtive address to an absolute scale
//Random rnd = new Random();


Iterator iterLA = LAqueryset.iterator();
Iterator iterLD = LDqueryset.iterator();
Iterator iterNLR = NLRqueryset.iterator();

int setCount = 0;
while (setCount < iQueries) // number of queries to be executed
{
	if(iterLD.hasNext())
		// query has to be translated first
		{ Fqueryset.add( gen.translate(iterLD.next(), iterLD.next()) ); setCount++; }

	if(iterLA.hasNext())
		{ Fqueryset.add(iterLA.next());  setCount++; }

	if(iterNLR.hasNext())
		{ Fqueryset.add(iterNLR.next()); setCount++; }


}


gen.writeToFile("GeneratedQueryLoad.txt",Fqueryset);

}


public void writeToFile(String filename, Vector x)
{
	try {

				FileWriter fw = new FileWriter(filename,false);

			    for (int i=0;i<x.size();i++)
				{
				    fw.write("" + x.get(i) + "\n");
				}

			    fw.close();

			}  catch (IOException ioe) { System.out.println("File IO Error"); }




}

public Object translate(Object part1, Object part2)
{

int x,y;

// Location Dependent query should follow this format
// select * from table where time 5
// we replace "time 5" by its new location at the new time

// select * from table where radius 5 -- we'll deal with this right now
// we replace "radius 5" by its new location...
// the new query becomes :
// select * from table where x < 50 and x > 40 and y < 20 and y > 10
// for the moment we can deal with either x or y at a time


// LETS HAVE A SEPARATE FORMAT FOR THE LD QUERIES.  TWO LINES FOR THE QUERY

// we separate the last token
StringTokenizer st1 = new StringTokenizer(part2.toString()," ",false);
String sType = new String(st1.nextToken());

if (sType.equals("time"))
{
	Location temp = (Location) TimeLoc.get(new Integer(Integer.parseInt(st1.nextToken())));
	if (temp == null)
	{
		//System.out.println("entered if " + lt.getX() + " " + lt.getY() );
		// this is to ensure that, for every time instance there is a corresponding x and y location attributes
		// if no match is found, we use the previous x,y values.
		x = lt.getX();
		y = lt.getY();
	}
	else
	{
		lt = new Location(temp.getX(),temp.getY());
		//System.out.println("entered ELSE " + lt.getX() + " " + lt.getY() );
		x = lt.getX();
		y = lt.getY();
	}
	StringBuffer sbf = new StringBuffer(part1.toString());
	sbf.append(" x = ").append(x).append(" and y = ").append(y);
	return sbf.toString();
}
else if (sType.equals("radius"))
{
	return new Object();

}
else
{
	return new Object();
}


}




}




class Location
{

private int x;
private int y;

public Location() {}
public Location(int x, int y) { this.x = x; this.y = y;}

public int getX() {return x;}
public int getY() {return y;}
public void setX(int x) {this.x = x;}
public void setY(int y) {this.y = y;}

public String toString() { return new String("X="+x+"Y="+y); }

}