import java.util.Vector;
import java.sql.*;
import Zql.ZQuery;
import Zql.ZExpression;

public class LocalProcessing
{


/**
*  Get the modified query and the answerby query.
*  Connect to the local database.
*  fire the answerby query to obtain results.
*  fire the modified query against the results obtained from the previous query
*/


private ZQuery modified_=null;
private ZQuery answerby_=null;
private String sqlQuery=null;

private ResultSet result=null;
private Statement stmt=null;
private Connection conn=null;
private EstabConn localdb=null;


public LocalProcessing()
{
	try {
			// specifiy the database name
			localdb = new EstabConn();
			conn = localdb.connectdb(new String("orcl"));
			stmt = conn.createStatement ();
	} catch(SQLException ex)  {
			ex.printStackTrace();
			System.out.println("Error in establishing connection with the database: in class LocalProcessing");
			System.exit(0);
	}

}


public void close()
{
	try {
	//result.close();  this is giving problems while closing ... hence commented
	stmt.close();
	conn.close();
	localdb.close();
	} catch(SQLException ex)  {
		ex.printStackTrace();
		System.out.println("Error in closing connection to the database: in class LocalProcessing");
		System.exit(0);
	}
}



public ResultSet executeModifiedLocal(ZQuery modified_, ZQuery answerby_)
{

	this.modified_ = modified_;
	this.answerby_ = answerby_;
	sqlQuery = createQuery();

	if(sqlQuery == null)
		{
			System.out.println("Modified Query is null: in class LocalProcessing");
			return null;
		}
	else   		/* get results from the database */
		{
			try {
		    // Execute the query
			result = stmt.executeQuery (sqlQuery);
			System.out.println(sqlQuery.toString() + "... Query executed in LocalProcessing")	;
			return result;
			} catch(SQLException ex)  {
				ex.printStackTrace();
				System.out.println("Error in executing the sqlQuery: in LocalProcessing");
			}

			System.out.println("returning null ResultSet");
			return null;
		}

}



/**
 *  creates a query of the following format
 *  SELECT attr(Q_modified) FROM result(Q_answerby) WHERE cond(Q_modified)
 *
 */
public String createQuery()
{
	/**
	 *  create the attribute list from Q_modified
	 */
	Vector sel = ((ZQuery)modified_).getSelect();
	// we need to prepend the second column with "_,"  (space and comma)
	StringBuffer temp = new StringBuffer(sel.elementAt(0).toString());
	for(int i=1; i<sel.size(); i++)
	  (temp.append(", ")).append(sel.elementAt(i).toString());
	String attrlist = temp.toString();


	/**
	 *  get the WHERE clause of the Q_modified query
	 */
	ZExpression wr = (ZExpression)(((ZQuery)modified_).getWhere());
	String condlist = wr.toString();
	// in this case we can obtain the string representation of the WHERE clause directly
	// by using toString() method of class ZExpression.


	/**
	 *  get the FROM clause from Q_answerby query
	 *  this clause will consist of resultset obtained by executing answerby query.
	 */
	String qansData = "(" + answerby_.toString() + ")" ;
	// in this case we can obtain a query representation of ZQuery directly using its toString() method.

	// final query string
	String qry = new String("SELECT" + " " + attrlist + " " + "FROM" + " " + qansData + " " + "WHERE " + " " + condlist );
	return qry;
}



}
