import java.util.Vector;
import java.io.*;
import Zql.*;
import java.sql.*;

public class Composition

{

private LocalProcessing lp;
private RemoteProcessing rp;
private PopulateCache ppc;
private ResultSet rs;

/* Initialize all the data structures and establish database connections */
public Composition()
{
// Auxiliary structures are initialized here
	Auxiliary.init();
	Cache.init();

// database connections are established here
	lp = new LocalProcessing();
	rp = new RemoteProcessing();
	ppc = new PopulateCache();
	rs=null;
}

public void close() throws SQLException
{
	rs.close();
	rp.close();
	lp.close();
	ppc.close();
}

public void processQuery(ZQuery zquery)
{

	Solver s = new Solver();
	QueryObject oq = new QueryObject(zquery,Auxiliary.getQueryID());

	if(s.isQuerySatisfiable(oq))   // partial or total
		{
			rs = lp.executeModifiedLocal(s.getModified(),s.getAnswerby());  // send this result to the user
			//ResultDisplay.display(rs);

			if(s.getRemainder()==null) 	System.out.println("Remainder Query is null: in class Composition");
			else
			rs = rp.executeRemainder((s.getRemainder()).toString()); // this result is for postprocessing
			// Solver returns ZQuery objects only . hence toString()

			//ResultDisplay.display(rs);
			//postProcessing(zquery,rs); WILL DECIDE LATER WHAT TO STORE
		}
	else   // unsatisfiable and hence send the original user query to the remote database
		{
			rs = rp.executeRemainder((s.getRemainder()).toString());  // in this case the remainder query == user query
			postProcessing(s.getRemainder(),rs);
			//ResultDisplay.display(rs);
		}

}

public void postProcessing(ZQuery zq, ResultSet rs)
{
	/* store the queries and the data in the database */
	ppc.populate(rs,zq.toString(),zq);

	/* update the local data structures */
	Auxiliary.updateDataStructures(zq);
}



/*
 *  The Main program stats from here.
 *  Read SQL statements from a file, and process them one at a time
 */
public static void main(String args[])
{


try {

      ZqlParser p = null;

      if(args.length < 1)
      	{
      	  System.out.println("Reading SQL from stdin (quit; or exit; to quit)");
      	  p = new ZqlParser(System.in);
      	}
      else
      	{
      	  p = new ZqlParser(new DataInputStream(new FileInputStream(args[0])));
      	}


	Composition c = new Composition();

      // Read all SQL statements from input
      ZStatement st;
      while((st = p.readStatement()) != null) {
        //System.out.println(st.toString() + " in class Composition.java "); // Display the statement

		if(st instanceof ZQuery)    // An SQL query
			{
				c.processQuery((ZQuery)st);
			}
		else
			System.out.println("invalid SQL syntax : in class Composition");  // invalid SQL syntax
		//  you will probably never reach here, since ZqlParser takes care of SQL syntax

	  }    // end of while loop

	c.close();  // close all open connections

    } catch(Exception e) {e.printStackTrace();}

}



}
