import Zql.*;
import java.util.*;

public class Cache
{

private static Vector signatureVector;
public static Vector queryIdVector;
public static Vector negatedQueryPredicates;
public static Vector queryObjectVector;


public static void init()
{
	signatureVector = new Vector();  // a vector of HashSets of attributes and  columns
	queryIdVector = new Vector();   // corresponding vector of Integer query ID's
	negatedQueryPredicates = new Vector();   // a corresponding vector of negated predicates stored in cache
	queryObjectVector = new Vector(); // will hold all cached query Objects
}


public static void add(QueryObject ob)
{
	Cache.queryIdVector.add(new Integer(ob.getId()));
	Cache.signatureVector.add(ob.getSignature());
	Cache.negatedQueryPredicates.add(ob.getNegatedPredicates());
	Cache.queryObjectVector.add(ob);
}


public static void remove(QueryObject ob)
{
	// first we have to find this query's index and then remove it from all the related structures.
	int x = getIndex(ob.getId());
	Cache.queryIdVector.remove(x);
	Cache.signatureVector.remove(x);
	Cache.negatedQueryPredicates.remove(x);
	Cache.queryObjectVector.remove(x);

}


public static void merge(Vector vtr)
{

}

public static void split(QueryObject ob /* and some other info required */)
{

}

/* This method checks whether the new query's attributes + relations match any of the existing temporary
 * It match is found, the method returns a vector of QGID's of those temporaries.
 * Else it returns an empty vector
 * we quickly discard temporaries whose relations and attributes do not match with the query
 */
public static Vector signatureMatch(QueryObject ob)
{
	HashSet hs = ob.getSignature();
	if(hs.size()==0) { System.out.println("Null HashSet : some problem"); return null; }
	if(Cache.signatureVector.size()==0)
		{   //System.out.println("Empty Signature table");
			return null;
		}

	Vector retVector = new Vector();

	for(int i=0;i<Cache.signatureVector.size();i++)
	{
		//DO WE NEED AN EXACT MATCH ????
		if( ((HashSet)Cache.signatureVector.get(i)).containsAll(hs) &&  hs.containsAll((HashSet)Cache.signatureVector.get(i))   )
				retVector.add(Cache.queryIdVector.get(i));
				//
				//PROBLEM  Q:a  T:a,b  --> T has stricter constraints and Q may not be answered totally
	}

	return retVector;
}

/* this method will find the query index in the vector */
public static int getIndex(int queryId)
{
	for(int i=0;i<queryIdVector.size();i++)
		{
			if (queryId == ((Integer)queryIdVector.get(i)).intValue())
			return i;
		}

	System.out.println("Error: index not found. In class Cache");
	return 0;
}



}