import java.util.Vector;
import Zql.ZQuery;
import Zql.ZExpression;
import Zql.ZExp;
import Zql.ZConstant;

  /**
   * This class provides 2 SQL queries, the modified user query, and the query whose resultset provides
   * answer to the modified query.
   * The format of the SQL query is a ZQuery object
   */
public class BlackBox
{

// query that is rewritten
private ZQuery qrewrite;

// query that contains answers to the rewritten query
private ZQuery qans;


  /**
   * creates a query rewrite
   */
public void setRewrite(ZQuery zq) { qrewrite = zq; }

  /**
   * creates a query whose resultset holds answer to the rewritten query
   */
public void setAns(ZQuery an) { qans = an; }

  /**
   * Gets the rewritten query whose answer has to be obtained
   * @return A ZQuery object that contains various clauses of the SQL statement
   */
public ZQuery getRewrite() { return qrewrite; }

  /**
   * Gets the query whose resultset contains partial answer to the incoming(modified) query
   * @return A ZQuery object that contains various clauses of the SQL statement
   */
public ZQuery getAns() { return qans; }


/**
*  A temporary constructor that will create 2 concrete ZQuery objects.
* In reality, these objects will be obtained from the theorem solver.
*/
public BlackBox()
{
// qrewrite: SELECT name, age FROM d  WHERE age > 25
qrewrite = new ZQuery();

//SELECT
Vector sel = new Vector();
sel.addElement(new String("NAME"));
sel.addElement(new String("AGE"));
qrewrite.addSelect(sel);

//FROM
Vector frm = new Vector();
frm.add(new String("D"));
qrewrite.addFrom(frm);

//WHERE
// first create a ZExpression consisting of a string operator and a vector of 2 or more operands
// objects contained in the vector are referenced by ZExp and in reality are of type ZConstant

ZExpression whr = new ZExpression(new String(">"));

ZExp o1 = new ZConstant(new String("AGE"), ZConstant.COLUMNNAME);
ZExp o2 = new ZConstant(new String("25"), ZConstant.NUMBER);
Vector opnd = new Vector();
opnd.addElement(o1);
opnd.addElement(o2);
whr.setOperands(opnd);

//qrewrite.addWhere(whr);  // addWhere accepts objects of type ZExp -- and whr (ZExpression) implements ZExp


// create one more ZQuery :    qans
// qans: SELECT name, age FROM d  WHERE age > 10
qans = new ZQuery();

//SELECT & FROM --- same vectors
qans.addSelect(sel);
qans.addFrom(frm);

//WHERE
// first create a ZExpression consisting of a string operator and a vector of 2 or more operands
// objects contained in the vector are referenced by ZExp and in reality are of type ZConstant

ZExpression whr2 = new ZExpression(new String(">"));

ZExp o12 = new ZConstant(new String("SEx"), ZConstant.COLUMNNAME);
ZExp o22 = new ZConstant(new String("10"), ZConstant.NUMBER);
Vector opnd2 = new Vector();
opnd2.addElement(o12);
opnd2.addElement(o22);
whr2.setOperands(opnd2);

qans.addWhere(whr2);  // addWhere accepts objects of type ZExp -- and whr (ZExpression) implements ZExp

ZExpression fl = new ZExpression(new String("!!"));
Vector ff = new Vector();
ff.addElement(whr);
ff.addElement(whr2);
fl.setOperands(ff);
qrewrite.addWhere(fl);

}

/*
public static void main(String args[])
{
	BlackBox bx = new BlackBox();
	System.out.println( ((ZQuery)(bx.getRewrite())).toString() );
	System.out.println( ((ZQuery)(bx.getAns())).toString() );
}
*/






}
