import java.util.*;

/*
 *  an Atom is of the form (x op c)
 *  an Atom is of the form (x op y)
 *  where x,y are attributes (variables) and c is a constant
 *  op is comparison operator of the form (=,<,<=,>,>=)
 *  operand1 has the range [left,right]
 *  NOTE: operand2 does not have a range: we need to create a new Atom object for that
 *  NOTE2: there is no way of differentiating between type1 and type2 atoms,
 *		   except possible cheching the operand2 string for null value
 */
public class Atom

{

private String operand1;
private String operand2;
private int constant;
private String operator;

/* range of the operand1 */
// default range [0 1000]
private int left;
private int right;

public String getOperand1() {return operand1;}
public String getOperand2() {return operand2;}
public String getOperator() {return operator;}
public int getConstant() {return constant;}
public int getLeft() {return left;}
public int getRight() {return right;}

public void setOperand1(String operand1) {this.operand1 = operand1;}
public void setOperand2(String operand2) {this.operand2 = operand2;}
public void setOperator(String operator) {this.operator = operator;}
public void setRange(int left, int right) {this.left = left; this.right = right;}
// we will have to set both the left and right bounds at the same time.

public Atom() {}

public Atom(Atom in) // copy constructor
{
	this.operand1 = in.getOperand1();
	this.operand2 = in.getOperand2();
	this.operator = in.getOperator();
	this.constant = in.getConstant();
	this.setRange(in.getLeft(),in.getRight());
}

public Atom(String operand1, String operator, int constant)
{
	this.operand1 = operand1;
	this.operator = operator;
	this.constant = constant;

	//default values
	this.left = 0; this.right = 1000;
	this.operand2 = null;

	}

public Atom(String operand1, String operator, int constant, int left, int right)
{
	this.operand1 = operand1;
	this.operator = operator;
	this.constant = constant;
	this.left = left;
	this.right = right;
	this.operand2 = null;
}

// type2  x op y
public Atom(String operand1, String operator, String operand2)
{
	this.operand1 = operand1;
	this.operator = operator;
	this.operand2 = operand2;
	this.left = 0;
	this.right = 1000;
	// default value
	this.constant = -1;  // could cause problems ?

}


public String toString()
{
	String str;
	if(operand2 != null)
		str = "(" + operand1 + " " + operator + " " + operand2 + ")";
	else
		str = "(" + operand1 + " " + operator + " " + constant + ")";

	// we do not print the range     + "  [" + left + " " + right + "]"

	return str;
}

/*returns the complement of the atom */
public static Atom getComplement(Atom in)
{
	/*
		61		int e = (new String("=")).hashCode();
		60		int l = (new String("<")).hashCode();
		1921	int le = (new String("<=")).hashCode();
		62		int g = (new String(">")).hashCode();
		1983	int ge = (new String(">=")).hashCode();
		1922	int ne = (new String("<>")).hashCode();
		1444	int n = (new String("-1")).hashCode();
	*/

	Atom out = new Atom(in);

	String e = (new String("="));
	String l = (new String("<"));
	String le = (new String("<="));
	String g = (new String(">"));
	String ge = (new String(">="));
	String ne = (new String("<>"));
	String n = (new String("-1"));


	switch(in.getOperator().hashCode())
		{
			case 61:
			//System.out.println("matches = , change to <>, may cause problems  ");
			out.setOperator(ne);
			break;

			case 1922:
			//System.out.println("matches <> (not equal to): this will cause problem");
			out.setOperator(e);
			break;

			case 60	:
			//System.out.println("matches < ");
			out.setOperator(ge);
			break;

			case 1921:
			//System.out.println("matches <= ");
			out.setOperator(g);
			break;

			case 62	:
			//System.out.println("matches > ");
			out.setOperator(le);
			break;

			case 1983:
			//System.out.println("matches >= ");
			out.setOperator(l);
			break;

			default:
			System.out.println("Operator " + in.getOperator() + " undefined: Atom:getComplement(). Default value -1 used.");
			out.setOperator(n);
			break;

		}


	return out;

}


/*returns the complement of all the atoms present in the Vector */
public static Vector getComplement(Vector vin)
{
	if(vin == null) return null;

	Vector vout = new Vector(vin.size());
	for(int i=0;i<vin.size();i++)
	{
		Atom aout = Atom.getComplement((Atom)vin.get(i));
		vout.add(aout);
	}

	return vout;
}


}
