import java.util.*;

/** software library  */

public class comm implements Runnable
{
    private int port ; /* port on which client will send  */ 
    private int ID ;   /* unique id .  will get from the server at initialization*/
    private int CTR;   /* to count number of messages sent . will increase monotonically */
    private int MID;   /* Message id. used for tracking sequence of messages : abcast,abcast_ack,abcast2  */

    final static int READ=1;
    final static int WRITE=2;
    final static int ABCAST=0;
    final static int ABCAST_ACK=1;
    final static int ABCAST2=2;
    final static int PROBE=3;
    final static int PROBE_ACK=4;
    final static int UNDELIVERABLE=0;
    final static int DELIVERABLE=1;
    final static int CLIENT=0;
    final static int SERVER=1;



    private Abcast a;    
    private Message m,mab2;
    private AbcastAck aack;
    private Abcast2 a2,ab2;
    private CoreMessage cm;


    private Hashtable causalCheck;         
               /* contains client_id and last message delivered -- both string objects */
    private Hashtable causalQueue ;
               /* contains "client_id + messagenum" and Message object  */
    private TreeMap  abcastQueue ;
               /* contains "priority + client_id "  and Message object */
    private Hashtable abcastAckSet ;
               /* contains abcast_ack received by the clients sent by the servers */
               /* contains "client_id + message_ID" and SetObject */
    SetObject so;        
               /*  contains priority, HashSet containing unique identity String */
              /*  each client will have one */
               /* an entry will be added when an Abcast message is sent */

    Object o;



    /*  initialization of comm module */


    public comm(int ID, int port, int X, int ReceiverType)  // int X is boolean to differentiate between client and server.

    {
	this.ID=ID;   /* initialise this client/server with a unique identitification */ 
	this.CTR=1;
	this.MID=1;
	causalCheck = new Hashtable();  
	causalQueue = new Hashtable();
	abcastQueue = new TreeMap(new CompareString());
	abcastAckSet = new Hashtable();
	so = new SetObject();

	
	DataComm_app.init();  /* initialises the data structure between Application layer and comm module */
	DataSR_comm.init();   /* initialises the data structure between comm module and the lower layer */

	Thread sender=new Thread(new Send(port));   /*  instantiate the sender , which will open the send port */  
    

	/*   instantiate the receiver  , which will open the receive port at address (port + 1)  from listening  */  
	/*   threee types of receivers : */
        /*   multicast receive , point to point receive , and both multicast and point to point  */    

	if (ReceiverType==0)
	    {
		Thread t=new Thread(new ReceiveP2P(port+1));
		t.start();
	    }
	else if (ReceiverType==1)
	    {
		Thread t=new Thread(new ReceiveMulticast());
		t.start();
	    }
	else
	    {
		Thread t1=new Thread(new ReceiveP2P(port+1));
		Thread t2=new Thread(new ReceiveMulticast());
		t1.start();
		t2.start();
	    }

	sender.start();   /*   start sender thread :  single port for all types ( multicast and point to point ) */

}



    public void run()     /*  thread of comm module starts from here  */

    {

	while(true)
	    {
		try{
		Thread.sleep(2000);

		       if (!DataComm_app.App_comm.isEmpty())
			   {
			       //   Debug.dump(DataComm_app.App_comm,"A->C"); 
			       o = DataComm_app.getApp_comm();  /* received from App layer */
			       if (o.getClass().isInstance(new CoreMessage()))
				   {
				       //		       Debug.dump(" Message  is a Core Message  ");
				       processMessage((CoreMessage)o);
				   }
			       else  // we will use only 1 type of message. hence else will never be true.
				   {

				       //      Debug.dump(" Message  not a Core Message  ");
				
				   }
			       
			   }
		       
		       else
			   {
			       //			       Debug.dump(" App->Comm queue is empty . Now checking SR->Comm queue ");

			       if (!DataSR_comm.SR_comm.isEmpty())   //   receive from lower layer 
				   {
				       //  Debug.dump(DataSR_comm.SR_comm,"Received at Comm"); 
								       
				       Message m =(Message)DataSR_comm.getSR_comm();  /* received from App layer */
				       		      	       Debug.dump(m," "); 
					       //      Debug.dump(DataSR_comm.SR_comm,"In the SR->Comm  module : checking the queue just after removing an element   "); 
				       switch (m.getmessagetype())
					   {
					   case ABCAST:{ processAbcast(m);}break;
					   case ABCAST_ACK:{processAbcastAck(m);}break;
					   case ABCAST2: {processAbcast2(m);} break;

					   }
				   }
			       else
				   {
				       // System.out.println("in the comm module : no message from App or Lower Layer ");
				   }
			   }
		}
		catch(Exception e){  System.out.println(" Error in the Comm Loop  " + e ); }
	    }
    }
    


    /* ----------------------------------------------------------------- */



    public synchronized int getCounterValue()
    {

	return CTR++;  /*  vector time of the process */
	/* increments every time a message is sent */
    }


    /* ----------------------------------------------------------------- */

    public synchronized int getMessageID()
    {
	return MID++;  /* message identification  */
    }


    /* ----------------------------------------------------------------- */




    /*   read write primitives invoked by the application layer      */

    /*   send ABCAST Message                                         */


    public void processMessage(CoreMessage cm)
    {
	//	Debug.dump("Processing CoreMessage and will be sent to lower layer ");
	if(cm.getType() == READ)
	    {
		a=new Abcast(cm,READ);
		m=new Message(ID,ABCAST,this.getMessageID(),0,a,this.getCounterValue(),-1,0);
		DataSR_comm.addComm_SR(m);
		//		Debug.dump(DataSR_comm.Comm_SR, "Comm->SR ");

	    }
	else   /* cm.getType == READ) */
	    {
		/* include WRITE OPERATION  */
	    }

    }


    public void processAbcast(Message m)
    {


	//		((Abcast)m.getmessageobj()).setmessagestatus(UNDELIVERABLE);
	//	String u = new String (""+ 0 + "#" + m.getmessagesource() + "#" + m.getmessageid()); 
	//	abcastQueue.put(u,m);  // change it later 
		sendAbcastAck(m,this.getCounterValue());  // CounterValue and priority are same in this case 

    }



    /* ------------------------------------------------------------- */



    public void processAbcast2(Message m)

    {   

	       DataComm_app.addComm_app(m);
    }


    public void sendAbcastAck(Message m,int priority)

    {

	AbcastAck aack = new AbcastAck(priority);
	Message mack = new Message(ID,ABCAST_ACK,m.getmessageid(),m.getgid(),aack,priority,m.getmessagesource(),-1);
	/* here priority and CTR will have the same value */
	DataSR_comm.addComm_SR(mack);
	//	Debug.dump(DataSR_comm.Comm_SR,"Comm-Abcastack->SR ");
    } 

    public void processAbcastAck(Message m)
    {
	ab2 = new Abcast2(3);  // 1 is the priority  
	mab2 = new Message(ID,ABCAST2,m.getmessageid(),0,ab2,this.getCounterValue(),-1,0);  //gid is hard-coded as 0
	//	System.out.println("  ABCAST2 sent to queue ");
	DataSR_comm.addComm_SR(mab2);
	//       	Debug.dump(DataSR_comm.Comm_SR, "  after adding ABCAST2 to comm->SR queue ");
    }   

  }






